/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pageobject;

import com.adobe.cq.testing.selenium.pageobject.granite.BasePage;
import com.adobe.cq.testing.selenium.pagewidgets.Helpers;
import com.adobe.cq.testing.selenium.pagewidgets.common.ActionComponent;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralActionBar;
import com.adobe.cq.testing.selenium.pagewidgets.cq.EditableToolbar;
import com.adobe.cq.testing.selenium.pagewidgets.cq.PageInfo;
import com.adobe.cq.testing.selenium.pagewidgets.cq.StylesSelector;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import java.net.URI;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EditorPage
extends BasePage {
    private static final Logger LOG = LoggerFactory.getLogger(EditorPage.class);
    private static final String EDITOR_PATH = "/editor.html";
    private static final String OVERLAY_WRAPPER = "#OverlayWrapper";
    private static final String CONTENT_WRAPPER = "#ContentWrapper";
    private static final String CONTENT_FRAME = "#ContentFrame";
    private static final String EDITABLE = "[data-type='Editable']";
    private static final String COMPONENT_OVERLAY = "[data-type='Editable'][data-path='%s']";
    private static final String INSPECTABLE = "[data-type='Inspectable']";
    private static final String INSPECTABLE_COMPONENT_OVERLAY = "[data-type='Inspectable'][data-path='%s']";
    private static final String JS_EDITOR_READY_CONDITION = "window && window.Granite && window.Granite.author && true";
    private static final String JS_EDITOR_READY_SCRIPT = "if (%s) {%nvar ns = window.Granite.author;%nreturn ns.pageInfo && ns.pageInfo !== null;%n}%nreturn false";
    private PageInfo pageInfo = new PageInfo();
    private EditableToolbar editableToolbar = new EditableToolbar(this);
    private SelenideElement previewButton = Selenide.$((String)"button.editor-GlobalBar-item[data-layer='Preview']");
    protected SelenideElement selectModeButton = Selenide.$((String)"a.editor-GlobalBar-layerSwitcher");
    private SelenideElement undoButton = Selenide.$((String)"button.editor-GlobalBar-item[data-history-control='undo']");
    private SelenideElement redoButton = Selenide.$((String)"button.editor-GlobalBar-item[data-history-control='redo']");
    private ActionComponent<StylesSelector> stylesButton = new ActionComponent<Object>(Selenide.$((String)"button.js-editor-StyleSelector-toggle"), () -> new StylesSelector(StylesSelector.Variant.PAGE), false);
    private ElementsCollection textComponents = Selenide.$$((String)"div.cq-Overlay[data-text='Text']");
    private CoralActionBar actionBar = new CoralActionBar();
    private String pageName;

    private static String getEditedPagePath(String pagePath) {
        return EDITOR_PATH + pagePath + ".html";
    }

    protected EditorPage(URI base, String pagePath) {
        super(base, EditorPage.getEditedPagePath(pagePath));
    }

    protected EditorPage(String pagePath) {
        super(null, EditorPage.getEditedPagePath(pagePath));
    }

    public String getPageName() {
        return this.pageName;
    }

    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public SelenideElement getOverlayWrapper() {
        return Selenide.$((String)OVERLAY_WRAPPER);
    }

    public SelenideElement getContentWrapper() {
        return Selenide.$((String)CONTENT_WRAPPER);
    }

    public SelenideElement getContentFrame() {
        return Selenide.$((String)CONTENT_FRAME);
    }

    public SelenideElement getUndoButton() {
        return this.undoButton;
    }

    public SelenideElement getRedoButton() {
        return this.redoButton;
    }

    public SelenideElement getStylesButton() {
        return this.stylesButton.element();
    }

    public StylesSelector clickStyles() {
        return Helpers.clickBaseComponentAction(this.stylesButton);
    }

    public <T extends EditorPage> T closeStyles(StylesSelector stylesSelector) {
        if (stylesSelector != null && stylesSelector.element().is(Condition.visible)) {
            ElementUtils.clickableClick(this.stylesButton.element());
            stylesSelector.element().shouldNotBe(new Condition[]{Condition.visible});
        }
        return (T)this;
    }

    public ElementsCollection getTextComponents() {
        return this.textComponents;
    }

    protected <T extends EditorPage> T enterMode(SelenideElement targetingModeButton, SelenideElement targetingLayerButton) throws TimeoutException {
        this.selectModeButton.shouldBe(new Condition[]{Condition.visible});
        ElementUtils.clickUntil(this.selectModeButton, targetingModeButton, Condition.visible, 30L, 1L);
        ElementUtils.clickUntil(targetingModeButton, targetingLayerButton, Condition.visible, 30L, 1L);
        return (T)this;
    }

    public <T extends EditorPage> T enterPreviewMode() {
        ElementUtils.clickableClick(this.previewButton);
        Selenide.$((String)OVERLAY_WRAPPER).shouldNotBe(new Condition[]{Condition.visible});
        return (T)this;
    }

    public boolean isInPreviewMode() {
        return ElementUtils.hasWithPolling(this.previewButton, Condition.visible) && ElementUtils.hasWithPolling(this.previewButton, Condition.cssClass((String)"is-selected")) && ElementUtils.hasWithPolling(this.getOverlayWrapper(), Condition.hidden) && ElementUtils.hasWithPolling(this.getOverlayWrapper(), Condition.cssClass((String)"is-hidden"));
    }

    public EditableToolbar openEditableToolbar(String resourcePath) throws TimeoutException {
        SelenideElement targetActionBar = this.getComponentOverlay(resourcePath);
        ElementUtils.clickUntil(targetActionBar, this.editableToolbar.element(), Condition.visible, 30L, 1L);
        return this.editableToolbar;
    }

    public SelenideElement getComponentOverlay(String resourcePath) {
        return Selenide.$((String)this.getComponentOverlaySelector(resourcePath)).should(new Condition[]{Condition.exist});
    }

    private String getComponentOverlaySelector(String resourcePath) {
        return String.format(COMPONENT_OVERLAY, resourcePath);
    }

    public SelenideElement getInspectableComponentOverlay(String resourcePath) {
        return Selenide.$((String)String.format(INSPECTABLE_COMPONENT_OVERLAY, resourcePath)).should(new Condition[]{Condition.exist});
    }

    public boolean isComponentOverlaySelected(SelenideElement componentOverlay) {
        return componentOverlay.has(Condition.cssClass((String)"is-selected"));
    }

    public ElementsCollection getEditables() {
        return Selenide.$$((String)EDITABLE);
    }

    public ElementsCollection getInspectables() {
        return Selenide.$$((String)INSPECTABLE);
    }

    public CoralActionBar actionBar() {
        return this.actionBar;
    }

    private boolean isReadyCondition() {
        return Boolean.TRUE.equals(Selenide.executeJavaScript((String)"return window && window.Granite && window.Granite.author && true", (Object[])new Object[0]));
    }

    private boolean isPageReady() {
        return Boolean.TRUE.equals(Selenide.executeJavaScript((String)String.format(JS_EDITOR_READY_SCRIPT, JS_EDITOR_READY_CONDITION), (Object[])new Object[0]));
    }

    @Override
    public void waitReady() {
        Helpers.switchToAemContentFrame();
        LOG.info("waitPageReady");
        Selenide.Wait().until(webdriver -> this.isReadyCondition());
        LOG.info("precondition checked");
        Selenide.Wait().until(webdriver -> this.isPageReady());
        LOG.info("pageReady checked");
    }
}

