/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.junit.extensions;

import com.adobe.cq.testing.selenium.junit.annotations.DisableTourConfig;
import com.adobe.cq.testing.selenium.junit.extensions.SlingClientExtension;
import com.adobe.cq.testing.selenium.utils.AnnotationHelper;
import com.adobe.cq.testing.selenium.utils.DisableTour;
import com.adobe.cq.testing.selenium.utils.Network;
import java.net.URI;
import java.util.Arrays;
import java.util.Optional;
import org.apache.sling.testing.clients.SlingClient;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public final class UITestExtension
implements ParameterResolver,
BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this.isOfType(parameterContext, URI.class);
    }

    private boolean isOfType(ParameterContext context, Class ... clazz) {
        return Arrays.stream(clazz).anyMatch(p -> p.isAssignableFrom(context.getParameter().getType()));
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        URI returnedValue = null;
        SlingClient client = SlingClientExtension.Store.getInstance().recallLatest(extensionContext);
        if (client == null) {
            throw new ParameterResolutionException("No client found, make sure to request a client before it can resolve this parameter");
        }
        try {
            returnedValue = Network.getRebasedURL(client.getUrl());
        }
        catch (Exception e) {
            throw new ParameterResolutionException(e.getMessage());
        }
        return returnedValue;
    }

    private String[] getTours(ExtensionContext ec) {
        Optional<DisableTourConfig> extensionConfig = AnnotationHelper.findOptionalAnnotation(ec, DisableTourConfig.class);
        return extensionConfig.isPresent() ? extensionConfig.get().tours() : new String[]{};
    }

    private boolean doIncludeDefault(ExtensionContext ec) {
        Optional<DisableTourConfig> extensionConfig = AnnotationHelper.findOptionalAnnotation(ec, DisableTourConfig.class);
        boolean doInclude = true;
        if (extensionConfig.isPresent()) {
            doInclude = extensionConfig.get().includeDefault();
        }
        return doInclude;
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        SlingClientExtension.Store instance;
        SlingClient client;
        boolean includeDefaults = this.doIncludeDefault(context);
        String[] additionalTours = this.getTours(context);
        if ((includeDefaults || additionalTours.length > 0) && (client = (instance = SlingClientExtension.Store.getInstance()).recallLatest(context)) != null) {
            DisableTour disableTour = new DisableTour(client);
            if (includeDefaults) {
                disableTour.disableDefaultTours();
            }
            if (additionalTours.length > 0) {
                disableTour.disableTours(additionalTours);
            }
            context.getStore(ExtensionContext.Namespace.GLOBAL).put((Object)this.getDisableTourStoreKey(), (Object)disableTour);
        }
    }

    private String getDisableTourStoreKey() {
        return Thread.currentThread().getId() + "_disabletour";
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        DisableTour disableTour = (DisableTour)context.getStore(ExtensionContext.Namespace.GLOBAL).get((Object)this.getDisableTourStoreKey(), DisableTour.class);
        if (disableTour != null) {
            disableTour.restoreDefaults();
        }
    }
}

