/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.util;

import com.adobe.cq.testing.util.TestUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;

public class WCMCommands {
    public static final String CMD_CREATE_PAGE = "createPage";
    public static final String CMD_DELETE_PAGE = "deletePage";
    public static final String CMD_COPY_PAGE = "copyPage";
    public static final String CMD_MOVE_PAGE = "movePage";
    public static final String CMD_COPY_LANGUAGE = "copyLanguages";
    public static final String CMD_CREATE_VERSION = "createVersion";
    public static final String CMD_RESTORE_VERSION = "restoreVersion";
    public static final String CMD_RESTORE_TREE = "restoreTree";
    public static final String CMD_LOCK_PAGE = "lockPage";
    public static final String CMD_UNLOCK_PAGE = "unlockPage";
    public static final String CMD_ROLLOUT = "rollout";
    public static final String CMD_CREATE_SITE = "createSite";
    public static final String CMD_CREATE_LIVECOPY = "createLiveCopy";
    public static final String CMD_MODERATE_COMMENT = "moderateComment";
    public static final String CMD_MARK_COMMENT_AS_SPAM = "markCommentAsSpam";
    public static final String CMD_DELETE_COMMENT = "deleteComment";
    public static final String CMD_CREATE_LAUNCH = "createLaunch";
    public static final String CMD_DELETE_LAUNCH = "deleteLaunch";
    public static final String CMD_EDIT_LAUNCH = "editLaunch";
    public static final String CMD_CLONE_LAUNCH = "cloneLaunch";
    public static final String CMD_PROMOTE_LAUNCH = "promoteLaunch";
    public static final String CMD_CREATE_CATALOG = "createCatalog";
    public static final String CMD_ROLLOUT_SECTION = "rolloutSection";
    private SlingClient client;

    public WCMCommands(SlingClient client) {
        this.client = client;
    }

    public SlingHttpResponse createPage(String pageLabel, String pageTitle, String parentPath, String templatePath, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_CREATE_PAGE).addParameter("parentPath", parentPath).addParameter("label", pageLabel).addParameter("title", pageTitle).addParameter("template", templatePath);
        return this.executeWCMCommand(CMD_CREATE_PAGE, feb, expectedStatus);
    }

    public SlingHttpResponse deletePage(String[] pagePaths, boolean force, boolean shallow, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_DELETE_PAGE).addParameter("force", Boolean.valueOf(force).toString()).addParameter("shallow", Boolean.valueOf(shallow).toString());
        for (String val : pagePaths != null ? pagePaths : new String[]{}) {
            feb.addParameter("path", val);
        }
        return this.executeWCMCommand(CMD_DELETE_PAGE, feb, expectedStatus);
    }

    public SlingHttpResponse copyPage(String[] srcPaths, String destName, String destParentPath, String before, boolean shallow, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_COPY_PAGE).addParameter("destName", destName).addParameter("destParentPath", destParentPath).addParameter("before", before).addParameter("shallow", Boolean.valueOf(shallow).toString());
        for (String val : srcPaths != null ? srcPaths : new String[]{}) {
            feb.addParameter("srcPath", val);
        }
        return this.executeWCMCommand(CMD_COPY_PAGE, feb, expectedStatus);
    }

    public SlingHttpResponse movePage(String[] srcPaths, String destName, String destParentPath, String before, boolean shallow, boolean integrity, String[] adjusts, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_MOVE_PAGE).addParameter("destName", destName).addParameter("destParentPath", destParentPath).addParameter("before", before).addParameter("shallow", Boolean.valueOf(shallow).toString()).addParameter("integrity", Boolean.valueOf(integrity).toString());
        if (srcPaths != null) {
            for (String val : srcPaths) {
                feb.addParameter("srcPath", val);
            }
        }
        if (adjusts != null) {
            for (String val : adjusts) {
                feb.addParameter("adjust", val);
            }
        }
        return this.executeWCMCommand(CMD_MOVE_PAGE, feb, expectedStatus);
    }

    public SlingHttpResponse movePage(String[] srcPaths, String destName, String destParentPath, String before, boolean shallow, boolean integrity, String[] adjusts, String[] publishes, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_MOVE_PAGE).addParameter("destName", destName).addParameter("destParentPath", destParentPath).addParameter("before", before).addParameter("shallow", Boolean.valueOf(shallow).toString()).addParameter("integrity", Boolean.valueOf(integrity).toString());
        if (srcPaths != null) {
            for (String val : srcPaths) {
                feb.addParameter("srcPath", val);
            }
        }
        if (adjusts != null) {
            feb.addParameter("adjust", "[\"".concat(StringUtils.join((Object[])adjusts, (String)"\",\"")).concat("\"]"));
        }
        if (publishes != null) {
            feb.addParameter("publish", "[\"".concat(StringUtils.join((Object[])publishes, (String)"\",\"")).concat("\"]"));
        }
        return this.executeWCMCommand(CMD_MOVE_PAGE, feb, expectedStatus);
    }

    public SlingHttpResponse copyLanguages(String sitePath, List<BasicNameValuePair> relPaths, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_COPY_LANGUAGE).addParameter("path", sitePath);
        for (BasicNameValuePair val : relPaths) {
            feb.addParameter(val.getName(), val.getValue());
        }
        return this.executeWCMCommand(CMD_COPY_LANGUAGE, feb, expectedStatus);
    }

    public SlingHttpResponse createVersion(String pagePath, String comment, String label, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_CREATE_VERSION).addParameter("path", pagePath).addParameter("comment", comment).addParameter("label", label);
        return this.executeWCMCommand(CMD_CREATE_VERSION, feb, expectedStatus);
    }

    public SlingHttpResponse restoreVersion(String[] versionIds, String pagePath, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_RESTORE_VERSION).addParameter("path", pagePath);
        if (versionIds != null) {
            for (String val : versionIds) {
                feb.addParameter("id", val);
            }
        }
        return this.executeWCMCommand(CMD_RESTORE_VERSION, feb, expectedStatus);
    }

    public SlingHttpResponse restoreTree(String path, Date date, boolean preserveNVP, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_RESTORE_TREE).addParameter("path", path).addParameter("preserveNVP", Boolean.toString(preserveNVP));
        if (date != null) {
            feb.addParameter("date", TestUtil.ISO_DATETIME_TIME_ZONE_FORMAT.format(date));
        } else {
            feb.addParameter("date", null);
        }
        return this.executeWCMCommand(CMD_RESTORE_TREE, feb, expectedStatus);
    }

    public SlingHttpResponse lockPage(String path, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_LOCK_PAGE).addParameter("path", path);
        return this.executeWCMCommand(CMD_LOCK_PAGE, feb, expectedStatus);
    }

    public SlingHttpResponse unlockPage(String path, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_UNLOCK_PAGE).addParameter("path", path);
        return this.executeWCMCommand(CMD_UNLOCK_PAGE, feb, expectedStatus);
    }

    public SlingHttpResponse createLiveCopy(String label, String title, String destPath, String srcPath, boolean shallow, String[] rolloutConfigs, String[] missingPages, boolean excludeSubPages, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_CREATE_LIVECOPY).addParameter("title", title).addParameter("label", label).addParameter("destPath", destPath).addParameter("srcPath", srcPath).addParameter("missingPage@Delete", "true");
        WCMCommands.fillParameters(feb, "missingPage", missingPages);
        feb.addParameter("excludeSubPages@Delete", "true");
        feb.addParameter("excludeSubPages", Boolean.valueOf(excludeSubPages).toString());
        feb.addParameter("shallow@Delete", "true");
        feb.addParameter("shallow", Boolean.valueOf(shallow).toString());
        feb.addParameter("cq:rolloutConfigs@Delete", "true");
        WCMCommands.fillParameters(feb, "cq:rolloutConfigs", rolloutConfigs);
        return this.executeWCMCommand(CMD_CREATE_LIVECOPY, feb, expectedStatus);
    }

    public SlingHttpResponse createSite(String label, String title, String destPath, boolean isLiveCopy, String[] languages, String[] chapterPages, String bluePrintPath, String[] rolloutConfigs, String siteOwner, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create();
        feb.addParameter("cmd", CMD_CREATE_SITE);
        feb.addParameter("_charset_", "utf-8");
        feb.addParameter("destPath", destPath);
        feb.addParameter("./jcr:title", title);
        feb.addParameter("label", label);
        feb.addParameter("isLiveCopy@Delete", "true");
        feb.addParameter("isLiveCopy", Boolean.valueOf(isLiveCopy).toString());
        if (languages != null) {
            feb.addParameter("msm:masterPages@Delete", "true");
            for (String val : languages) {
                feb.addParameter("msm:masterPages", val);
            }
        }
        if (chapterPages != null) {
            feb.addParameter("msm:chapterPages@Delete", "true");
            WCMCommands.fillParameters(feb, "msm:chapterPages", chapterPages);
        }
        if (rolloutConfigs != null) {
            feb.addParameter("cq:rolloutConfigs@Delete", "true");
            WCMCommands.fillParameters(feb, "cq:rolloutConfigs", rolloutConfigs);
        }
        feb.addParameter("srcPath", bluePrintPath);
        feb.addParameter("./cq:siteOwner", siteOwner);
        return this.executeWCMCommand(CMD_CREATE_SITE, feb, expectedStatus);
    }

    public SlingHttpResponse moderateComment(String commentPath, boolean approve, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_MODERATE_COMMENT).addParameter("path", commentPath).addParameter("approve", Boolean.valueOf(approve).toString());
        return this.executeWCMCommand(CMD_MODERATE_COMMENT, feb, expectedStatus);
    }

    public SlingHttpResponse markCommentAsSpam(String commentPath, boolean spam, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_MARK_COMMENT_AS_SPAM).addParameter("path", commentPath).addParameter("spam", Boolean.valueOf(spam).toString());
        return this.executeWCMCommand(CMD_MARK_COMMENT_AS_SPAM, feb, expectedStatus);
    }

    public SlingHttpResponse deleteComment(String commentPath, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_DELETE_COMMENT).addParameter("path", commentPath);
        return this.executeWCMCommand(CMD_DELETE_COMMENT, feb, expectedStatus);
    }

    public SlingHttpResponse rollout(String[] sourcePaths, String[] targetPaths, String[] paragraphPaths, String type, boolean reset, boolean useBackgroundJob, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_ROLLOUT).addParameter("type", type).addParameter("reset", String.valueOf(reset)).addParameter("sling:bg", Boolean.valueOf(useBackgroundJob).toString());
        WCMCommands.fillParameters(feb, "path", sourcePaths);
        WCMCommands.fillParameters(feb, "paras", paragraphPaths);
        WCMCommands.fillParameters(feb, "msm:targetPath", targetPaths);
        return this.executeWCMCommand(CMD_ROLLOUT, feb, expectedStatus);
    }

    public SlingHttpResponse createLaunch(String title, String srcPath, Calendar liveDate, boolean ignoreSubPages, boolean isLiveCopy, String template, String[] sourceRolloutConfigs, String[] promoteRolloutConfigs, int ... expectedStatus) throws ClientException {
        ArrayList<String> srcPathList = new ArrayList<String>();
        srcPathList.add(srcPath);
        ArrayList<Boolean> ignoreSubPagesList = new ArrayList<Boolean>();
        ignoreSubPagesList.add(ignoreSubPages);
        return this.createLaunch(title, srcPathList, liveDate, ignoreSubPagesList, isLiveCopy, template, sourceRolloutConfigs, promoteRolloutConfigs);
    }

    public SlingHttpResponse createLaunch(String title, ArrayList<String> srcPathList, Calendar liveDate, ArrayList<Boolean> ignoreSubPagesList, boolean isLiveCopy, String template, String[] sourceRolloutConfigs, String[] promoteRolloutConfigs) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create();
        feb.addParameter("cmd", CMD_CREATE_LAUNCH);
        feb.addParameter("title", title);
        for (String srcPath : srcPathList) {
            feb.addParameter("srcPathList", srcPath);
        }
        if (liveDate != null) {
            feb.addParameter("liveDate@TypeHint", "Date");
            feb.addParameter("liveDate", TestUtil.ISO_DATETIME_TIME_ZONE_FORMAT.format(liveDate.getTime()));
        }
        feb.addParameter("shallow@Delete", "true");
        for (Boolean ignoreSubPages : ignoreSubPagesList) {
            feb.addParameter("shallowList", ignoreSubPages.toString());
        }
        feb.addParameter("isLiveCopy@Delete", "true");
        feb.addParameter("isLiveCopy", Boolean.valueOf(isLiveCopy).toString());
        if (template != null) {
            feb.addParameter("template", template);
        }
        WCMCommands.fillParameters(feb, "sourceRolloutConfigs", sourceRolloutConfigs);
        WCMCommands.fillParameters(feb, "promoteRolloutConfigs", promoteRolloutConfigs);
        return this.executeWCMCommand(CMD_CREATE_LAUNCH, feb, new int[0]);
    }

    public SlingHttpResponse editLaunch(String launchPath, ArrayList<String> srcPathList, ArrayList<Boolean> ignoreSubPagesList) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create();
        feb.addParameter("cmd", CMD_EDIT_LAUNCH);
        feb.addParameter("path", launchPath);
        for (String srcPath : srcPathList) {
            feb.addParameter("srcPathList", srcPath);
        }
        feb.addParameter("shallow@Delete", "true");
        for (Boolean ignoreSubPages : ignoreSubPagesList) {
            feb.addParameter("shallowList", ignoreSubPages.toString());
        }
        return this.executeWCMCommand(CMD_EDIT_LAUNCH, feb, new int[0]);
    }

    public SlingHttpResponse deleteLaunch(String path, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create();
        feb.addParameter("cmd", CMD_DELETE_LAUNCH);
        feb.addParameter("path", path);
        return this.executeWCMCommand(CMD_CREATE_LAUNCH, feb, expectedStatus);
    }

    public SlingHttpResponse cloneLaunch(String orgPath, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create();
        feb.addParameter("cmd", CMD_CLONE_LAUNCH);
        feb.addParameter("path", orgPath);
        return this.executeWCMCommand(CMD_CLONE_LAUNCH, feb, expectedStatus);
    }

    public SlingHttpResponse promoteLaunch(String path, boolean promoteSubPages, String target, String workflowPackage, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create();
        feb.addParameter("cmd", CMD_PROMOTE_LAUNCH);
        feb.addParameter("path", path);
        if (promoteSubPages) {
            feb.addParameter("promotionScope", "deep");
        } else {
            feb.addParameter("promotionScope", "resource");
        }
        if (target != null) {
            feb.addParameter("target", target);
        }
        if (workflowPackage != null) {
            feb.addParameter("workflowPackage", workflowPackage);
        }
        return this.executeWCMCommand(CMD_PROMOTE_LAUNCH, feb, expectedStatus);
    }

    public SlingHttpResponse createCatalog(String source, String dest, String label, String title, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("cmd", CMD_CREATE_CATALOG).addParameter("srcPath", source).addParameter("destPath", dest).addParameter("label", label).addParameter("title", title).addParameter("_charset_", "utf-8");
        return this.executeWCMCommand(CMD_CREATE_CATALOG, form, expectedStatus);
    }

    public SlingHttpResponse rolloutSection(String source, String dest, boolean force, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("cmd", CMD_ROLLOUT_SECTION).addParameter("srcPath", source).addParameter("destPath", dest).addParameter("force", force ? "true" : "false").addParameter("_charset_", "utf-8");
        return this.executeWCMCommand(CMD_ROLLOUT_SECTION, form, expectedStatus);
    }

    private static void fillParameters(FormEntityBuilder formEntityBuilder, String paramName, String ... values) {
        if (values != null && values.length > 0) {
            for (String value : values) {
                formEntityBuilder.addParameter(paramName, value);
            }
        }
    }

    private SlingHttpResponse executeWCMCommand(String cmd, FormEntityBuilder fb, int ... expectedStatus) throws ClientException {
        try {
            return this.client.doPost("/bin/wcmcommand", (HttpEntity)fb.build(), expectedStatus);
        }
        catch (Exception e) {
            throw new ClientException("Sending WCM Command '" + cmd + "' failed!", (Throwable)e);
        }
    }
}

