/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.rules;

import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.osgi.OsgiInstanceConfig;
import org.apache.sling.testing.clients.util.config.InstanceConfig;
import org.apache.sling.testing.clients.util.config.InstanceConfigException;
import org.apache.sling.testing.clients.util.config.impl.InstanceConfigCacheImpl;
import org.apache.sling.testing.junit.rules.instance.Instance;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiConfigRestoreRule
extends ExternalResource {
    private final Logger logger = LoggerFactory.getLogger(OsgiConfigRestoreRule.class);
    private final String pid;
    private final Instance quickstartRule;
    private SlingClient client;
    private InstanceConfigCacheImpl configs;

    public OsgiConfigRestoreRule(Instance quickstartRule, String pid) {
        this.pid = pid;
        this.quickstartRule = quickstartRule;
    }

    protected void before() throws ClientException, InstanceConfigException, InterruptedException {
        this.client = this.quickstartRule.getAdminClient(SlingClient.class);
        this.configs = new InstanceConfigCacheImpl();
        this.configs.add((InstanceConfig)new OsgiInstanceConfig(this.client, this.pid));
    }

    protected void after() {
        try {
            this.configs.restore();
        }
        catch (InterruptedException | InstanceConfigException e) {
            this.logger.error("Could not restore OSGi config.", e);
        }
    }
}

