/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.security;

import com.adobe.cq.testing.client.SecurityClient;
import com.adobe.cq.testing.client.security.Authorizable;
import com.fasterxml.jackson.databind.JsonNode;
import org.apache.http.HttpEntity;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.JsonUtils;

public class CQPreferences {
    public static final String PREFERENCES_NODE = "preferences";
    public static final String SELECTOR = ".preferences";
    public static final String LANGUAGE_PROPERTY = "language";
    public static final String LANGUAGE_EN = "en";
    public static final String LANGUAGE_DE = "de";
    public static final String LANGUAGE_FR = "fr";
    protected SecurityClient client;
    protected Authorizable authorizable;
    protected String path;

    public CQPreferences(Authorizable authorizable) throws ClientException {
        if (authorizable == null) {
            throw new IllegalArgumentException("Authorizable may not be null!");
        }
        this.authorizable = authorizable;
        this.client = authorizable.getClient();
        this.path = authorizable.getHomePath() + "." + SELECTOR;
    }

    public SecurityClient getClient() {
        return this.client;
    }

    public Authorizable getAuthorizable() {
        return this.authorizable;
    }

    public String getPath() throws ClientException {
        return this.path;
    }

    public JsonNode getJson(int ... expectedStatus) throws ClientException {
        return JsonUtils.getJsonNodeFromString((String)this.client.doGet(this.authorizable.getHomePath() + SELECTOR + ".json", HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus)).getContent());
    }

    public String getLanguage() throws ClientException {
        JsonNode lang = this.getJson(new int[0]).get(LANGUAGE_PROPERTY);
        return lang == null ? LANGUAGE_EN : lang.asText();
    }

    public SlingHttpResponse setLanguage(String language) throws ClientException {
        if (language == null) {
            language = LANGUAGE_EN;
        }
        FormEntityBuilder feb = FormEntityBuilder.create();
        feb.addParameter("_charset_", "utf-8");
        feb.addParameter("./language", language);
        return this.client.doPost(this.authorizable.getHomePath() + "/" + PREFERENCES_NODE, (HttpEntity)feb.build(), new int[]{201});
    }
}

