/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.security;

import com.adobe.cq.testing.client.SecurityClient;
import com.adobe.cq.testing.client.security.Authorizable;
import com.adobe.cq.testing.client.security.Group;
import com.adobe.cq.testing.client.security.User;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthorizable
implements Authorizable {
    private static final String AUTHORIZABLES = "authorizables";
    private static final String HOME = "home";
    private static final int TIMEOUT = 60000;
    private static final int DELAY = 500;
    protected SecurityClient client;
    protected String authorizableId;
    protected String authorizablePath;
    private String authorizableUrl;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAuthorizable.class);

    public <T extends SecurityClient> AbstractAuthorizable(T client, String authorizableId) throws ClientException, InterruptedException {
        if (client == null) {
            throw new IllegalArgumentException("Client must not be null!");
        }
        if (authorizableId == null) {
            throw new IllegalArgumentException("AuthorizableId must not be null!");
        }
        this.client = client;
        this.authorizableId = authorizableId;
        this.authorizablePath = this.getAuthorizablePath(authorizableId);
        if (this.authorizablePath == null) {
            throw new ClientException("Failed to retrieve authorizable path for " + authorizableId);
        }
        this.authorizableUrl = AbstractAuthorizable.encodePathToURL(this.authorizablePath);
    }

    @Override
    public SecurityClient getClient() {
        return this.client;
    }

    @Override
    public String getId() {
        return this.authorizableId;
    }

    @Override
    public String getHomePath() {
        return this.authorizablePath;
    }

    @Override
    public String getHomeUrl() {
        return this.authorizableUrl;
    }

    @Override
    public String getJsonAsString(String propsFilter, int ... expectedStatus) throws ClientException {
        List<BasicNameValuePair> params = Collections.singletonList(new BasicNameValuePair("props", propsFilter != null ? propsFilter : "*"));
        return this.doGet(params, expectedStatus).getContent();
    }

    @Override
    public String getUserPropertiesJsonAsString(int ... expectedStatus) throws ClientException {
        return this.client.doGet(this.getHomePath() + ".userproperties" + ".json", expectedStatus).getContent();
    }

    public static boolean exists(SecurityClient client, String authorizableId) throws ClientException {
        JsonNode authorizables = AbstractAuthorizable.getAuthorizables(client, AbstractAuthorizable.getQuery(authorizableId));
        return authorizables != null && authorizables.size() != 0;
    }

    @Override
    public boolean exists() throws ClientException {
        return AbstractAuthorizable.exists(this.client, this.authorizableId);
    }

    public boolean exists(String query) throws ClientException {
        JsonNode authorizables = this.getAuthorizables(query);
        return authorizables != null && authorizables.size() != 0;
    }

    @Override
    public SlingHttpResponse delete(int ... expectedStatus) throws ClientException {
        FormEntityBuilder formEntry = FormEntityBuilder.create();
        formEntry.addParameter("_charset_", "utf-8");
        formEntry.addParameter("deleteAuthorizable", "1");
        return this.doPost(formEntry, expectedStatus);
    }

    @Override
    public <T extends SecurityClient> Authorizable create(T client, Class<? extends AbstractAuthorizable> authorizableClass, String authorizableId, FormEntityBuilder formParameters, int ... expectedStatus) throws ClientException {
        return client.getManager().create(client, authorizableClass, authorizableId, formParameters, expectedStatus);
    }

    @Override
    public Map<String, Authorizable> getMemberOf() throws ClientException, InterruptedException {
        JsonNode authorizableNode = JsonUtils.getJsonNodeFromString((String)this.getJsonAsString("memberOf", 200));
        JsonNode propsNode = null;
        if (authorizableNode != null) {
            propsNode = authorizableNode.get("memberOf");
        }
        return this.buildAuthorizableList(propsNode);
    }

    @Override
    public Map<String, Authorizable> getMembers() throws ClientException, InterruptedException {
        JsonNode authorizableNode = JsonUtils.getJsonNodeFromString((String)this.getJsonAsString("members", 200));
        JsonNode propsNode = null;
        if (authorizableNode != null) {
            propsNode = authorizableNode.get("members");
        }
        return this.buildAuthorizableList(propsNode);
    }

    @Override
    public Map<String, Authorizable> getImpersonators() throws ClientException, InterruptedException {
        JsonNode authorizableNode = JsonUtils.getJsonNodeFromString((String)this.getJsonAsString("impersonators", 200));
        JsonNode propsNode = null;
        if (authorizableNode != null) {
            propsNode = authorizableNode.get("impersonators");
        }
        return this.buildAuthorizableList(propsNode);
    }

    @Override
    public boolean isImpersonated() throws ClientException {
        JsonNode authorizableNode = JsonUtils.getJsonNodeFromString((String)this.getJsonAsString(null, 200));
        JsonNode isImpersonated = authorizableNode.get("isImpersonated");
        return isImpersonated != null && "true".equals(isImpersonated.asText());
    }

    @Override
    public JsonNode getProfile() throws ClientException {
        JsonNode authorizableNode = JsonUtils.getJsonNodeFromString((String)this.getJsonAsString("profile/*", new int[0]));
        JsonNode propsNode = null;
        if (authorizableNode != null) {
            propsNode = authorizableNode.get("profile");
        }
        return propsNode;
    }

    public SlingHttpResponse doPost(FormEntityBuilder formParameters, int ... expectedStatus) throws ClientException {
        String homeURL = this.getHomeUrl();
        return this.client.doPost(homeURL + ".rw" + ".html", (HttpEntity)formParameters.build(), expectedStatus);
    }

    public SlingHttpResponse doGet(List<NameValuePair> parameters, int ... expectedStatus) throws ClientException {
        return this.client.doGet(this.getHomeUrl() + ".rw" + ".json", parameters, expectedStatus);
    }

    public static Class<? extends AbstractAuthorizable> getAuthorizableClass(String authorizableType) {
        return "user".equals(authorizableType) ? User.class : Group.class;
    }

    private String getAuthorizablePath(String authorizableId) throws ClientException, InterruptedException {
        return this.getAuthorizableNodeWithRetry(authorizableId).path(HOME).textValue();
    }

    private String getAuthorizableType(String authorizableId) throws ClientException, InterruptedException {
        return this.getAuthorizableNodeWithRetry(authorizableId).path("type").textValue();
    }

    private JsonNode getAutorizablesWithRetry(final String query) throws ClientException, InterruptedException {
        try {
            class AuthorizablesPolling
            extends Polling {
                public JsonNode authorizables;
                final /* synthetic */ AbstractAuthorizable this$0;

                AuthorizablesPolling() {
                    this.this$0 = this$0;
                }

                public Boolean call() throws Exception {
                    this.authorizables = this.this$0.getAuthorizables(query);
                    if (this.authorizables == null) {
                        throw new ClientException("getAuthorizables returned null");
                    }
                    if (this.authorizables.size() != 1) {
                        throw new ClientException("getAuthorizables returned " + this.authorizables.size() + " elements, expected 1");
                    }
                    return true;
                }
            }
            AuthorizablesPolling polling = new AuthorizablesPolling();
            polling.poll(60000L, 500L);
            return polling.authorizables;
        }
        catch (TimeoutException e) {
            throw new ClientException("Failed to retrieve authorizables in 60000 ms", (Throwable)e);
        }
    }

    private static JsonNode getAuthorizables(SecurityClient client, String query) throws ClientException {
        String authorizablesJson = client.getManager().getAuthorizablesJson(query);
        return JsonUtils.getJsonNodeFromString((String)authorizablesJson).get(AUTHORIZABLES);
    }

    private JsonNode getAuthorizables(String query) throws ClientException {
        return AbstractAuthorizable.getAuthorizables(this.client, query);
    }

    private JsonNode getAuthorizableNodeWithRetry(String authorizableId) throws ClientException, InterruptedException {
        String query = AbstractAuthorizable.getQuery(authorizableId);
        JsonNode authorizables = this.getAutorizablesWithRetry(query);
        if (authorizables == null || authorizables.size() != 1) {
            throw new ClientException("Authorizable " + authorizableId + " not found!");
        }
        return authorizables.get(0);
    }

    public static String getQuery(String authorizableId) {
        return "\"condition\":[{\"named\":\"" + StringEscapeUtils.escapeJson((String)authorizableId) + "\"}]";
    }

    public static String buildAuthorizablePath(String authorizableId, String rootPath, String intermediatePath) throws ClientException {
        String authorizablePath;
        boolean buildDefaultPath;
        boolean bl = buildDefaultPath = intermediatePath == null || "".equals(intermediatePath);
        if (buildDefaultPath) {
            authorizablePath = rootPath;
            authorizablePath = authorizablePath + "/";
            authorizablePath = authorizablePath + AbstractAuthorizable.escapeIllegalJcrChars(authorizableId.substring(0, 1));
        } else {
            authorizablePath = intermediatePath;
        }
        authorizablePath = authorizablePath + "/" + AbstractAuthorizable.escapeIllegalJcrChars(authorizableId);
        return authorizablePath;
    }

    protected static String encodePathToURL(String authorizableHomePath) throws ClientException {
        String authorizableUrl = "";
        try {
            StringTokenizer st = new StringTokenizer(authorizableHomePath, "/");
            while (st.hasMoreElements()) {
                String nn = (String)st.nextElement();
                authorizableUrl = authorizableUrl + "/" + URLEncoder.encode(nn, "UTF-8").replaceAll("\\+", "%20");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("Error occurred while URL encoding the path to authorizable!", (Throwable)e);
        }
        return authorizableUrl;
    }

    protected static String encodeURI(String unescapedPath) throws ClientException {
        try {
            return new URI(null, null, unescapedPath, null).toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new ClientException("Could not encode URI: " + unescapedPath);
        }
    }

    protected Map<String, Authorizable> buildAuthorizableList(JsonNode authorizableJsonNode) throws ClientException, InterruptedException {
        if (authorizableJsonNode == null) {
            throw new IllegalArgumentException("JSON of authorizable may not be null!");
        }
        LinkedHashMap<String, Authorizable> authorizables = new LinkedHashMap<String, Authorizable>();
        if (authorizableJsonNode.isArray()) {
            for (int i = 0; i < authorizableJsonNode.size(); ++i) {
                Authorizable authorizable = this.buildAuthorizable(authorizableJsonNode.get(i));
                authorizables.put(authorizable.getId(), authorizable);
            }
        } else {
            Authorizable authorizable = this.buildAuthorizable(authorizableJsonNode);
            authorizables.put(authorizable.getId(), authorizable);
        }
        return authorizables;
    }

    private Authorizable buildAuthorizable(JsonNode authorizableNode) throws ClientException, InterruptedException {
        String authorizableId = authorizableNode.get("authorizableId").asText();
        String type = this.getAuthorizableType(authorizableId);
        return this.client.getManager().getAuthorizable(AbstractAuthorizable.getAuthorizableClass(type), authorizableId);
    }

    private static String escapeIllegalJcrChars(String name) {
        String illegal = "%/:[]*|\t\r\n";
        StringBuilder buffer = new StringBuilder(name.length() * 2);
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if ("%/:[]*|\t\r\n".indexOf(ch) != -1 || ch == '.' && name.length() < 3 || ch == ' ' && (i == 0 || i == name.length() - 1)) {
                buffer.append('%');
                buffer.append(Character.toUpperCase(Character.forDigit(ch / 16, 16)));
                buffer.append(Character.toUpperCase(Character.forDigit(ch % 16, 16)));
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }
}

