/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.obj;

import com.adobe.icc.dbforms.obj.DataModule;
import com.adobe.icc.dbforms.obj.MimeType;
import com.adobe.livecycle.content.model.annotation.Field;
import com.adobe.livecycle.content.model.annotation.Node;
import com.adobe.livecycle.content.sling.ResourceResolverHolder;
import com.day.cq.wcm.foundation.Image;
import com.day.image.Layer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.codec.binary.Base64;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

@Node(folder="modules/images", splitOn="_default", superType="com.adobe.icc.dbforms.obj.DataModule")
@XmlType
public class ImageModule
extends DataModule {
    private static final long serialVersionUID = -5156606718450851188L;
    public static final String IM_CLASS = ImageModule.class.getName();
    public static final String ASSOCIATION_CUTPOINT = "/" + IM_CLASS + "/*" + "|" + "/" + IM_CLASS + "/ucat/id" + "|" + "/" + IM_CLASS + "/lcat/id" + "|" + "/" + IM_CLASS + "/variableList//*";
    public static final String HIERARCHY_CUTPOINT = "/" + IM_CLASS + "//*";
    public static final String FIRST_LEVEL_CUTPOINT = "/" + IM_CLASS + "/*";
    @Field(jcrPropertyName="jcr:title")
    private String jcrTitle;
    private String fileName;
    private String fileReference;
    private String width;
    private String height;
    private String altText;
    private String imageRotate;
    private String imageCrop;
    MimeType mimeType;
    private String caption;
    @Field(shortlived=true)
    private transient String serverFilePath;
    @Field(shortlived=true)
    private transient Image image;
    private byte[] imageBlob;

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getTitle() {
        return this.jcrTitle != null ? this.jcrTitle : this.title;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileReference() {
        return this.fileReference;
    }

    public void setFileReference(String fileReference) {
        this.fileReference = fileReference;
    }

    public void setImageBlob(byte[] imageBlob) {
        this.imageBlob = imageBlob;
    }

    @XmlTransient
    public byte[] getImageBlob() {
        Layer layer;
        if (this.imageBlob == null && (layer = this.getLayer()) != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                layer.write(null, 1.0, (OutputStream)byteArrayOutputStream);
                this.imageBlob = byteArrayOutputStream.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.imageBlob != null ? (Base64.isBase64((byte[])this.imageBlob) ? this.imageBlob : Base64.encodeBase64((byte[])this.imageBlob)) : this.imageBlob;
    }

    public MimeType getMimeType() {
        if (this.mimeType == null) {
            Image image = this.getImage();
            try {
                this.mimeType = MimeType.fromValue(image.getMimeType());
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
        return this.mimeType;
    }

    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setServerFilePath(String filePath) {
        this.serverFilePath = filePath;
    }

    public String getServerFilePath() {
        return this.serverFilePath;
    }

    public Image getImage() {
        ResourceResolver resolver;
        Resource imageResource;
        if (this.image == null && (imageResource = (resolver = ResourceResolverHolder.getResourceResolver()).getResource(this.getId())) != null) {
            this.image = new Image(imageResource);
        }
        return this.image;
    }

    private Layer getLayer() {
        Layer layer = null;
        Image image = this.getImage();
        if (image.hasContent()) {
            try {
                layer = image.getLayer(true, true, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return layer;
    }

    public String getWidth() {
        Layer layer;
        if (this.width == null && (layer = this.getLayer()) != null) {
            this.width = String.valueOf(layer.getImage().getWidth());
        }
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        Layer layer;
        if (this.height == null && (layer = this.getLayer()) != null) {
            this.height = String.valueOf(layer.getImage().getHeight());
        }
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getAltText() {
        return this.altText;
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    public String getImageRotate() {
        return this.imageRotate;
    }

    public void setImageRotate(String imageRotate) {
        this.imageRotate = imageRotate;
    }

    public String getImageCrop() {
        return this.imageCrop;
    }

    public void setImageCrop(String imageCrop) {
        this.imageCrop = imageCrop;
    }

    public String getImageSrc() {
        Image image = this.getImage();
        if (image.hasContent()) {
            image.setSelector(".img");
            return image.getSrc();
        }
        return null;
    }
}

