/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dct.transfer;

import com.adobe.dct.exception.DCTException;
import com.adobe.dct.exception.LogLevels;
import com.adobe.dct.exception.MessageLogger;
import com.adobe.dct.transfer.DataDictionary;
import com.adobe.dct.transfer.DataDictionaryElement;
import com.adobe.dct.transfer.DataDictionaryElementType;
import com.adobe.fd.content.fdinternal.model.SchemaRefType;
import com.adobe.fd.df.fdinternal.api.services.SchemaInstance;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public final class DataDictionaryInstance
implements SchemaInstance,
Serializable {
    private static final long serialVersionUID = -5735672860442274994L;
    private Object object;
    private String dataDictionaryId;
    private DataDictionary dataDictionary;
    private byte[] compressedDDBytes;

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public String getDataDictionaryId() {
        return this.dataDictionaryId;
    }

    public void setDataDictionaryId(String dataDictionaryId) {
        this.dataDictionaryId = dataDictionaryId;
    }

    public DataDictionary getDataDictionary() {
        return this.dataDictionary;
    }

    public void setDataDictionary(DataDictionary dataDictionary) {
        this.dataDictionary = dataDictionary;
    }

    public Object getValue(String id) {
        return this.getValue2(id);
    }

    public Object getValue2(String variableName) {
        Object value = null;
        if (this.dataDictionary == null || this.dataDictionary.getReferenceNameToPathMap() == null) {
            MessageLogger.logMessage(DataDictionaryInstance.class, LogLevels.LOG_ERROR, "ALC-DCT-002-057");
            return null;
        }
        String ddElementKey = variableName;
        if (variableName.startsWith("DD_" + this.dataDictionary.getName() + ".")) {
            ddElementKey = variableName.substring(variableName.indexOf(".") + 1);
        } else if (variableName.startsWith("DD_")) {
            int ddeSeparatorIndex = variableName.indexOf("_", 3);
            if (ddeSeparatorIndex == -1) {
                value = this.getObject();
            } else {
                ddElementKey = variableName.substring(ddeSeparatorIndex + 1);
            }
        }
        String path = this.dataDictionary.getReferenceNameToPathMap().get(ddElementKey);
        if (path == null) {
            path = ddElementKey;
        }
        value = this.getValueFromObject(this.object, path);
        return value;
    }

    private Object getValueFromObject(Object object, String path) {
        ArrayList<Object> value = null;
        if (path != null && object != null) {
            String[] elementNames = path.split("\\.");
            for (int index = 0; index < elementNames.length; ++index) {
                String elementName = elementNames[index].trim();
                if (elementName.equals("")) continue;
                if (path == null || object == null) break;
                if (object instanceof Map) {
                    if (index < elementNames.length - 1) {
                        path = path.substring(path.indexOf(".") + 1);
                        object = ((Map)object).get(elementName);
                        continue;
                    }
                    value = ((Map)object).get(elementName);
                    return value;
                }
                if (!(object instanceof List)) continue;
                value = new ArrayList();
                Object tempObject = null;
                for (int i = 0; i < ((List)object).size(); ++i) {
                    tempObject = ((List)object).get(i);
                    ((List)value).add(this.getValueFromObject(tempObject, path));
                }
                return value;
            }
        }
        return value;
    }

    public void setValue(String id, Object value) throws Exception {
        this.setValue2(id, value);
    }

    private void setValue2(String ddElementKey, Object value) throws DCTException {
        if (this.dataDictionary == null || this.dataDictionary.getReferenceNameToPathMap() == null) {
            MessageLogger.logMessage(DataDictionaryInstance.class, LogLevels.LOG_ERROR, "ALC-DCT-002-057");
            return;
        }
        String path = this.dataDictionary.getReferenceNameToPathMap().get(ddElementKey);
        if (path == null) {
            path = ddElementKey;
        }
        DataDictionaryElement currentDDE = null;
        if (this.dataDictionary == null) {
            MessageLogger.logMessage(this.getClass(), LogLevels.LOG_ERROR, "ALC-DCT-002-057");
            throw new DCTException("ALC-DCT-002-057");
        }
        currentDDE = this.dataDictionary.getDDElements().get(0);
        this.setValueInObject(this.object, path, value, currentDDE);
    }

    private void setValueInObject(Object object, String path, Object value, DataDictionaryElement currentDDE) {
        if (path != null && object != null) {
            String[] elementNames = path.split("\\.");
            for (int index = 0; index < elementNames.length; ++index) {
                Object childObject;
                String elementName = elementNames[index].trim();
                if (elementName.equals("")) continue;
                if (path == null || object == null) break;
                if (index > 0) {
                    currentDDE = this.getChildByName(elementNames[index], currentDDE);
                }
                if (object instanceof Map) {
                    if (index < elementNames.length - 1) {
                        path = path.substring(path.indexOf(".") + 1);
                        childObject = ((Map)object).get(elementName);
                        if (childObject == null) {
                            if (currentDDE.getElementType() == DataDictionaryElementType.COMPOSITE) {
                                ((Map)object).put(elementName, new HashMap());
                            } else if (currentDDE.getElementType() == DataDictionaryElementType.COLLECTION) {
                                ((Map)object).put(elementName, new ArrayList());
                            } else {
                                return;
                            }
                        }
                        object = ((Map)object).get(elementName);
                        continue;
                    }
                    ((Map)object).put(elementName, value);
                    continue;
                }
                if (!(object instanceof List)) continue;
                childObject = null;
                Object tempValue = null;
                for (int i = 0; i < ((List)value).size(); ++i) {
                    int sz = ((List)object).size();
                    if (i >= sz) {
                        ((List)object).add(new HashMap());
                    }
                    childObject = ((List)object).get(i);
                    tempValue = ((List)value).get(i);
                    this.setValueInObject(childObject, path, tempValue, currentDDE);
                }
            }
        }
    }

    private DataDictionaryElement getChildByName(String name, DataDictionaryElement dde) {
        DataDictionaryElement childDDE = null;
        block0 : switch (dde.getElementType()) {
            case COMPOSITE: {
                for (DataDictionaryElement child : dde.getChildElements()) {
                    if (!child.getName().equals(name)) continue;
                    childDDE = child;
                    break block0;
                }
                break;
            }
            case COLLECTION: {
                if (dde.getCollectionElement().getElementType() != DataDictionaryElementType.COMPOSITE) break;
                childDDE = this.getChildByName(name, dde.getCollectionElement());
                break;
            }
        }
        return childDDE;
    }

    public byte[] getCompressedDDBytes() {
        return this.compressedDDBytes;
    }

    public void setCompressedDDBytes(byte[] compressedDDBytes) {
        this.compressedDDBytes = compressedDDBytes;
    }

    public String getSchemaRef() {
        return this.getDataDictionaryId();
    }

    public SchemaRefType getSchemaType() {
        return SchemaRefType.DATA_DICTIONARY;
    }

    public Object getSchema() {
        return this.getDataDictionary();
    }

    public void setSchema(Object schema) {
        if (schema instanceof DataDictionary) {
            this.setDataDictionary((DataDictionary)schema);
        }
    }

    public String getVariableIdentifier() {
        return "DD_";
    }
}

