/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.common.FormsGuideException;
import com.adobe.aemds.guide.utils.CustomJSONWriter;
import com.adobe.aemds.guide.utils.GuideProgressiveUtils;
import com.adobe.aemds.guide.utils.NodeStructureUtils;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProgressiveOrderingGenerator {
    private static Logger logger = LoggerFactory.getLogger(DefaultProgressiveOrderingGenerator.class);
    private ResourceResolver resourceResolver;
    private CustomJSONWriter jsonWriter = null;
    int sectionId = 0;
    int fieldCounter = 0;

    public DefaultProgressiveOrderingGenerator(ResourceResolver resResolver) {
        this.resourceResolver = resResolver;
    }

    public String generateProgressiveOrdering(JSONObject guideContainerJson) throws FormsGuideException {
        try {
            JSONObject rootPanel = guideContainerJson.getJSONObject("rootPanel");
            StringWriter stringWriter = new StringWriter();
            this.jsonWriter = new CustomJSONWriter(stringWriter);
            this.jsonWriter.object();
            String fragPrefixString = null;
            String fragRef = this.getJsonValue(rootPanel, "fragRef");
            if (fragRef != null) {
                String path = this.getJsonValue(rootPanel, "jcr:path");
                Resource panel = this.resourceResolver.getResource(path);
                fragPrefixString = NodeStructureUtils.getFragPrefixString(panel, null);
            }
            this.generateSectionForPanel(rootPanel, fragPrefixString);
            this.jsonWriter.key("completion").object();
            this.jsonWriter.key("completionTitle").value("Submit the form");
            this.jsonWriter.key("completionAfterMessage").value("Thank you for submitting the form.");
            this.jsonWriter.key("completionBeforeMessage").value("Do you want to submit the form?");
            this.jsonWriter.key("completionButtonText").value("Submit");
            this.jsonWriter.key("guideNodeClass").value("guideProgressiveCompletionSection");
            this.jsonWriter.key("completionScript").value("window.guideBridge.submit(options)");
            this.jsonWriter.key("completionSuccessScript").value("");
            this.jsonWriter.key("completionFailureScript").value("");
            this.jsonWriter.endObject();
            this.jsonWriter.endObject();
            return stringWriter.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new FormsGuideException(e);
        }
    }

    private void generateSectionForPanel(JSONObject panel, String fragPrefixString) throws JSONException {
        int maxOccur = Integer.valueOf(this.getOrElse(panel, "maxOccur", "1"));
        if (maxOccur < 0 || maxOccur > 1) {
            this.writeProgressiveSectionJson(panel, true, this.getFields(panel, false, fragPrefixString), fragPrefixString);
            return;
        }
        List<FieldFragRefMapping> directFields = this.getFields(panel, true, fragPrefixString);
        if (directFields.size() > 0) {
            this.writeProgressiveSectionJson(panel, false, directFields, fragPrefixString);
        }
        JSONObject panelItems = null;
        if (panel.has("items") && panel.get("items") instanceof JSONObject) {
            panelItems = panel.getJSONObject("items");
            Iterator itemIterator = panelItems.keys();
            while (itemIterator.hasNext()) {
                String guideNodeClass;
                String itemKey = (String)itemIterator.next();
                Object itemValue = panelItems.get(itemKey);
                if (!(itemValue instanceof JSONObject) || !"guidePanel".equals(guideNodeClass = this.getJsonValue((JSONObject)itemValue, "guideNodeClass"))) continue;
                String fragRef = this.getJsonValue((JSONObject)itemValue, "fragRef");
                String fragPrefixStringForChildPanel = null;
                if (fragRef != null) {
                    String path = this.getJsonValue((JSONObject)itemValue, "jcr:path");
                    Resource res = this.resourceResolver.getResource(path);
                    fragPrefixStringForChildPanel = NodeStructureUtils.getFragPrefixString(res, fragPrefixString);
                }
                if (fragPrefixStringForChildPanel == null) {
                    fragPrefixStringForChildPanel = fragPrefixString;
                }
                this.generateSectionForPanel((JSONObject)itemValue, fragPrefixStringForChildPanel);
            }
        }
    }

    private void writeProgressiveSectionJson(JSONObject panel, boolean isRepeatable, List<FieldFragRefMapping> pdcFields, String fragPrefixString) throws JSONException {
        String id = "section_" + this.sectionId++;
        this.jsonWriter.key(id).object();
        this.jsonWriter.key("guideNodeClass").value("guideProgressiveSection");
        this.jsonWriter.key("jcr:title").value(this.getSectionTitle(panel));
        this.jsonWriter.key("name").value(this.getSectionName(panel, id));
        if (isRepeatable) {
            String panelPath = this.getJsonValue(panel, "jcr:path");
            Resource pdcPanelResource = this.resourceResolver.getResource(panelPath);
            String repeatablePanelId = NodeStructureUtils.getGuideNodeHtmlId(pdcPanelResource);
            this.jsonWriter.key("repeatablePanelPath").value(panelPath);
            this.jsonWriter.key("repeatablePanelId").value(repeatablePanelId);
        }
        this.jsonWriter.key("items").object();
        for (FieldFragRefMapping pdcField : pdcFields) {
            int index = pdcField.getPath().lastIndexOf(47);
            String name = pdcField.getPath().substring(index + 1) + "_" + this.fieldCounter;
            ++this.fieldCounter;
            this.jsonWriter.key(name).object();
            this.jsonWriter.key("jcr:primaryType").value("nt:unstructured");
            Resource pdcFieldResource = this.resourceResolver.getResource(pdcField.getPath());
            String pdcFieldId = NodeStructureUtils.getGuideNodeHtmlId(pdcFieldResource, pdcField.getFragPrefix());
            this.jsonWriter.key("id").value(pdcFieldId);
            this.jsonWriter.key("path").value(pdcField.getPath());
            if (pdcField.getFragPrefix() != null) {
                this.jsonWriter.key("prefixId").value(pdcField.getFragPrefix());
            }
            this.jsonWriter.endObject();
        }
        this.jsonWriter.endObject();
        this.jsonWriter.endObject();
    }

    private String getSectionTitle(JSONObject panel) throws JSONException {
        String title = this.getJsonValue(panel, "jcr:title");
        if (StringUtils.isEmpty((String)title)) {
            title = this.getJsonValue(panel, "name");
        }
        return title;
    }

    private String getSectionName(JSONObject panel, String id) throws JSONException {
        String name = this.getJsonValue(panel, "name");
        if (StringUtils.isEmpty((String)name)) {
            name = id;
        }
        return name;
    }

    private List<FieldFragRefMapping> getFields(JSONObject panel, boolean onlyDirectFields, String fragPrefixString) throws JSONException {
        ArrayList<FieldFragRefMapping> fields = new ArrayList<FieldFragRefMapping>();
        JSONObject panelItems = null;
        if (panel.has("items") && panel.get("items") instanceof JSONObject) {
            panelItems = panel.getJSONObject("items");
            Iterator itemIterator = panelItems.keys();
            while (itemIterator.hasNext()) {
                String itemKey = (String)itemIterator.next();
                Object itemValue = panelItems.get(itemKey);
                if (!(itemValue instanceof JSONObject)) continue;
                String guideNodeClass = this.getJsonValue((JSONObject)itemValue, "guideNodeClass");
                if (GuideProgressiveUtils.isGuideProgressiveFieldModel(guideNodeClass)) {
                    fields.add(new FieldFragRefMapping(this.getJsonValue((JSONObject)itemValue, "jcr:path"), fragPrefixString));
                    continue;
                }
                if (!"guidePanel".equals(guideNodeClass) || onlyDirectFields) continue;
                String fragref = this.getJsonValue((JSONObject)itemValue, "fragRef");
                String fragPrefixStringForChildPanel = null;
                if (fragref != null) {
                    String path = this.getJsonValue((JSONObject)itemValue, "jcr:path");
                    Resource res = this.resourceResolver.getResource(path);
                    fragPrefixStringForChildPanel = NodeStructureUtils.getFragPrefixString(res, fragPrefixString);
                } else {
                    fragPrefixStringForChildPanel = fragPrefixString;
                }
                fields.addAll(this.getFields((JSONObject)itemValue, onlyDirectFields, fragPrefixStringForChildPanel));
            }
        }
        return fields;
    }

    private String getJsonValue(JSONObject jsonObject, String keyName) throws JSONException {
        if (jsonObject.has(keyName)) {
            return jsonObject.getString(keyName);
        }
        return null;
    }

    private String getOrElse(JSONObject jsonObject, String keyName, String fallbackValue) throws JSONException {
        String value = this.getJsonValue(jsonObject, keyName);
        return value != null ? value : fallbackValue;
    }

    public class FieldFragRefMapping {
        private String path;
        private String fragPrefix;

        public FieldFragRefMapping(String field, String fragRef) {
            this.path = field;
            this.fragPrefix = fragRef;
        }

        public String getPath() {
            return this.path;
        }

        public String getFragPrefix() {
            return this.fragPrefix;
        }
    }
}

