/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.model;

import com.adobe.aemds.guide.model.ReCaptchaSubmissionData;
import com.adobe.aemds.guide.service.external.PortalRecordInfo;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.XMLUtils;
import com.adobe.forms.common.service.FileAttachmentWrapper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormSubmitInfo {
    private Resource formContainerResource;
    private String formContainerPath;
    private String data;
    private String locale;
    private List<FileAttachmentWrapper> fileAttachments;
    private String fileAttachmentMap;
    private FileAttachmentWrapper documentOfRecord;
    private String formSubmitter;
    private String contentType;
    private byte[] signData;
    private String agreementId;
    private PortalRecordInfo portalRecordInfo;
    private String draftId;
    private ReCaptchaSubmissionData reCaptchaSubmissionData;
    private String referer;
    private static Logger logger = LoggerFactory.getLogger(FormSubmitInfo.class);

    public String getFormContainerPath() {
        return this.formContainerPath;
    }

    public void setFormContainerPath(String formContainerPath) {
        this.formContainerPath = formContainerPath;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data = this.addMetaInfoInData(data);
    }

    public String getDraftId() {
        return this.draftId;
    }

    public void setDraftId(String draftId) {
        this.draftId = draftId;
    }

    public List<FileAttachmentWrapper> getFileAttachments() {
        return this.fileAttachments;
    }

    public void setFileAttachments(List<FileAttachmentWrapper> fileAttachments) {
        this.fileAttachments = fileAttachments;
    }

    public FileAttachmentWrapper getDocumentOfRecord() {
        return this.documentOfRecord;
    }

    public void setDocumentOfRecord(FileAttachmentWrapper documentOfRecord) {
        this.documentOfRecord = documentOfRecord;
    }

    public String getFileAttachmentMap() {
        return this.fileAttachmentMap;
    }

    public void setFileAttachmentMap(String fileAttachmentMap) {
        this.fileAttachmentMap = fileAttachmentMap;
    }

    public Resource getFormContainerResource() {
        return this.formContainerResource;
    }

    public void setFormContainerResource(Resource formContainerResource) {
        this.formContainerResource = formContainerResource;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getFormSubmitter() {
        return this.formSubmitter;
    }

    public void setFormSubmitter(String formSubmitter) {
        this.formSubmitter = formSubmitter;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public byte[] getSignData() {
        return this.signData;
    }

    public void setSignData(byte[] signData) {
        this.signData = signData;
    }

    public String getAgreementId() {
        return this.agreementId;
    }

    public void setAgreementId(String agreementId) {
        this.agreementId = agreementId;
    }

    public PortalRecordInfo getPortalRecordInfo() {
        return this.portalRecordInfo;
    }

    public void setPortalRecordInfo(PortalRecordInfo portalRecordInfo) {
        this.portalRecordInfo = portalRecordInfo;
    }

    private String addMetaInfoInData(String data) {
        String messagedData = data;
        switch (MimeContentType.getMimeType(this.contentType)) {
            case APPLICATION_XML: {
                messagedData = XMLUtils.addSubmissionInfoMetaData(data, this.formContainerPath, this.getDateForSubmissionTime());
                break;
            }
            case APPLICATION_JSON: {
                messagedData = this.addSubmissionInfoMetaDataToJson(data);
            }
        }
        return messagedData;
    }

    public void setRecaptchaData(ReCaptchaSubmissionData reCaptchaSubmissionData) {
        this.reCaptchaSubmissionData = reCaptchaSubmissionData;
        this.data = this.addReCaptchaDataInFormData(this.getData());
    }

    private String addReCaptchaDataInFormData(String formData) {
        String response = formData;
        try {
            if (this.reCaptchaSubmissionData != null) {
                String reCaptchaScoreBindRef = this.reCaptchaSubmissionData.getBindRef();
                String reCaptchaFieldName = this.reCaptchaSubmissionData.getFieldName();
                Double reCaptchaScore = this.reCaptchaSubmissionData.getScore();
                if (!(reCaptchaScore == null || StringUtils.isEmpty((CharSequence)reCaptchaScoreBindRef) && StringUtils.isEmpty((CharSequence)reCaptchaFieldName))) {
                    String updatePath = "";
                    switch (MimeContentType.getMimeType(this.getContentType())) {
                        case APPLICATION_XML: {
                            updatePath = !StringUtils.isEmpty((CharSequence)reCaptchaScoreBindRef) ? String.format("%s%s", "afBoundData", reCaptchaScoreBindRef) : String.format("%s/%s/%s", "afUnboundData", "data", reCaptchaFieldName);
                            response = XMLUtils.addReCaptchaDataInXML(formData, updatePath, reCaptchaScore.toString());
                            break;
                        }
                        case APPLICATION_JSON: {
                            JSONObject captchaJsonObject = new JSONObject();
                            captchaJsonObject.put("captchaType", (Object)"reCaptchaEnterprise");
                            captchaJsonObject.put("captchaScore", (Object)reCaptchaScore);
                            JSONObject dataJsonObject = new JSONObject(formData);
                            if (dataJsonObject == null) break;
                            updatePath = !StringUtils.isEmpty((CharSequence)reCaptchaScoreBindRef) ? String.format("%s/%s/%s%s", "afData", "afBoundData", "data", reCaptchaScoreBindRef) : String.format("%s/%s/%s/%s", "afData", "afUnboundData", "data", reCaptchaFieldName);
                            this.updateJsonObject(dataJsonObject, updatePath, captchaJsonObject);
                            response = dataJsonObject.toString();
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in adding reCAPTCHA score in form data json", (Throwable)e);
        }
        return response;
    }

    private void updateJsonObject(JSONObject dataJsonObject, String updatePath, Object value) throws JSONException {
        if (StringUtils.isEmpty((CharSequence)updatePath) || updatePath.startsWith("/") || updatePath.endsWith("/")) {
            return;
        }
        int lastSlashIdx = updatePath.lastIndexOf("/");
        if (lastSlashIdx != -1) {
            String key = updatePath.substring(lastSlashIdx + 1);
            String path = updatePath.substring(0, lastSlashIdx);
            JSONObject nodeToUpdate = dataJsonObject;
            for (String node : path.split("/")) {
                if (!nodeToUpdate.has(node)) {
                    nodeToUpdate.put(node, (Object)new JSONObject());
                }
                nodeToUpdate = nodeToUpdate.getJSONObject(node);
            }
            nodeToUpdate.put(key, value);
        }
    }

    private String addSubmissionInfoMetaDataToJson(String data) {
        String messagedData = data;
        try {
            JSONObject dataJsonObject = new JSONObject(data);
            if (dataJsonObject.has("afData")) {
                JSONObject submissionInfoRootTag = dataJsonObject.optJSONObject("afData").optJSONObject("afSubmissionInfo");
                if (submissionInfoRootTag != null) {
                    if (this.formContainerPath != null) {
                        String formDamPath = GuideUtils.convertGuideContainerPathToFMAssetPath(this.formContainerPath);
                        submissionInfoRootTag.put("afPath", (Object)formDamPath);
                    }
                    submissionInfoRootTag.put("afSubmissionTime", (Object)this.getDateForSubmissionTime());
                }
                messagedData = dataJsonObject.toString();
            }
        }
        catch (Exception e) {
            logger.error("Error in adding submission meta data to JSON " + e.getMessage(), (Throwable)e);
        }
        return messagedData;
    }

    private String getDateForSubmissionTime() {
        return new SimpleDateFormat("yyyyMMddhhmmss").format(new Date());
    }

    public String getReferer() {
        return this.referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    private static enum MimeContentType {
        APPLICATION_XML("application/xml"),
        APPLICATION_JSON("application/json");

        private String mimeType;

        private MimeContentType(String mimeType) {
            this.mimeType = mimeType;
        }

        static MimeContentType getMimeType(String mimeType) {
            MimeContentType retVal = APPLICATION_XML;
            for (MimeContentType mimeContentType : MimeContentType.values()) {
                if (!StringUtils.equals((CharSequence)mimeContentType.mimeType, (CharSequence)mimeType)) continue;
                retVal = mimeContentType;
                break;
            }
            return retVal;
        }
    }
}

