/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideNode;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

public abstract class GuideField
extends GuideNode {
    protected String helpQuestionMarkContent = "";
    private String displayNoneStyle = ";display:none";

    public Boolean getIsRequired() {
        return FormsHelper.isRequired((Resource)super.getResource());
    }

    public Boolean getIsReadOnly() {
        return FormsHelper.isReadOnly((SlingHttpServletRequest)this.slingRequest, (Resource)super.getResource());
    }

    public String getLabelForId() throws RepositoryException {
        return this.getId() + "_widget";
    }

    public String getAutofillFieldKeyword() {
        return (String)this.resourceProps.get("autofillFieldKeyword", (Object)"off");
    }

    public Boolean getAutocomplete() {
        return (Boolean)this.resourceProps.get("autocomplete", (Object)false);
    }

    public boolean getIsOldFieldLayout() {
        String fieldLayout = (String)this.resourceProps.get("fieldLayout", (Object)"");
        if (fieldLayout != null && fieldLayout.length() > 0 && !fieldLayout.equals("/libs/fd/af/layouts/field/defaultFieldLayout/defaultFieldLayout.jsp")) {
            return this.checkIfPathIsAbsolute(fieldLayout);
        }
        return false;
    }

    public String getFieldLayout() {
        String fieldLayout = (String)this.resourceProps.get("fieldLayout", (Object)"");
        if (fieldLayout != null && fieldLayout.length() > 0 && fieldLayout.indexOf("defaultFieldLayout") < 0) {
            return fieldLayout;
        }
        Resource guideContainerResource = this.getResource().getResourceResolver().getResource(GuideUtils.getGuideContainerPath(this.slingRequest, this.getResource()));
        return GuideUtils.getFieldLayout(guideContainerResource, "fieldLayout", "fd/af/layouts/field/defaultFieldLayout");
    }

    public String getFieldLayoutName() {
        String fieldLayout = this.getFieldLayout();
        String fieldLayoutName = "defaultFieldLayout";
        if (fieldLayout != null && fieldLayout.length() > 0) {
            fieldLayoutName = StringUtils.substringAfterLast((String)fieldLayout, (String)"/");
            fieldLayoutName = StringUtils.substringBeforeLast((String)fieldLayoutName, (String)".jsp");
        }
        return fieldLayoutName;
    }

    public boolean getHideTitle() {
        return (Boolean)this.resourceProps.get("hideTitle", (Object)false);
    }

    public String getShortDescription() {
        return this.externalize((String)this.resourceProps.get("shortDescription", (Object)""), "shortDescription");
    }

    public String getLongDescription() {
        return this.externalize((String)this.resourceProps.get("longDescription", (Object)""), "longDescription");
    }

    public Boolean getDescriptionVisibility() {
        return (Boolean)this.resourceProps.get("shortVisible", (Object)false);
    }

    public String getValue() {
        return (String)this.resourceProps.get("_value", String.class);
    }

    public String getCaptionInlineStyles() {
        if (this.getHideTitle()) {
            return this.getInlineStyles("Caption") + this.displayNoneStyle;
        }
        return this.getInlineStyles("Caption");
    }

    public String getWidgetInlineStyles() {
        return this.getInlineStyles("Widget");
    }

    public void setHelpIndicatorContent(String helpQuestionMarkContent) {
        this.helpQuestionMarkContent = helpQuestionMarkContent != null ? helpQuestionMarkContent : "";
    }

    public String getHelpIndicatorContent() {
        return this.helpQuestionMarkContent;
    }

    public String getShortDescriptionInlineStyles() {
        if (this.getDescriptionVisibility().booleanValue()) {
            return this.getInlineStyles("ShortDescription");
        }
        return this.getInlineStyles("ShortDescription") + this.displayNoneStyle;
    }

    public String getPlaceholderText() {
        return this.externalize((String)this.resourceProps.get("placeholderText", (Object)""), "placeholderText");
    }

    public String getErrorSimulatorString() {
        String validatePictureClauseMessage;
        String mandatoryMessageAttribute = null;
        if (this.isMandatory()) {
            String mandatoryMessage = (String)this.resourceProps.get("mandatoryMessage", String.class);
            mandatoryMessageAttribute = mandatoryMessage != null && !mandatoryMessage.isEmpty() ? mandatoryMessage : "There is an error in this field !";
        } else {
            String validateExpMessage = (String)this.resourceProps.get("validateExpMessage", String.class);
            if (validateExpMessage != null && !validateExpMessage.isEmpty()) {
                mandatoryMessageAttribute = validateExpMessage;
            }
        }
        if (mandatoryMessageAttribute != null && (validatePictureClauseMessage = (String)this.resourceProps.get("validatePictureClauseMessage", String.class)) != null) {
            mandatoryMessageAttribute = validatePictureClauseMessage;
        }
        return mandatoryMessageAttribute;
    }

    public boolean isMandatory() {
        return (Boolean)this.resourceProps.get("mandatory", (Object)false);
    }

    @Override
    public Map<String, Object> getAuthoringConfig() {
        Map<String, Object> authoringConfig = super.getAuthoringConfig();
        Boolean hideTitle = this.getHideTitle();
        if (hideTitle.booleanValue()) {
            authoringConfig.put("hideTitle", hideTitle);
        }
        GuideUtils.setMasterAuthoringConfig(authoringConfig, this.resourceProps);
        return authoringConfig;
    }
}

