/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.formset.common;

import com.adobe.aemds.formset.common.EligibilityExpressionVisitor;
import com.adobe.aemds.formset.common.FormResource;
import com.adobe.aemds.formset.exception.FormsetException;
import com.adobe.aemds.formset.service.FormsetService;
import com.adobe.aemds.guide.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FormsetResource {
    private Resource resource;
    private Resource forms;
    private ValueMap formsProps;
    private Resource metadata;
    private ValueMap metadataProps;
    public static final String NODE_NAME_FORMS = "forms";
    public static final String NODE_PATH_FORMS = "related/forms/sling:members";
    public static final String NODE_NAME_METADATA = "metadata";
    public static final String PROPERTY_NAME_TYPE = "formsetType";
    public static final String PROPERTY_NAME_FORM_RENDER_PROFILE = "formRenderProfile";
    public static final String PROPERTY_NAME_FORMSET_SUBMIT_URL = "submitUrl";
    public static final String FORMSET_TYPE_MF = "mf";
    private static final String DEFAULT_FORM_RENDER_PROFILE = "/content/xfaforms/profiles/default.html";
    private Logger logger = LoggerFactory.getLogger(FormsetResource.class);

    public FormsetResource(Resource resource) {
        this.resource = resource;
        Resource jcrContent = resource.getChild("jcr:content");
        this.forms = resource.getResourceResolver().getResource(jcrContent, NODE_PATH_FORMS);
        this.formsProps = ResourceUtil.getValueMap((Resource)this.forms);
        this.metadata = jcrContent.getChild(NODE_NAME_METADATA);
        this.metadataProps = ResourceUtil.getValueMap((Resource)this.metadata);
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean isFormsetMF() {
        return FORMSET_TYPE_MF.equals(this.metadataProps.get(PROPERTY_NAME_TYPE, (Object)FORMSET_TYPE_MF));
    }

    public FormResource getForm(int formNumber) {
        Iterable children = this.forms.getChildren();
        if (children == null) {
            return null;
        }
        Iterator childIterator = children.iterator();
        int currentFormNumber = 1;
        while (childIterator.hasNext()) {
            Resource child = (Resource)childIterator.next();
            if (currentFormNumber == formNumber) {
                return FormResource.createResource(child, formNumber);
            }
            ++currentFormNumber;
        }
        return null;
    }

    public FormResource getFormByUid(String formUid) {
        Iterable children = this.forms.getChildren();
        if (children == null || formUid == null || formUid.length() < 1) {
            return null;
        }
        Iterator childIterator = children.iterator();
        int currentFormNumber = 1;
        while (childIterator.hasNext()) {
            Resource child = (Resource)childIterator.next();
            ValueMap properties = (ValueMap)child.adaptTo(ValueMap.class);
            String childUid = (String)properties.get("uid", (Object)null);
            if (formUid.equals(childUid)) {
                return FormResource.createResource(child, currentFormNumber);
            }
            ++currentFormNumber;
        }
        return null;
    }

    public String listForms(String dataRef, InputStream dataRefStream, FormsetService formsetService) throws FormsetException {
        try {
            Iterable children = this.forms.getChildren();
            if (children == null) {
                return null;
            }
            Iterator childIterator = children.iterator();
            int formNumber = 1;
            StringWriter jsonStringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)jsonStringWriter);
            jsonWriter.object().key("formslist").array();
            while (childIterator.hasNext()) {
                FormResource form = FormResource.createResource((Resource)childIterator.next(), formNumber);
                jsonWriter.object();
                form.addKeys(jsonWriter);
                jsonWriter.key("compiledEligibilityExpression").value((Object)this.getCompiledEligibilityExpression(formsetService, form.getEligibilityExpression()));
                jsonWriter.endObject();
                ++formNumber;
            }
            jsonWriter.endArray();
            this.writeRenderContext(jsonWriter, dataRef, dataRefStream);
            jsonWriter.endObject();
            return jsonStringWriter.toString();
        }
        catch (JSONException e) {
            throw new FormsetException(e);
        }
        catch (Exception e) {
            throw new FormsetException(e);
        }
    }

    private String getCompiledEligibilityExpression(FormsetService formsetService, String eligibilityExpression) {
        EligibilityExpressionVisitor eligibilityExpressionVisitor = new EligibilityExpressionVisitor(this, formsetService);
        return formsetService.getCompiledExpression(eligibilityExpression, eligibilityExpressionVisitor, this);
    }

    public void writeRenderContext(JSONWriter jsonWriter, String dataRef, String xmldata, Document doc) throws JSONException, ParserConfigurationException, IOException, SAXException, XPathExpressionException, FormsetException {
        jsonWriter.key("renderContext").object().key("dataRef").value((Object)dataRef).key("formsetPath").value((Object)this.resource.getPath()).key("xml").value((Object)xmldata);
        if (xmldata != null) {
            XPath xPath = XPathFactory.newInstance().newXPath();
            Node currentFormNode = (Node)xPath.evaluate("/formset/fs_draft/fs_currentform", doc, XPathConstants.NODE);
            int nCurrentFormNumber = 0;
            if (currentFormNode != null) {
                String sCurrentFormNumber = currentFormNode.getTextContent();
                try {
                    if (sCurrentFormNumber != null && sCurrentFormNumber.length() > 0) {
                        nCurrentFormNumber = Integer.parseInt(sCurrentFormNumber);
                        jsonWriter.key("currentFormNumber").value((long)nCurrentFormNumber);
                    }
                }
                catch (Exception e) {
                    this.logger.error("[FormSet] Invalid Data XML. Current Form Number must be a valid Integer, but found " + sCurrentFormNumber, (Throwable)e);
                    throw new FormsetException(e);
                }
            }
            NodeList retNode = (NodeList)xPath.evaluate("/formset/fs_draft//fs_form", doc, XPathConstants.NODESET);
            jsonWriter.key("renderedFormsList").array();
            for (int i = 0; i < retNode.getLength(); ++i) {
                int nFormNumber;
                Element n = (Element)retNode.item(i);
                Element FormNumber = (Element)n.getElementsByTagName("formNumber").item(0);
                Element ValidationStatus = (Element)n.getElementsByTagName("validation_status").item(0);
                String sFormNumber = FormNumber.getTextContent();
                jsonWriter.object();
                try {
                    nFormNumber = Integer.parseInt(sFormNumber);
                    jsonWriter.key("formNumber").value((long)nFormNumber);
                }
                catch (Exception e) {
                    this.logger.error("[FormSet] Invalid Data XML. Form Number must be a valid Integer, but found " + sFormNumber, (Throwable)e);
                    throw new FormsetException(e);
                }
                if (ValidationStatus != null) {
                    String sValidationStatus = ValidationStatus.getTextContent();
                    boolean bValidationStatus = Boolean.parseBoolean(sValidationStatus);
                    jsonWriter.key("validationStatus").value(bValidationStatus);
                    if (!bValidationStatus) {
                        Element oInvalidField = (Element)n.getElementsByTagName("invalid_field").item(0);
                        if (oInvalidField == null && nCurrentFormNumber != nFormNumber) {
                            this.logger.error("[Formset] Invalid Data XML. Invalid Field is missing for the form " + sFormNumber);
                        }
                        if (oInvalidField != null) {
                            jsonWriter.key("invalidField").value((Object)oInvalidField.getTextContent());
                        }
                    }
                }
                jsonWriter.endObject();
            }
            jsonWriter.endArray();
        }
        jsonWriter.endObject();
    }

    private void writeRenderContext(JSONWriter jsonWriter, String dataRef, InputStream dataRefStream) throws FormsetException, JSONException, ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        Document doc = null;
        String xmldata = null;
        if (dataRefStream != null) {
            xmldata = IOUtils.toString((InputStream)dataRefStream, (String)"UTF-8");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            XMLUtils.disableExternalEntities(factory);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new ByteArrayInputStream(xmldata.getBytes("UTF-8")));
        }
        this.writeRenderContext(jsonWriter, dataRef, xmldata, doc);
    }

    public Iterator<FormResource> getFormResourceIterator() {
        ArrayList<FormResource> list = this.getFormsList();
        if (list == null) {
            return null;
        }
        return list.iterator();
    }

    public ArrayList<FormResource> getFormsList() {
        Iterable children = this.forms.getChildren();
        if (children == null) {
            return null;
        }
        Iterator childIterator = children.iterator();
        int formNumber = 1;
        ArrayList<FormResource> list = new ArrayList<FormResource>();
        while (childIterator.hasNext()) {
            FormResource form = FormResource.createResource((Resource)childIterator.next(), formNumber);
            list.add(form);
            ++formNumber;
        }
        return list;
    }

    public String getFormProfileUrl() {
        String formProfile = (String)this.metadataProps.get(PROPERTY_NAME_FORM_RENDER_PROFILE, (Object)DEFAULT_FORM_RENDER_PROFILE);
        return formProfile;
    }

    public String getSubmitUrl() {
        return (String)this.metadataProps.get(PROPERTY_NAME_FORMSET_SUBMIT_URL, null);
    }
}

