/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.signatures.pki.client.types.prefs;

import com.adobe.fd.signatures.pki.client.types.common.RevocationCheckStyle;
import com.adobe.fd.signatures.pki.client.types.prefs.PreferencesMap;
import com.adobe.fd.signatures.pki.client.types.prefs.TransportPreferences;

public class TransportPreferencesImpl
extends PreferencesMap
implements TransportPreferences {
    private static final long serialVersionUID = -7520020114995580824L;
    private static final String proxyHostStr = "proxyHost";
    private static final String proxyPortStr = "proxyPort";
    private static final Integer proxyPort_Default = new Integer(80);
    private static final String proxyUsernameStr = "proxyUsername";
    private static final String proxyPasswordStr = "proxyPassword";
    private static final String maxDownloadLimitStr = "maxDownloadLimit";
    private static final Integer maxDownloadLimit_Default = new Integer(16);
    private static final String connectionTimeoutStr = "connectionTimeout";
    private static final Integer connectionTimeout_Default = new Integer(5);
    private static final String socketTimeoutStr = "socketTimeout";
    private static final Integer socketTimeout_Default = new Integer(30);
    private static final String disableTransportStr = "disableTransport";
    private static final Boolean disableTransport_default = new Boolean(false);
    private static final String sslRevCheckStr = "sslRevCheck";
    private static final RevocationCheckStyle sslRevCheck_default = RevocationCheckStyle.BestEffort;

    public TransportPreferencesImpl() {
        this.put(proxyPortStr, (Object)proxyPort_Default);
        this.put(maxDownloadLimitStr, (Object)maxDownloadLimit_Default);
        this.put(connectionTimeoutStr, (Object)connectionTimeout_Default);
        this.put(socketTimeoutStr, (Object)socketTimeout_Default);
        this.put(disableTransportStr, (Object)disableTransport_default);
        this.put(sslRevCheckStr, (Object)sslRevCheck_default);
    }

    protected Object getPrefValueFromString(String prefName, String value) {
        if (prefName.equalsIgnoreCase(maxDownloadLimitStr) || prefName.equalsIgnoreCase(connectionTimeoutStr) || prefName.equalsIgnoreCase(socketTimeoutStr) || prefName.equalsIgnoreCase(proxyPortStr)) {
            return new Integer(value);
        }
        if (prefName.equalsIgnoreCase(proxyHostStr) || prefName.equalsIgnoreCase(proxyUsernameStr) || prefName.equalsIgnoreCase(proxyPasswordStr)) {
            return value.trim().length() != 0 ? value.trim() : null;
        }
        if (prefName.equalsIgnoreCase(disableTransportStr)) {
            return new Boolean(value);
        }
        if (prefName.equalsIgnoreCase(sslRevCheckStr)) {
            return RevocationCheckStyle.getValueFromString(value);
        }
        return value;
    }

    public PreferencesMap newInstance() {
        return new TransportPreferencesImpl();
    }

    protected PreferencesMap createChild(String myKey) {
        return null;
    }

    public int getConnectionTimeout() {
        return (Integer)this.get(connectionTimeoutStr);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.put(connectionTimeoutStr, (Object)connectionTimeout);
    }

    public int getMaxDownloadLimit() {
        return (Integer)this.get(maxDownloadLimitStr);
    }

    public void setMaxDownloadLimit(int maxDownloadLimit) {
        this.put(maxDownloadLimitStr, (Object)maxDownloadLimit);
    }

    public String getProxyHost() {
        return (String)this.get(proxyHostStr);
    }

    public void setProxyHost(String proxyHost) {
        this.put(proxyHostStr, (Object)proxyHost);
    }

    public int getProxyPort() {
        return (Integer)this.get(proxyPortStr);
    }

    public void setProxyPort(int proxyPort) {
        this.put(proxyPortStr, (Object)proxyPort);
    }

    public String getProxyPassword() {
        return (String)this.get(proxyPasswordStr);
    }

    public void setProxyPassword(String proxyPassword) {
        this.put(proxyPasswordStr, (Object)proxyPassword);
    }

    public String getProxyUsername() {
        return (String)this.get(proxyUsernameStr);
    }

    public void setProxyUsername(String proxyUsername) {
        this.put(proxyUsernameStr, (Object)proxyUsername);
    }

    public int getSocketTimeout() {
        return (Integer)this.get(socketTimeoutStr);
    }

    public void setSocketTimeout(int socketTimeout) {
        this.put(socketTimeoutStr, (Object)socketTimeout);
    }

    public boolean isTransportDisabled() {
        return (Boolean)this.get(disableTransportStr);
    }

    public void setTransportDisabled(boolean isDisabled) {
        this.put(disableTransportStr, (Object)new Boolean(isDisabled));
    }

    public RevocationCheckStyle getSSLRevCheckStyle() {
        return (RevocationCheckStyle)((Object)this.get(sslRevCheckStr));
    }

    public void setSSLRevCheckStyle(RevocationCheckStyle style) {
        this.put(sslRevCheckStr, (Object)style);
    }
}

