/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.signatures.pki.client.types.common;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PathValidationFailureReason {
    INVALID_NAME_CONSTRAINTS("Invalid Name Constraints"),
    INVALID_BASIC_CONSTRAINTS("Invalid Basic Constraints"),
    MISSING_BASIC_CONSTRAINTS("Missing Basic Constraints"),
    INVALID_POLICY_CONSTRAINTS("Invalid Policy Constraints"),
    INVALID_POLICY_MAPPINGS("Invalid Policy Mappings"),
    UNSUPPORTED_CRITICAL_EXTENSION("Unsopported Critical Extension"),
    INVALID_KEY_USAGE("Invalid Key Usage"),
    PATH_LEN_CONSTRAINT_NOT_SATISFIED("Path length constraint not satisfied"),
    INCORRECT_SIGNATURE("Certificate signature does not match"),
    CERTIFICATE_EXPIRED("Certificate has expired"),
    UNKNOWN_REASON("Unknown Reason"),
    PATH_NOT_TRUSTED("Path not trusted"),
    NO_FAILURE("No Failure"),
    IDENTRUS_SIGNING_COMPLIANCE_FAILED("Identrust Compliance failed for Signing Certificate"),
    IDENTRUS_OCSP_COMPLIANCE_FAILED("Revocation Checking of Identrust Certificates requires OCSP Request Signing using an Identrus Credential."),
    SIGNED_IN_FUTURE("Certificate is not yet valid.");

    private String desc;

    private PathValidationFailureReason(String anID) {
        this.desc = anID;
    }

    public String toString() {
        return this.desc;
    }

    public static boolean isReasonRecoverable(PathValidationFailureReason reason) {
        return reason == CERTIFICATE_EXPIRED || reason == UNSUPPORTED_CRITICAL_EXTENSION || reason == UNKNOWN_REASON;
    }

    public static PathValidationFailureReason getValueFromString(String s) {
        PathValidationFailureReason pvfr = null;
        if (CERTIFICATE_EXPIRED.toString().equals(s)) {
            pvfr = CERTIFICATE_EXPIRED;
        } else if (SIGNED_IN_FUTURE.toString().equals(s)) {
            pvfr = SIGNED_IN_FUTURE;
        } else if (INVALID_NAME_CONSTRAINTS.toString().equals(s)) {
            pvfr = INVALID_NAME_CONSTRAINTS;
        } else if (INVALID_BASIC_CONSTRAINTS.toString().equals(s)) {
            pvfr = INVALID_BASIC_CONSTRAINTS;
        } else if (MISSING_BASIC_CONSTRAINTS.toString().equals(s)) {
            pvfr = MISSING_BASIC_CONSTRAINTS;
        } else if (INVALID_POLICY_CONSTRAINTS.toString().equals(s)) {
            pvfr = INVALID_POLICY_CONSTRAINTS;
        } else if (INVALID_POLICY_MAPPINGS.toString().equals(s)) {
            pvfr = INVALID_POLICY_MAPPINGS;
        } else if (UNSUPPORTED_CRITICAL_EXTENSION.toString().equals(s)) {
            pvfr = UNSUPPORTED_CRITICAL_EXTENSION;
        } else if (INVALID_KEY_USAGE.toString().equals(s)) {
            pvfr = INVALID_KEY_USAGE;
        } else if (PATH_LEN_CONSTRAINT_NOT_SATISFIED.toString().equals(s)) {
            pvfr = PATH_LEN_CONSTRAINT_NOT_SATISFIED;
        } else if (INCORRECT_SIGNATURE.toString().equals(s)) {
            pvfr = INCORRECT_SIGNATURE;
        } else if (UNKNOWN_REASON.toString().equals(s)) {
            pvfr = UNKNOWN_REASON;
        } else if (PATH_NOT_TRUSTED.toString().equals(s)) {
            pvfr = PATH_NOT_TRUSTED;
        } else if (NO_FAILURE.toString().equals(s)) {
            pvfr = NO_FAILURE;
        } else if (IDENTRUS_SIGNING_COMPLIANCE_FAILED.toString().equals(s)) {
            pvfr = IDENTRUS_SIGNING_COMPLIANCE_FAILED;
        } else if (IDENTRUS_OCSP_COMPLIANCE_FAILED.toString().equals(s)) {
            pvfr = IDENTRUS_OCSP_COMPLIANCE_FAILED;
        }
        return pvfr;
    }
}

