/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.servlet;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.JsonObjectCreator;
import com.adobe.aemds.guide.service.internal.GuideSchemaService;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}), @Property(name="sling.servlet.methods", value={"GET"}), @Property(name="sling.servlet.selectors", value={"af.validateTranslation"})})
public class TranslationValidationServlet
extends SlingAllMethodsServlet {
    private Logger logger = LoggerFactory.getLogger(TranslationValidationServlet.class);
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private QueryBuilder queryBuilder;
    @Reference
    private JsonObjectCreator jsonObjectCreator;
    @Reference
    private GuideSchemaService guideSchema;
    private static final String FOLDER_REQUEST_PARAMETER_NAME = "folder";
    private static final String PATH = "path";
    private static final String DEFAULT_ROOT_FOLDER = "/content/forms/af";
    private static final String DICTIONARY_PATH = "/assets/dictionary";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws IOException {
        ResourceResolver resourceResolver = request.getResourceResolver();
        try {
            String rootFolder = request.getParameter(FOLDER_REQUEST_PARAMETER_NAME);
            if (StringUtils.isEmpty((CharSequence)rootFolder)) {
                rootFolder = DEFAULT_ROOT_FOLDER;
            }
            this.logger.info("[AF][Translation] Root directory set to = {} ", (Object)rootFolder);
            Map<String, String> queryMap = this.createQuery(rootFolder);
            SearchResult result = this.executeQuery(queryMap, resourceResolver);
            this.logger.info("[AF][Translation] Total Results (AF under root directory) = {}", (Object)result.getTotalMatches());
            JSONArray formsWithDictionaries = new JSONArray();
            JSONArray modifiedFormDictionaries = new JSONArray();
            Iterator it = result.getNodes();
            while (it.hasNext()) {
                Node node = (Node)it.next();
                try {
                    String guideContainerPath = node.getPath();
                    if (resourceResolver.getResource(guideContainerPath + DICTIONARY_PATH) == null) continue;
                    JSONObject obj = new JSONObject();
                    obj.put(PATH, (Object)guideContainerPath);
                    formsWithDictionaries.put((Object)obj);
                }
                catch (Exception e) {
                    if (resourceResolver != null && resourceResolver.isLive()) {
                        resourceResolver.close();
                    }
                    response.sendError(500, "Error occurred while fetching all forms with dictionaries");
                    this.logger.error("[AF][Translation] Error occurred while fetching all forms with dictionaries", (Throwable)e);
                }
            }
            for (int i = 0; i < formsWithDictionaries.length(); ++i) {
                JSONObject jsonObject = formsWithDictionaries.getJSONObject(i);
                String formGuideContainerPath = jsonObject.getString(PATH);
                this.logger.info("[AF][Translation] Creating new dictionary keys for the form {}", (Object)formGuideContainerPath);
                Set<String> newDictionaryMessageKeys = this.getNewDictionaryKeys(formGuideContainerPath, resourceResolver);
                Resource dictionaryResource = resourceResolver.getResource(formGuideContainerPath + DICTIONARY_PATH);
                Iterable dictionaryLocaleResource = dictionaryResource.getChildren();
                JSONObject obj = new JSONObject();
                obj.put(PATH, (Object)formGuideContainerPath);
                JSONArray changedKeysArray = new JSONArray();
                for (Resource dictionaryLocale : dictionaryLocaleResource) {
                    JSONObject changedKeysObj = new JSONObject();
                    String localeName = dictionaryLocale.getName();
                    String baseName = formGuideContainerPath + DICTIONARY_PATH;
                    this.logger.info("[AF][Translation] Dictionary Path  {} locale {}", (Object)baseName, (Object)localeName);
                    Locale locale = new Locale(localeName);
                    ResourceBundle oldDictionaryKeys = request.getResourceBundle(baseName, locale);
                    JSONArray untranslatedKeys = this.findUntranslatedKeys(oldDictionaryKeys, newDictionaryMessageKeys);
                    JSONArray removedKeys = this.findRemovedKeys(oldDictionaryKeys, newDictionaryMessageKeys);
                    if (untranslatedKeys.length() <= 0 && removedKeys.length() <= 0) continue;
                    changedKeysObj.put("locale", (Object)localeName);
                    if (untranslatedKeys.length() > 0) {
                        changedKeysObj.put("untranslatedKeys", (Object)untranslatedKeys);
                    }
                    if (removedKeys.length() > 0) {
                        changedKeysObj.put("removedKeys", (Object)removedKeys);
                    }
                    changedKeysArray.put((Object)changedKeysObj);
                }
                if (changedKeysArray.length() <= 0) continue;
                obj.put("changedKeys", (Object)changedKeysArray);
                modifiedFormDictionaries.put((Object)obj);
            }
            JSONObject obj = new JSONObject();
            obj.put("modifiedForms", (Object)modifiedFormDictionaries);
            PrintWriter writer = response.getWriter();
            writer.write(obj.toString());
            writer.close();
        }
        catch (Exception e) {
            response.sendError(500, "Error occurred while computing dirty AF translations");
            this.logger.error("[AF][Translation] Error occurred while computing dirty AF translations", (Throwable)e);
        }
        finally {
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
    }

    private Set<String> getNewDictionaryKeys(String formGuideContainerPath, ResourceResolver resourceResolver) throws Exception {
        Resource formPageResource = GuideUtils.getPageResource(resourceResolver.getResource(formGuideContainerPath));
        ResourceResolver fdServiceResourceResolver = GuideUtils.getServiceResourceResolver(this.resourceResolverFactory);
        Resource mergedFormResource = GuideUtils.getMergedFormResource(fdServiceResourceResolver, formPageResource.getPath());
        Iterator childrenResources = mergedFormResource.getChildren().iterator();
        JSONArray jsonObjectArray = new JSONArray();
        while (childrenResources.hasNext()) {
            Resource r = (Resource)childrenResources.next();
            JSONObject jsonObj = this.jsonObjectCreator.create(r, -1, null);
            jsonObjectArray.put((Object)jsonObj);
        }
        HashSet<String> newDictionaryMessageKeys = new HashSet<String>();
        for (int j = 0; j < jsonObjectArray.length(); ++j) {
            if (jsonObjectArray.getJSONObject(j).optString("sling:resourceType").equals("fd/af/components/guideformtitle")) {
                String messageKey = GuideUtils.getNamespacedKeys("text");
                newDictionaryMessageKeys.add(messageKey);
                continue;
            }
            this.addKeys(jsonObjectArray.getJSONObject(j), newDictionaryMessageKeys);
        }
        return newDictionaryMessageKeys;
    }

    private SearchResult executeQuery(Map<String, String> queryMap, ResourceResolver resourceResolver) {
        PredicateGroup predicates = PredicateGroup.create(queryMap);
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        Query query = this.queryBuilder.createQuery(predicates, session);
        return query.getResult();
    }

    private Map<String, String> createQuery(String rootFolder) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put(PATH, rootFolder);
        queryMap.put("property", "sling:resourceType");
        queryMap.put("property.1_value", "fd/af/components/guideContainer");
        queryMap.put("property.2_value", "fd/af/components/guideFragmentContainer");
        queryMap.put("p.limit", "-1");
        return queryMap;
    }

    private JSONArray findUntranslatedKeys(ResourceBundle oldDictionaryKeys, Set<String> newDictionaryMessageKeys) {
        JSONArray untranslatedKeys = new JSONArray();
        for (String dictionaryKey : newDictionaryMessageKeys) {
            if (oldDictionaryKeys.containsKey(dictionaryKey)) continue;
            untranslatedKeys.put((Object)dictionaryKey);
        }
        return untranslatedKeys;
    }

    private JSONArray findRemovedKeys(ResourceBundle oldDictionaryKeys, Set<String> newDictionaryMessageKeys) {
        JSONArray removedKeys = new JSONArray();
        for (String dictionaryKey : oldDictionaryKeys.keySet()) {
            if (newDictionaryMessageKeys.contains(dictionaryKey)) continue;
            removedKeys.put((Object)dictionaryKey);
        }
        return removedKeys;
    }

    private void addKeys(JSONObject jsonObject, Set<String> newDictionaryMessageKeys) throws Exception {
        Iterator keys = jsonObject.keys();
        String componentName = null;
        if (jsonObject.has("guideNodeClass")) {
            componentName = jsonObject.getString("guideNodeClass");
        } else if (jsonObject.has("resourceType")) {
            componentName = jsonObject.getString("resourceType");
        }
        while (keys.hasNext()) {
            String keyLabel = null;
            String key = (String)keys.next();
            Object object = jsonObject.get(key);
            Class<?> objectClass = object.getClass();
            try {
                if (objectClass.equals(JSONObject.class)) {
                    this.addKeys((JSONObject)object, newDictionaryMessageKeys);
                    continue;
                }
                if (objectClass.equals(JSONArray.class)) {
                    if (!this.guideSchema.isLocalizableProperty(componentName, key)) continue;
                    this.addJsonArrayKeys((JSONArray)object, newDictionaryMessageKeys);
                    continue;
                }
                keyLabel = object.toString();
                if (StringUtils.isEmpty((CharSequence)keyLabel) || !this.guideSchema.isLocalizableProperty(componentName, key)) continue;
                newDictionaryMessageKeys.add(GuideUtils.getNamespacedKeys(keyLabel));
            }
            catch (Exception e) {
                this.logger.error("[AF][Translation] Error occurred while generating new Dictionary keys", (Throwable)e);
                throw new GuideException(e);
            }
        }
    }

    private void addJsonArrayKeys(JSONArray jsonArray, Set<String> newDictionaryMessageKeys) throws Exception {
        for (int i = 0; i < jsonArray.length(); ++i) {
            String dictKey = null;
            String keyLabel = null;
            String arrayItem = jsonArray.get(i).toString();
            if (arrayItem.contains("=")) {
                String[] keyVal = arrayItem.split("=");
                if (keyVal.length > 1) {
                    keyLabel = keyVal[1];
                }
            } else {
                keyLabel = arrayItem;
            }
            if (keyLabel == null) continue;
            dictKey = keyLabel;
            newDictionaryMessageKeys.add(GuideUtils.getNamespacedKeys(dictKey));
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    protected void bindJsonObjectCreator(JsonObjectCreator jsonObjectCreator) {
        this.jsonObjectCreator = jsonObjectCreator;
    }

    protected void unbindJsonObjectCreator(JsonObjectCreator jsonObjectCreator) {
        if (this.jsonObjectCreator == jsonObjectCreator) {
            this.jsonObjectCreator = null;
        }
    }

    protected void bindGuideSchema(GuideSchemaService guideSchemaService) {
        this.guideSchema = guideSchemaService;
    }

    protected void unbindGuideSchema(GuideSchemaService guideSchemaService) {
        if (this.guideSchema == guideSchemaService) {
            this.guideSchema = null;
        }
    }
}

