/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.addon.fdm.submit;

import com.adobe.aem.dermis.api.IFormDataModelManager;
import com.adobe.aem.dermis.api.bridge.DataContext;
import com.adobe.aem.dermis.api.bridge.IDermisBridge;
import com.adobe.aem.dermis.api.bridge.OperationOptions;
import com.adobe.aem.dermis.api.bridge.Query;
import com.adobe.aem.dermis.model.IProperty;
import com.adobe.aem.dermis.model.PropertyType;
import com.adobe.aem.dermis.model.value.ITypeValue;
import com.adobe.aem.dermis.model.value.IValue;
import com.adobe.aem.dermis.model.value.IValueList;
import com.adobe.aem.dermis.model.value.IValueMap;
import com.adobe.aem.dermis.slingmodel.Attribute;
import com.adobe.aem.dermis.slingmodel.Entity;
import com.adobe.aem.dermis.slingmodel.EntityOperation;
import com.adobe.aem.dermis.slingmodel.FormDataModel;
import com.adobe.aem.dermis.util.DermisUtils;
import com.adobe.aemds.guide.common.GuideContainer;
import com.adobe.aemds.guide.model.FormSubmitInfo;
import com.adobe.aemds.guide.service.FormSubmitActionService;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideModelImporter;
import com.adobe.aemds.guide.service.GuideModelTransformer;
import com.adobe.aemds.guide.service.external.FormDataModelService;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.JSONCreationOptions;
import com.adobe.cq.jsonschema.parser.IJsonSchemaValidatorParser;
import com.adobe.forms.common.service.FileAttachmentWrapper;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.BeanMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=false)
public abstract class AbstractFDMSubmitService
implements FormSubmitActionService {
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    protected IFormDataModelManager formDataModelManager;
    @Reference
    protected ResourceResolverHelper resourceResolverHelper;
    @Reference
    protected GuideModelImporter guideModelImporter;
    @Reference
    protected IJsonSchemaValidatorParser jsonSchemaValidatorParser;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    protected IDermisBridge dermisBridge;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    protected FormDataModelService formDataModelService;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    protected GuideModelTransformer guideModelTransformer;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected String getOperationName(FormSubmitInfo formSubmitInfo, String entityPath) throws Exception {
        String operationName = null;
        Resource guideContainerResource = this.getAdaptiveFormContainerResource(formSubmitInfo);
        if (guideContainerResource == null) {
            this.logger.error("Guide Container resource cannot be null");
            return operationName;
        }
        String entityId = this.getEntityIdFromEnityPath(guideContainerResource, entityPath);
        if (StringUtils.isBlank((CharSequence)entityId)) {
            this.logger.error("Missing entity name");
            return operationName;
        }
        String formDataModelPath = this.getFormDataModelPath(guideContainerResource);
        FormDataModel formDataModel = this.getFormDataModel(formDataModelPath);
        if (formDataModel == null) {
            this.logger.error("Incorrect form data model path configured for Adaptive Form -" + formDataModelPath);
            return operationName;
        }
        if (formDataModel.getEntityById(entityId) != null) {
            operationName = formDataModel.getEntityById(entityId).getDefaultWriteOperation();
        } else {
            this.logger.error("Unable to find the entity with name " + entityId);
        }
        return operationName;
    }

    protected String getFormDataModelPath(Resource guideContainerResource) {
        GuideContainer guideContainer = GuideContainer.from(guideContainerResource);
        return guideContainer.getSchemaRef();
    }

    protected FormDataModel getFormDataModel(Resource guideContainerResource) throws Exception {
        String formDataModelPath = this.getFormDataModelPath(guideContainerResource);
        return this.getFormDataModel(formDataModelPath);
    }

    protected FormDataModel getFormDataModel(String formDataModelPath) throws Exception {
        if (formDataModelPath != null) {
            return this.formDataModelManager.getFormDataModel(formDataModelPath);
        }
        return null;
    }

    protected Resource getAdaptiveFormContainerResource(FormSubmitInfo formSubmitInfo) {
        ResourceResolver resourceResolver = this.resourceResolverHelper.getResourceResolver();
        return resourceResolver.getResource(formSubmitInfo.getFormContainerPath());
    }

    protected Object getEntityDataAsPerBindRef(Object data, String bindRef) throws JSONException {
        if (data != null && bindRef != null) {
            Object boundData = GuideUtils.getNakedBoundJsonData(data);
            String[] nameTokens = bindRef.split("/");
            Object currentNode = boundData;
            int pathTokensSize = nameTokens.length;
            if (currentNode != null) {
                for (int i = 1; i < pathTokensSize; ++i) {
                    String newData;
                    JSONObject newNode;
                    String pathToken = nameTokens[i];
                    boolean isLastToken = i == pathTokensSize - 1;
                    JSONObject jSONObject = newNode = currentNode instanceof JSONObject ? ((JSONObject)currentNode).optJSONObject(pathToken) : null;
                    if (newNode == null && currentNode instanceof JSONObject && ((JSONObject)currentNode).has(pathToken) && !(((JSONObject)currentNode).opt(pathToken) instanceof JSONArray) && StringUtils.isNotBlank((CharSequence)(newData = ((JSONObject)currentNode).optString(pathToken)))) {
                        newNode = new JSONObject(newData);
                        ((JSONObject)currentNode).put(pathToken, (Object)newNode);
                    }
                    if (newNode == null && !isLastToken) break;
                    if (isLastToken) {
                        JSONArray jsonArray;
                        if (newNode == null && currentNode instanceof JSONObject && (jsonArray = ((JSONObject)currentNode).optJSONArray(pathToken)) != null) {
                            data = jsonArray;
                            break;
                        }
                        data = newNode;
                    }
                    currentNode = newNode;
                }
            }
        }
        return data;
    }

    protected IValue submitEntityData(Object entityData, String operationId, String entityPath, FormSubmitInfo formSubmitInfo) throws Exception {
        Resource guideContainerResource = this.getAdaptiveFormContainerResource(formSubmitInfo);
        String formDataModelPath = this.getFormDataModelPath(guideContainerResource);
        JSONObject wrappedEntityData = this.getWrappedDataAsPerOperation(entityData, operationId, entityPath, formSubmitInfo);
        OperationOptions options = new OperationOptions(operationId, wrappedEntityData);
        Query query = new Query(formDataModelPath, this.getDataContext(formSubmitInfo, -1), options);
        return this.dermisBridge.executeOperation(query);
    }

    protected Object updateFormDataWithDorInfo(Object data, FormSubmitInfo formSubmitInfo, String entityPath) throws Exception {
        Resource guideContainerResource = this.getAdaptiveFormContainerResource(formSubmitInfo);
        String bindRef = this.getDORBindRef(formSubmitInfo);
        Object dorData = null;
        boolean isBinaryInline = this.checkIfJsonPathIsBinaryFormat(formSubmitInfo, this.convertToJsonSchemaPath(bindRef));
        if (!isBinaryInline) {
            this.submitBinaryData(formSubmitInfo, true, false, null);
            if (formSubmitInfo.getDocumentOfRecord() != null) {
                dorData = formSubmitInfo.getDocumentOfRecord().getUuid();
            }
        } else if (formSubmitInfo.getDocumentOfRecord() != null) {
            dorData = formSubmitInfo.getDocumentOfRecord().getValue();
        }
        if (dorData instanceof String && StringUtils.isNotBlank((CharSequence)dorData.toString()) || dorData instanceof byte[]) {
            String relativeDorBindRefToEntity = StringUtils.substringAfter((String)bindRef, (String)entityPath);
            String fieldName = StringUtils.substringAfterLast((String)relativeDorBindRefToEntity, (String)"/");
            Object parentObject = this.getEntityDataAsPerBindRef(data, StringUtils.substringBeforeLast((String)relativeDorBindRefToEntity, (String)"/"));
            if (parentObject != null && parentObject instanceof JSONObject) {
                if (dorData instanceof byte[]) {
                    ((JSONObject)parentObject).put(fieldName, dorData);
                } else if (dorData instanceof String) {
                    ((JSONObject)parentObject).put(fieldName, (Object)((String)dorData));
                }
            }
        }
        return data;
    }

    protected void updateFormDataWithAttachmentInfo(JSONObject formData, FormSubmitInfo formSubmitInfo) throws Exception {
        List attachmentBindRefs = this.getAttachmentFieldBindRef(formSubmitInfo);
        for (String bindRef : attachmentBindRefs) {
            Object bindRefData = this.getEntityDataAsPerBindRef(formData, bindRef);
            if (bindRefData == null) continue;
            Object parentBindRefData = this.getEntityDataAsPerBindRef(formData, StringUtils.substringBeforeLast((String)bindRef, (String)"/"));
            String key = StringUtils.substringAfterLast((String)bindRef, (String)"/");
            this.checkIfAttachmentExistsAndUpdateIt(parentBindRefData, key, bindRefData, formSubmitInfo, this.convertToJsonSchemaPath(bindRef));
        }
    }

    private void updateAttachmentUuid(FileAttachmentWrapper fileAttachment, IValue value, String binaryUUID) {
        if (fileAttachment != null && value != null) {
            if (value instanceof IValueList) {
                value = (IValue)((IValueList)value).get(0);
            }
            if (value instanceof IValueMap) {
                if (StringUtils.isNotBlank((CharSequence)binaryUUID)) {
                    String id = ((IValueMap)value).get(binaryUUID).toString();
                    fileAttachment.setUuid(id);
                } else {
                    fileAttachment.setUuid(null);
                    this.logger.debug("No primary key set for binary model in FDM");
                }
            } else if (value instanceof ITypeValue) {
                String id = ((ITypeValue)value).toString();
                fileAttachment.setUuid(id);
            }
        } else {
            this.logger.warn("Error in updating binary uuid in the data");
        }
    }

    private Object getFileAttachmentData(FormSubmitInfo formSubmitInfo, String fileAttachmentValue, boolean getBinary) {
        Object result = null;
        if (!getBinary) {
            result = new StringBuilder("");
        }
        String[] fileNames = StringUtils.split((String)fileAttachmentValue, (String)"\n");
        for (int i = 0; i < fileNames.length; ++i) {
            for (FileAttachmentWrapper fileAttachment : formSubmitInfo.getFileAttachments()) {
                if (!StringUtils.equals((CharSequence)StringUtils.substringAfterLast((String)fileAttachment.getFileName(), (String)"/"), (CharSequence)fileNames[i])) continue;
                if (!getBinary && fileAttachment.getUuid() != null) {
                    ((StringBuilder)result).append(fileAttachment.getUuid());
                    continue;
                }
                result = fileAttachment.getValue();
            }
            if (i == fileNames.length - 1 || getBinary) continue;
            ((StringBuilder)result).append("\n");
        }
        if (!getBinary) {
            return result.toString();
        }
        return result;
    }

    private String getEntityIdFromEnityPath(Resource guideContainerResource, String entityPath) {
        String entityId = null;
        if (StringUtils.isNotBlank((CharSequence)entityPath)) {
            entityId = this.formDataModelService.getFDMEntityId(guideContainerResource.getPath(), entityPath);
        }
        return entityId;
    }

    private String convertToJsonSchemaPath(String jsonPath) {
        String jsonSchemaPath = jsonPath;
        if (StringUtils.isNotBlank((CharSequence)jsonSchemaPath)) {
            jsonSchemaPath = StringUtils.replace((String)jsonSchemaPath, (String)"/", (String)"/properties/");
        }
        return jsonSchemaPath;
    }

    private String getDORBindRef(FormSubmitInfo formSubmitInfo) {
        String dorBindRef = null;
        ResourceResolver resourceResolver = this.resourceResolverHelper.getResourceResolver();
        Resource guideContainerResource = resourceResolver.getResource(formSubmitInfo.getFormContainerPath());
        if (guideContainerResource != null) {
            dorBindRef = (String)guideContainerResource.getValueMap().get("bindRef", (Object)"");
        }
        return dorBindRef;
    }

    private void submitBinaryData(FormSubmitInfo formSubmitInfo, Boolean isDorSubmission, Boolean isAttachmentSubmission, String fileAttachmentValue) throws Exception {
        ResourceResolver resourceResolver = this.resourceResolverHelper.getResourceResolver();
        Resource guideContainerResource = resourceResolver.getResource(formSubmitInfo.getFormContainerPath());
        String formDataModelPath = this.getFormDataModelPath(guideContainerResource);
        if (formSubmitInfo.getFileAttachments().size() > 0 || formSubmitInfo.getDocumentOfRecord() != null) {
            FormDataModel formDataModel = this.getFormDataModel(formDataModelPath);
            if (formDataModel == null) {
                throw new Exception("No form data model associated with AF container " + formSubmitInfo.getFormContainerPath());
            }
            Entity binaryEntity = this.formDataModelManager.getDefaultBinaryEntity(formDataModelPath);
            if (binaryEntity != null) {
                String binaryUuid = binaryEntity.getPrimaryKey();
                String defaultBinaryOperationId = binaryEntity.getDefaultWriteOperation();
                OperationOptions options = new OperationOptions(defaultBinaryOperationId, (JSONObject)null);
                if (isAttachmentSubmission.booleanValue() && StringUtils.isNotBlank((CharSequence)fileAttachmentValue)) {
                    String[] fileNames = StringUtils.split((String)fileAttachmentValue, (String)"\n");
                    block0: for (int j = 0; j < fileNames.length; ++j) {
                        for (int i = 0; i < formSubmitInfo.getFileAttachments().size(); ++i) {
                            if (!StringUtils.equals((CharSequence)StringUtils.substringAfterLast((String)formSubmitInfo.getFileAttachments().get(i).getFileName(), (String)"/"), (CharSequence)fileNames[j])) continue;
                            Query query = new Query(formDataModelPath, this.getDataContext(formSubmitInfo, i), options);
                            IValue value = this.dermisBridge.executeOperation(query);
                            FileAttachmentWrapper fileAttachment = formSubmitInfo.getFileAttachments().get(i);
                            this.updateAttachmentUuid(fileAttachment, value, binaryUuid);
                            continue block0;
                        }
                    }
                }
                if (isDorSubmission.booleanValue()) {
                    Query query = new Query(formDataModelPath, this.getDataContext(formSubmitInfo, -1), options);
                    IValue value = this.dermisBridge.executeOperation(query);
                    this.updateAttachmentUuid(formSubmitInfo.getDocumentOfRecord(), value, binaryUuid);
                }
            }
        }
    }

    private JSONObject getWrappedDataAsPerOperation(Object data, String operationId, String entityIdPath, FormSubmitInfo formSubmitInfo) throws Exception {
        JSONObject wrappedData = new JSONObject();
        FormDataModel formDataModel = this.getFormDataModel(this.getAdaptiveFormContainerResource(formSubmitInfo));
        String entityToSubmit = this.getEntityIdFromEnityPath(this.getAdaptiveFormContainerResource(formSubmitInfo), entityIdPath);
        EntityOperation operation = formDataModel.getOperationByReference(operationId);
        if (operation != null && operation.getSchema() != null) {
            Attribute argumentsDef = operation.getSchema();
            if (operation.hasMultipleArguments()) {
                for (IProperty iProperty : argumentsDef.getProperties()) {
                    if (PropertyType.OBJECT == iProperty.getType() && iProperty.getTypeRef().equals(entityToSubmit)) {
                        if (data instanceof JSONObject) {
                            String argumentName = iProperty.getName();
                            wrappedData.put(argumentName, data);
                            break;
                        }
                        this.logger.debug("Data to submit is expected of type Object for data model" + entityToSubmit);
                        throw new GuideException("Data to submit is expected of type Object for data model " + entityToSubmit);
                    }
                    if (PropertyType.ARRAY != iProperty.getType() || !iProperty.getTypeRef().equals(entityToSubmit)) continue;
                    if (data instanceof JSONArray) {
                        String argumentName = iProperty.getName();
                        wrappedData.put(argumentName, data);
                        break;
                    }
                    this.logger.debug("Data to submit is expected of type Array for data model " + entityToSubmit);
                    throw new GuideException("Data to submit is expected of type Array for data model " + entityToSubmit);
                }
            }
        }
        return wrappedData;
    }

    private DataContext getDataContext(FormSubmitInfo formSubmitInfo, int fileAttachmentIndex) {
        Map requestParamMap = null;
        BeanMap dorMap = null;
        BeanMap attachmentMap = null;
        if (fileAttachmentIndex > -1) {
            FileAttachmentWrapper fileAttachment = formSubmitInfo.getFileAttachments().get(fileAttachmentIndex);
            FileAttachmentWrapper fileAttachmentCopy = new FileAttachmentWrapper(fileAttachment.getFileName(), fileAttachment.getContentType(), fileAttachment.getValue());
            fileAttachmentCopy.setUuid(fileAttachment.getUuid());
            if (fileAttachmentCopy != null) {
                String fileName = fileAttachmentCopy.getFileName();
                if (StringUtils.isNotBlank((CharSequence)fileName)) {
                    if (StringUtils.indexOf((CharSequence)fileName, (CharSequence)"/") != -1) {
                        fileName = StringUtils.substring((String)fileName, (int)(StringUtils.lastIndexOf((CharSequence)fileName, (CharSequence)"/") + 1));
                    }
                    fileAttachmentCopy.setFileName(fileName);
                }
                attachmentMap = new BeanMap((Object)fileAttachmentCopy);
            }
        }
        if (formSubmitInfo.getDocumentOfRecord() != null) {
            dorMap = new BeanMap((Object)formSubmitInfo.getDocumentOfRecord());
        }
        Map resultMap = DermisUtils.createBinaryAndRequestDataContext(requestParamMap, attachmentMap, dorMap);
        return new DataContext(resultMap);
    }

    private boolean checkIfJsonPathIsBinaryFormat(FormSubmitInfo formSubmitInfo, String jsonSchemaPath) throws Exception {
        boolean isBinaryFormat = false;
        Resource guideContainerResource = this.getAdaptiveFormContainerResource(formSubmitInfo);
        JSONObject jsonSchema = this.guideModelImporter.getSchemaJson(guideContainerResource);
        JsonNode jsonNode = (JsonNode)this.jsonSchemaValidatorParser.getNodeAtPath((Object)jsonSchema, null, jsonSchemaPath);
        String format = null;
        if (jsonNode != null) {
            if (jsonNode.has("format")) {
                format = jsonNode.get("format").asText();
                isBinaryFormat = StringUtils.equals((CharSequence)format, (CharSequence)"binary");
            } else {
                isBinaryFormat = jsonNode.has("media");
            }
        }
        return isBinaryFormat;
    }

    private List getAttachmentFieldBindRef(FormSubmitInfo submitInfo) {
        JSONCreationOptions jsonCreationOptions;
        ArrayList bindRefs = new ArrayList();
        Resource guideContainerResource = this.getAdaptiveFormContainerResource(submitInfo);
        JSONObject guideJSON = this.guideModelTransformer.exportGuideJsonObject(guideContainerResource, jsonCreationOptions = new JSONCreationOptions(null, true, true, new Locale("en"), guideContainerResource));
        if (guideJSON != null) {
            try {
                this.walkGuideJson(guideJSON, bindRefs);
            }
            catch (Exception ex) {
                this.logger.error("Unable to get guide json for adaptive form container " + submitInfo.getFormContainerPath() + " in fdm submit service", (Throwable)ex);
            }
        }
        return bindRefs;
    }

    private void checkIfAttachmentExistsAndUpdateIt(Object parent, String key, Object value, FormSubmitInfo formSubmitInfo, String jsonPath) throws Exception {
        String fileAttachmentValue = ((JSONObject)value).optString("fileAttachment");
        if (StringUtils.isNotBlank((CharSequence)fileAttachmentValue)) {
            Object uuid;
            boolean isBinaryInline = this.checkIfJsonPathIsBinaryFormat(formSubmitInfo, jsonPath);
            if (!isBinaryInline) {
                this.submitBinaryData(formSubmitInfo, false, true, fileAttachmentValue);
            }
            if (StringUtils.isNotBlank((CharSequence)fileAttachmentValue) && ((uuid = this.getFileAttachmentData(formSubmitInfo, fileAttachmentValue, isBinaryInline)) instanceof String && StringUtils.isNotBlank((CharSequence)uuid.toString()) || uuid instanceof byte[]) && parent instanceof JSONObject) {
                ((JSONObject)parent).remove(key);
                ((JSONObject)parent).put(key, uuid);
            }
        }
    }

    private void walkGuideJson(JSONObject guideJson, List bindRefs) throws Exception {
        Iterator keys = guideJson.keys();
        while (keys.hasNext()) {
            String bindRef;
            String key = (String)keys.next();
            Object value = guideJson.get(key);
            if (StringUtils.equals((CharSequence)key, (CharSequence)"guideNodeClass") && value instanceof String && StringUtils.equals((CharSequence)value.toString(), (CharSequence)"guideFileUpload") && StringUtils.isNotBlank((CharSequence)(bindRef = guideJson.optString("bindRef")))) {
                bindRefs.add(bindRef);
            }
            if (value instanceof JSONObject) {
                this.walkGuideJson((JSONObject)value, bindRefs);
            }
            if (!(value instanceof JSONArray)) continue;
            JSONArray arrayData = (JSONArray)value;
            for (int i = 0; i < arrayData.length(); ++i) {
                if (!(arrayData.get(i) instanceof JSONObject)) continue;
                JSONObject nestedObject = arrayData.optJSONObject(i);
                this.walkGuideJson(nestedObject, bindRefs);
            }
        }
    }

    protected void bindFormDataModelManager(IFormDataModelManager iFormDataModelManager) {
        this.formDataModelManager = iFormDataModelManager;
    }

    protected void unbindFormDataModelManager(IFormDataModelManager iFormDataModelManager) {
        if (this.formDataModelManager == iFormDataModelManager) {
            this.formDataModelManager = null;
        }
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }

    protected void bindGuideModelImporter(GuideModelImporter guideModelImporter) {
        this.guideModelImporter = guideModelImporter;
    }

    protected void unbindGuideModelImporter(GuideModelImporter guideModelImporter) {
        if (this.guideModelImporter == guideModelImporter) {
            this.guideModelImporter = null;
        }
    }

    protected void bindJsonSchemaValidatorParser(IJsonSchemaValidatorParser iJsonSchemaValidatorParser) {
        this.jsonSchemaValidatorParser = iJsonSchemaValidatorParser;
    }

    protected void unbindJsonSchemaValidatorParser(IJsonSchemaValidatorParser iJsonSchemaValidatorParser) {
        if (this.jsonSchemaValidatorParser == iJsonSchemaValidatorParser) {
            this.jsonSchemaValidatorParser = null;
        }
    }

    protected void bindDermisBridge(IDermisBridge iDermisBridge) {
        this.dermisBridge = iDermisBridge;
    }

    protected void unbindDermisBridge(IDermisBridge iDermisBridge) {
        if (this.dermisBridge == iDermisBridge) {
            this.dermisBridge = null;
        }
    }

    protected void bindFormDataModelService(FormDataModelService formDataModelService) {
        this.formDataModelService = formDataModelService;
    }

    protected void unbindFormDataModelService(FormDataModelService formDataModelService) {
        if (this.formDataModelService == formDataModelService) {
            this.formDataModelService = null;
        }
    }

    protected void bindGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        this.guideModelTransformer = guideModelTransformer;
    }

    protected void unbindGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        if (this.guideModelTransformer == guideModelTransformer) {
            this.guideModelTransformer = null;
        }
    }
}

