/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.addon.dor;

import com.adobe.aemds.guide.addon.dor.BrandingComponentUtils;
import com.adobe.aemds.guide.addon.dor.ConfigPropertiesUtils;
import com.adobe.aemds.guide.addon.dor.DoRThreadLocal;
import com.adobe.aemds.guide.addon.dor.MetaTemplateConventions;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.XFA;
import com.adobe.xfa.content.ImageValue;
import com.adobe.xfa.content.TextValue;
import com.adobe.xfa.protocol.ProtocolUtils;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.containers.Subform;
import com.day.cq.i18n.I18n;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaTemplateParser {
    private static final Logger log = LoggerFactory.getLogger(MetaTemplateParser.class);
    private Document document;
    private String metaTemplateRef;

    public MetaTemplateParser(Document document, String metaTemplateRef) {
        this.document = document;
        this.metaTemplateRef = metaTemplateRef;
    }

    public MetaTemplateParser(Document document) {
        this(document, null);
    }

    public List<String> getContentAreaList(NodeList pageAreaList) {
        ArrayList<String> contentAreaList = new ArrayList<String>();
        for (int i = 0; i < pageAreaList.length(); ++i) {
            for (Node child = ((Element)pageAreaList.item(i)).getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (!child.getClassName().equals("contentArea")) continue;
                contentAreaList.add("AF_MASTERPAGE[" + i + "]." + child.getName());
            }
        }
        return contentAreaList;
    }

    public List<String> getMasterPageList(NodeList masterPages) {
        ArrayList<String> masterPageList = new ArrayList<String>();
        for (int i = 0; i < masterPages.length(); ++i) {
            masterPageList.add("AF_MASTERPAGE[" + i + "]");
        }
        return masterPageList;
    }

    public JSONObject getBrandingComponents(I18n i18n) {
        return BrandingComponentUtils.getBrandingComponentsOfPage(this.getMasterPageList(), this.metaTemplateRef, i18n);
    }

    public NodeList getMasterPageList() {
        NodeList masterPagesList;
        if (this.document == null) {
            return null;
        }
        TemplateModel templateModel = TemplateModel.getTemplateModel((AppModel)this.document.getAppModel(), (boolean)true);
        if (this.metaTemplateRef != null) {
            this.resolveImageReferences(templateModel, this.metaTemplateRef);
        }
        if ((masterPagesList = templateModel.resolveNodes("AF_METATEMPLATE.#pageSet[0].AF_MASTERPAGE[*]", false, false, false)) != null && masterPagesList.length() == 0) {
            masterPagesList = templateModel.resolveNodes("#subform[0].#pageSet[0].#pageArea[*]", false, false, false);
        }
        return masterPagesList;
    }

    private void resolveImageReferences(TemplateModel templateModel, String metaTemplateRef) {
        this.processNode((Node)templateModel, metaTemplateRef);
    }

    private void processNode(Node node, String metaTemplateRef) {
        int index;
        String base = null;
        String absolutePath = null;
        if (metaTemplateRef != null && !metaTemplateRef.isEmpty() && (index = metaTemplateRef.lastIndexOf(47)) != -1) {
            base = metaTemplateRef.substring(0, index + 1);
        }
        try {
            ImageValue child;
            if (node instanceof ImageValue && (child = (ImageValue)node).isPropertySpecified(XFA.HREFTAG, true, 0) && !child.isPropertySpecified(XFA.TRANSFERENCODINGTAG, true, 0)) {
                String path = child.getAttribute(XFA.HREFTAG).getAttrValue();
                boolean isCRXPath = true;
                if (path.startsWith("/content")) {
                    absolutePath = path;
                } else if (path.startsWith(".") && base != null) {
                    absolutePath = base + path.replace("\\", "/");
                } else {
                    try {
                        URI uri = new URI(path);
                        if (uri.getScheme() == null && base != null) {
                            absolutePath = base + path.replace("\\", "/");
                        } else {
                            isCRXPath = false;
                        }
                    }
                    catch (URISyntaxException e) {
                        log.error("Error during resolving image reference", (Throwable)e);
                        return;
                    }
                }
                InputStream inputStream = null;
                if (isCRXPath) {
                    if (absolutePath != null) {
                        ResourceResolver resourceResolver = DoRThreadLocal.getResourceResolver();
                        Resource resource = resourceResolver.getResource(absolutePath + "/jcr:content/renditions/original/jcr:content");
                        if (resource != null) {
                            inputStream = (InputStream)resource.adaptTo(InputStream.class);
                        }
                    } else {
                        log.error("The path of base template is not provided");
                    }
                } else {
                    inputStream = ProtocolUtils.openUrl((String)path);
                }
                if (inputStream == null) {
                    return;
                }
                byte[] imageBytes = IOUtils.toByteArray((InputStream)inputStream);
                inputStream.close();
                String contentType = child.getAttribute(XFA.CONTENTTYPETAG).getAttrValue();
                child.setValue(imageBytes, contentType);
                Element parent = child.getXFAParent().getXFAParent();
                TemplateModel templateModel = TemplateModel.getTemplateModel((AppModel)this.document.getAppModel(), (boolean)true);
                Element desc = templateModel.createElement("desc", null, parent);
                TextValue textValue = new TextValue(desc, null);
                textValue.setValue(path);
                textValue.setName("embeddedHref");
            }
            for (Node child2 = node.getFirstXFAChild(); child2 != null; child2 = child2.getNextXFASibling()) {
                this.processNode(child2, metaTemplateRef);
            }
        }
        catch (IOException e) {
            log.error("Failed to load image bytes for " + absolutePath, (Throwable)e);
        }
        catch (Exception e) {
            log.error("Failed to load image bytes for " + absolutePath, (Throwable)e);
        }
    }

    public Map<String, Element> getDefaultElements() {
        HashMap<String, Element> defaultElements = new HashMap<String, Element>(0);
        if (this.document == null) {
            return defaultElements;
        }
        TemplateModel templateModel = TemplateModel.getTemplateModel((AppModel)this.document.getAppModel(), (boolean)true);
        Subform subform = (Subform)templateModel.resolveNode("AF_METATEMPLATE.AF_FIELDSSUBFORM");
        if (subform == null) {
            return defaultElements;
        }
        for (String str : MetaTemplateConventions.ELEMENTS) {
            Element element = (Element)subform.resolveNode(str);
            defaultElements.put(str, element);
        }
        for (String str : MetaTemplateConventions.TABLE_ELEMENTS) {
            String parentSubform = "AF_TABLE_XFO";
            Element element = (Element)subform.resolveNode(parentSubform + "." + str);
            defaultElements.put(str, element);
        }
        return defaultElements;
    }

    public Element getVariables() {
        if (this.document == null) {
            return null;
        }
        TemplateModel templateModel = TemplateModel.getTemplateModel((AppModel)this.document.getAppModel(), (boolean)true);
        Element variables = (Element)templateModel.resolveNode("#subform[0].#variables[0]");
        return variables;
    }

    public Element getHyphenationElement() {
        if (this.document == null) {
            return null;
        }
        TemplateModel templateModel = TemplateModel.getTemplateModel((AppModel)this.document.getAppModel(), (boolean)true);
        Element hyphenation = (Element)templateModel.resolveNode("#subform[0].designer__defaultHyphenation");
        return hyphenation;
    }

    public JSONObject getConfigProperties(I18n i18n) {
        if (this.document == null) {
            return null;
        }
        TemplateModel templateModel = TemplateModel.getTemplateModel((AppModel)this.document.getAppModel(), (boolean)true);
        Subform rootSubform = (Subform)templateModel.resolveNode("AF_METATEMPLATE");
        return ConfigPropertiesUtils.getConfigProperties(rootSubform, i18n);
    }

    public Element getFillerElement() {
        if (this.document == null) {
            return null;
        }
        TemplateModel templateModel = TemplateModel.getTemplateModel((AppModel)this.document.getAppModel(), (boolean)true);
        Element filler = (Element)templateModel.resolveNode("#subform[0].spaceFiller");
        return filler;
    }

    public Element getFontFamily() {
        if (this.document == null) {
            return null;
        }
        TemplateModel templateModel = TemplateModel.getTemplateModel((AppModel)this.document.getAppModel(), (boolean)true);
        Element font = (Element)templateModel.resolveNode("#subform[0].#font");
        return font;
    }

    public Element getAccentColor() {
        if (this.document == null) {
            return null;
        }
        TemplateModel templateModel = TemplateModel.getTemplateModel((AppModel)this.document.getAppModel(), (boolean)true);
        Element color = (Element)templateModel.resolveNode("#subform[0].#fill.#color");
        return color;
    }
}

