/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.addon.dor;

import com.adobe.aemds.guide.addon.dor.AFDoRMapper;
import com.adobe.aemds.guide.addon.dor.DoRUtils;
import com.adobe.aemds.guide.addon.dor.MetaTemplateConventions;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.Proto;
import com.adobe.xfa.XFA;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.content.TextValue;
import com.adobe.xfa.template.Items;
import com.adobe.xfa.template.Value;
import com.adobe.xfa.template.containers.ContentArea;
import com.adobe.xfa.template.containers.Draw;
import com.adobe.xfa.template.containers.ExclGroup;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.ui.UI;
import com.day.cq.i18n.I18n;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrandingComponentUtils {
    private static final Logger logger = LoggerFactory.getLogger(BrandingComponentUtils.class);
    public static final String CONTAINER_PATH = "granite/ui/components/coral/foundation/container";

    private static String translate(String text, I18n i18n) {
        return i18n != null ? i18n.get(text) : text;
    }

    private static String translateVar(String text, I18n i18n) {
        return i18n != null ? i18n.getVar(text) : text;
    }

    public static JSONObject getBrandingComponentsOfPage(NodeList masterPages, String metaTemplateRef, I18n i18n) {
        if (masterPages == null) {
            return null;
        }
        JSONObject branding = new JSONObject();
        JSONObject brandingComponents = new JSONObject();
        JSONObject masterChild = new JSONObject();
        try {
            brandingComponents.put("sling:resourceType", (Object)CONTAINER_PATH);
            brandingComponents.put("name", (Object)"branding");
            brandingComponents.put("jcr:title", (Object)"Container for branding components");
            brandingComponents.put("items", (Object)masterChild);
            branding.put("branding", (Object)brandingComponents);
            for (int i = 0; i < masterPages.length(); ++i) {
                JSONObject masterPageContent = new JSONObject();
                JSONObject brandingItems = new JSONObject();
                String namePrefix = "./branding/items/masterpage" + i + "/items";
                masterChild.put("masterpage" + i, (Object)masterPageContent);
                masterPageContent.put("sling:resourceType", (Object)CONTAINER_PATH);
                if (masterPages.length() == 1) {
                    masterPageContent.put("jcr:title", (Object)BrandingComponentUtils.translateVar("Master Page Properties", i18n));
                } else {
                    masterPageContent.put("jcr:title", (Object)BrandingComponentUtils.translateVar("Master Page " + i + " Properties", i18n));
                }
                masterPageContent.put("items", (Object)brandingItems);
                for (Node child = ((Element)masterPages.item(i)).getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    if (!BrandingComponentUtils.isBrandingComponent(child)) continue;
                    String name = child.getName();
                    JSONObject component = BrandingComponentUtils.getBrandingComponent(child, metaTemplateRef, namePrefix, i18n);
                    if (component == null) continue;
                    BrandingComponentUtils.addSelectionComponentIfRequired(brandingItems, metaTemplateRef, child, component, i18n);
                    brandingItems.put(name, (Object)component);
                    if (!component.has("resourceType")) continue;
                    brandingItems.put("resourceType", (Object)BrandingComponentUtils.getResourceTypeComponent(component));
                }
            }
        }
        catch (JSONException e) {
            logger.error("[AF] [DoR] Error while extracting branding components from meta-template", (Throwable)e);
        }
        return masterChild.length() != 0 ? branding : null;
    }

    public static boolean isBrandingComponent(Node node) {
        boolean status;
        block15: {
            block16: {
                Node content;
                block14: {
                    status = false;
                    if (node != null) break block14;
                    status = false;
                    break block15;
                }
                if (!(node instanceof Draw) && !(node instanceof Field)) break block16;
                Element element = (Element)node;
                ArrayList pis = new ArrayList();
                element.getPI("templateDesigner", "floatingFieldPlaceholder", pis, true);
                if (!pis.isEmpty()) {
                    return false;
                }
                Value valueNode = (Value)node.resolveNode("#value", true, false, true);
                Node node2 = content = valueNode != null ? valueNode.getOneOfChild() : null;
                if (content == null) {
                    return true;
                }
                switch (content.getClassName()) {
                    case "line": 
                    case "arc": 
                    case "rectangle": {
                        status = false;
                        break;
                    }
                    case "exData": {
                        String value = DoRUtils.getValue((Content)content);
                        if (StringUtils.contains((CharSequence)value, (CharSequence)"xfa:embed")) {
                            status = false;
                            break;
                        }
                        break block15;
                    }
                    default: {
                        status = true;
                        break;
                    }
                }
                break block15;
            }
            if (node.isContainer() && !(node instanceof ContentArea) && !(node instanceof Proto)) {
                status = true;
            }
        }
        return status;
    }

    private static JSONObject getBrandingComponent(Node brandingNode, String metaTemplateRef, String namePrefix, I18n i18n) {
        JSONObject properties = new JSONObject();
        try {
            if (brandingNode instanceof Field) {
                int uiElement = ((UI)((Field)brandingNode).getNode(XFA.UITAG, 0)).getOneOfChild().getClassTag();
                if (uiElement == XFA.CHECKBUTTONTAG) {
                    properties = BrandingComponentUtils.getBrandingComponentForCheckBox(brandingNode, namePrefix, i18n);
                } else if (uiElement == XFA.CHOICELISTTAG) {
                    properties = BrandingComponentUtils.getBrandingComponentForChoiceList(brandingNode, namePrefix, i18n);
                } else if (uiElement == XFA.IMAGEEDITTAG) {
                    properties = BrandingComponentUtils.getBrandingComponentForImage(brandingNode, namePrefix, i18n);
                } else {
                    properties.put("name", (Object)(namePrefix + "/" + brandingNode.getName() + "/value"));
                    String fieldLabel = BrandingComponentUtils.getFieldLabel(brandingNode);
                    properties.put("fieldLabel", (Object)BrandingComponentUtils.translateVar(fieldLabel, i18n));
                    String xfaElement = XFA.getString((int)uiElement);
                    String slingResourceType = AFDoRMapper.getSlingResourceType(xfaElement);
                    properties.put("sling:resourceType", (Object)slingResourceType);
                }
                if (uiElement != XFA.IMAGEEDITTAG) {
                    Value value = (Value)brandingNode.resolveNode("#value", true, false, true);
                    properties.put("value", (Object)BrandingComponentUtils.getValue(value));
                }
            } else if (brandingNode instanceof Draw) {
                int uiElement = ((UI)((Draw)brandingNode).getNode(XFA.UITAG, 0)).getOneOfChild().getClassTag();
                if (uiElement == XFA.TEXTEDITTAG) {
                    properties = BrandingComponentUtils.getBrandingComponentForStaticText(brandingNode, namePrefix, i18n);
                } else if (uiElement == XFA.IMAGEEDITTAG) {
                    properties = BrandingComponentUtils.getBrandingComponentForImage(brandingNode, namePrefix, i18n);
                }
            } else if (brandingNode instanceof ExclGroup) {
                properties = BrandingComponentUtils.getBrandingComponentForExclGroup(brandingNode, namePrefix, i18n);
            } else if (brandingNode.isContainer() && BrandingComponentUtils.isBrandingComponent(brandingNode)) {
                properties = BrandingComponentUtils.getBrandingComponentForContainer(brandingNode, metaTemplateRef, namePrefix, i18n);
            }
        }
        catch (JSONException e) {
            logger.error("Error while extracting branding components from meta-template", (Throwable)e);
        }
        return properties;
    }

    private static JSONObject getBrandingComponentForContainer(Node brandingNode, String metaTemplateRef, String namePrefix, I18n i18n) throws JSONException {
        JSONObject properties = new JSONObject();
        JSONObject items = new JSONObject();
        String containerName = brandingNode.getName();
        properties.put("name", (Object)containerName);
        properties.put("sling:resourceType", (Object)CONTAINER_PATH);
        properties.put("items", (Object)items);
        for (Node child = brandingNode.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!BrandingComponentUtils.isBrandingComponent(child)) continue;
            String name = child.getName();
            JSONObject component = BrandingComponentUtils.getBrandingComponent(child, metaTemplateRef, namePrefix + "/" + containerName + "/items", i18n);
            if (component == null) continue;
            BrandingComponentUtils.addSelectionComponentIfRequired(items, metaTemplateRef, child, component, i18n);
            items.put(name, (Object)component);
            if (!component.has("resourceType")) continue;
            items.put(name + "_" + "resourceType", (Object)BrandingComponentUtils.getResourceTypeComponent(component));
        }
        return items.length() != 0 ? properties : null;
    }

    private static JSONObject getBrandingComponentForExclGroup(Node brandingNode, String namePrefix, I18n i18n) throws JSONException {
        String fieldLabel = BrandingComponentUtils.getFieldLabel(brandingNode);
        JSONObject properties = new JSONObject();
        JSONObject items = new JSONObject();
        properties.put("name", (Object)(namePrefix + "/" + brandingNode.getName() + "/value"));
        properties.put("fieldLabel", (Object)BrandingComponentUtils.translateVar(fieldLabel, i18n));
        properties.put("sling:resourceType", (Object)"granite/ui/components/coral/foundation/form/radiogroup");
        properties.put("vertical", true);
        for (Node child = brandingNode.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            String _value;
            String itemValue;
            if (!BrandingComponentUtils.isBrandingComponent(child)) continue;
            JSONObject radioButton = new JSONObject();
            radioButton.put("sling:resourceType", (Object)"granite/ui/components/coral/foundation/form/radio");
            Value caption = (Value)child.resolveNode("#caption.#value", true, false, true);
            Value value = (Value)child.resolveNode("#value", true, false, true);
            Items radioButtonItem = (Items)child.resolveNode("#items", true, false, true);
            if (caption != null) {
                radioButton.put("text", (Object)BrandingComponentUtils.translateVar(BrandingComponentUtils.getValue(caption), i18n));
            }
            if (radioButtonItem != null && StringUtils.isNotBlank((CharSequence)(itemValue = DoRUtils.getValue((Content)radioButtonItem.getFirstXFAChild())))) {
                radioButton.put("value", (Object)itemValue);
            }
            if (value != null && StringUtils.isNotBlank((CharSequence)(_value = BrandingComponentUtils.getValue(value)))) {
                radioButton.put("checked", true);
            }
            items.put(child.getName(), (Object)radioButton);
        }
        properties.put("items", (Object)items);
        return properties;
    }

    private static JSONObject getBrandingComponentForImage(Node brandingNode, String namePrefix, I18n i18n) throws JSONException {
        Value valueNode = (Value)brandingNode.resolveNode("#value", true, false, true);
        Node value = null;
        if (valueNode != null) {
            value = valueNode.getOneOfChild(true, false);
        }
        String fieldLabel = BrandingComponentUtils.translateVar(BrandingComponentUtils.getFieldLabel(brandingNode), i18n);
        String width = null;
        String height = null;
        if (((Element)brandingNode).isPropertySpecified(XFA.WTAG, true, 0)) {
            width = ((Element)brandingNode).getAttribute(XFA.WTAG).getAttrValue();
        } else if (((Element)brandingNode).isPropertySpecified(XFA.MAXWTAG, true, 0)) {
            width = ((Element)brandingNode).getAttribute(XFA.MAXWTAG).getAttrValue();
        }
        if (((Element)brandingNode).isPropertySpecified(XFA.HTAG, true, 0)) {
            height = ((Element)brandingNode).getAttribute(XFA.HTAG).getAttrValue();
        } else if (((Element)brandingNode).isPropertySpecified(XFA.MAXHTAG, true, 0)) {
            height = ((Element)brandingNode).getAttribute(XFA.MAXHTAG).getAttrValue();
        }
        if (width != null || height != null) {
            fieldLabel = fieldLabel + " (";
            fieldLabel = fieldLabel + (width != null ? BrandingComponentUtils.translate("width", i18n) + ": " + width : "");
            fieldLabel = fieldLabel + (width != null && height != null ? BrandingComponentUtils.translate(",", i18n) + " " : "");
            fieldLabel = fieldLabel + (height != null ? BrandingComponentUtils.translate("height", i18n) + ": " + height : "");
            fieldLabel = fieldLabel + ") ";
        }
        JSONObject properties = new JSONObject();
        properties.put("namehint", (Object)(namePrefix + "/" + brandingNode.getName() + "/value"));
        properties.put("assetButtonText", (Object)BrandingComponentUtils.translate("Browse Assets", i18n));
        properties.put("async", true);
        properties.put("autoStart", false);
        properties.put("class", (Object)"cq-droptarget");
        properties.put("fieldLabel", (Object)fieldLabel);
        properties.put("fileNameParameter", (Object)"./fileName");
        properties.put("fileReferenceParameter", (Object)"fileReference");
        properties.put("granite:id", (Object)"imageUploadId");
        properties.put("mimeTypes", (Object)"image");
        properties.put("multiple", false);
        properties.put("name", (Object)"./file");
        properties.put("predicate", (Object)"nosystem");
        properties.put("rootPath", (Object)"/content/dam");
        properties.put("sizeLimit", 100000000);
        properties.put("sling:resourceType", (Object)"fd/af/authoring/components/granite/form/imageupload");
        properties.put("text", (Object)BrandingComponentUtils.translate("Upload", i18n));
        properties.put("title", (Object)BrandingComponentUtils.translate("Upload Image", i18n));
        properties.put("uploadUrl", (Object)"${requestPathInfo.resourcePath}");
        properties.put("useHTML5", true);
        if (value == null) {
            return properties;
        }
        if (value.isPropertySpecified(XFA.HREFTAG, true, 0)) {
            String href = BrandingComponentUtils.getValue(valueNode);
            href = href.replaceAll("\\\\", "/");
            properties.put("fileReference", (Object)href);
            properties.put("fileName", (Object)StringUtils.substringAfterLast((String)href, (String)"/"));
        } else {
            String fileName;
            String mimeType = ((Attribute)value.getProperty(XFA.CONTENTTYPETAG, 0)).getAttrValue();
            String jcrPrimaryType = "nt:resource";
            String jcrData = BrandingComponentUtils.getValue(valueNode);
            JSONObject jcrContent = new JSONObject();
            jcrContent.put("jcr:mimeType", (Object)mimeType);
            jcrContent.put("jcr:primaryType", (Object)jcrPrimaryType);
            jcrContent.put("jcr:data", (Object)jcrData);
            JSONObject file = new JSONObject();
            file.put("jcr:primaryType", (Object)"nt:file");
            file.put("jcr:content", (Object)jcrContent);
            properties.put("file", (Object)file);
            TextValue descText = (TextValue)brandingNode.resolveNode("desc.embeddedHref", true, false, true);
            if (descText != null && (fileName = descText.getValue()) != null) {
                fileName = fileName.replaceAll("\\\\", "/");
                fileName = StringUtils.substringAfterLast((String)fileName, (String)"/");
                properties.put("fileName", (Object)fileName);
            }
        }
        return properties;
    }

    private static JSONObject getBrandingComponentForStaticText(Node brandingNode, String namePrefix, I18n i18n) throws JSONException {
        Value valueNode = (Value)brandingNode.resolveNode("#value", true, false, true);
        String fieldLabel = BrandingComponentUtils.getFieldLabel(brandingNode);
        JSONObject properties = new JSONObject();
        properties.put("name", (Object)(namePrefix + "/" + brandingNode.getName() + "/value"));
        properties.put("fieldLabel", (Object)BrandingComponentUtils.translateVar(fieldLabel, i18n));
        properties.put("sling:resourceType", (Object)"granite/ui/components/coral/foundation/form/textarea");
        properties.put("resourceType", (Object)"granite/ui/components/coral/foundation/form/textarea");
        return properties;
    }

    private static JSONObject getBrandingComponentForCheckBox(Node brandingNode, String namePrefix, I18n i18n) throws JSONException {
        String fieldLabel = BrandingComponentUtils.translateVar(BrandingComponentUtils.getFieldLabel(brandingNode), i18n);
        String slingResourceType = AFDoRMapper.getSlingResourceType(XFA.getString((int)XFA.CHECKBUTTONTAG));
        JSONObject properties = new JSONObject();
        String onValue = ((Field)brandingNode).getOnValue();
        String offValue = ((Field)brandingNode).getOffValue();
        if (StringUtils.equals((CharSequence)onValue, (CharSequence)((Field)brandingNode).getRawValue())) {
            properties.put("checked", true);
        }
        properties.put("uncheckedValue", (Object)offValue);
        properties.put("text", (Object)BrandingComponentUtils.translateVar(fieldLabel, i18n));
        properties.put("sling:resourceSuperType", (Object)slingResourceType);
        properties.put("name", (Object)(namePrefix + "/" + brandingNode.getName() + "/value"));
        return properties;
    }

    private static JSONObject getBrandingComponentForChoiceList(Node brandingNode, String namePrefix, I18n i18n) throws JSONException {
        String fieldLabel = BrandingComponentUtils.getFieldLabel(brandingNode);
        String slingResourceType = AFDoRMapper.getSlingResourceType(XFA.getString((int)XFA.CHOICELISTTAG));
        JSONObject slingItems = DoRUtils.getItems((Field)brandingNode);
        JSONObject properties = new JSONObject();
        properties.put("items", (Object)slingItems);
        properties.put("fieldLabel", (Object)BrandingComponentUtils.translateVar(fieldLabel, i18n));
        properties.put("sling:resourceSuperType", (Object)slingResourceType);
        properties.put("name", (Object)(namePrefix + "/" + brandingNode.getName() + "/value"));
        return properties;
    }

    private static JSONObject getResourceTypeComponent(JSONObject component) {
        JSONObject resourceType = new JSONObject();
        try {
            String name = StringUtils.substringBeforeLast((String)component.getString("name"), (String)"/value");
            resourceType.put("name", (Object)(name + "/" + "resourceType"));
            resourceType.put("sling:resourceType", (Object)"granite/ui/components/coral/foundation/form/hidden");
            resourceType.put("value", (Object)component.getString("sling:resourceType"));
        }
        catch (JSONException e) {
            logger.error("Error while creating resource type for branding components from meta-template", (Throwable)e);
        }
        return resourceType;
    }

    private static JSONObject getSelectionComponent(JSONObject component, String metaTemplateRef, String mapping, String type, I18n i18n) throws JSONException {
        JSONObject datasource = new JSONObject();
        datasource.put("sling:resourceType", (Object)"fd/af/dor/datasource/branding/mapping");
        datasource.put("value", (Object)mapping);
        datasource.put("type", (Object)type);
        datasource.put("templateRef", (Object)metaTemplateRef);
        String name = "";
        String selectionComponentName = "";
        switch (type) {
            case "StaticText": {
                name = component.getString("name");
                break;
            }
            case "Image": {
                name = component.getString("namehint");
            }
        }
        selectionComponentName = name + "From";
        JSONObject graniteData = new JSONObject();
        graniteData.put("af.listeners.onload", (Object)("guidelib.touchlib.editLayer.dialogUtils.showOrHideBrandingComponent('" + selectionComponentName + "');"));
        graniteData.put("af.listeners.change", (Object)("guidelib.touchlib.editLayer.dialogUtils.showOrHideBrandingComponent('" + selectionComponentName + "');"));
        graniteData.put("branding-component", (Object)name);
        graniteData.put("type", (Object)type);
        JSONObject selectionComponent = new JSONObject();
        selectionComponent.put("name", (Object)selectionComponentName);
        selectionComponent.put("fieldLabel", (Object)component.getString("fieldLabel"));
        selectionComponent.put("deleteHint", true);
        selectionComponent.put("value", (Object)mapping);
        selectionComponent.put("emptyText", (Object)BrandingComponentUtils.translate("Enter Custom", i18n));
        selectionComponent.put("sling:resourceType", (Object)"granite/ui/components/coral/foundation/form/select");
        selectionComponent.put("granite:data", (Object)graniteData);
        selectionComponent.put("datasource", (Object)datasource);
        return selectionComponent;
    }

    private static void addSelectionComponentIfRequired(JSONObject items, String metaTemplateRef, Node brandingNode, JSONObject brandingComponent, I18n i18n) {
        try {
            if (brandingNode instanceof Draw) {
                String ui;
                boolean addSelectionComponent = false;
                String mapping = "";
                String type = "";
                String name = brandingNode.getName();
                switch (ui = ((UI)((Draw)brandingNode).getNode(XFA.UITAG, 0)).getOneOfChild().getClassName()) {
                    case "textEdit": {
                        type = "StaticText";
                        addSelectionComponent = true;
                        break;
                    }
                    case "imageEdit": {
                        type = "Image";
                        addSelectionComponent = true;
                    }
                }
                for (int i = 0; i < MetaTemplateConventions.BRANDING_COM_CONVENTION_NAMES.length; ++i) {
                    String conventionName = MetaTemplateConventions.BRANDING_COM_CONVENTION_NAMES[i];
                    if (!StringUtils.equals((CharSequence)name, (CharSequence)conventionName) || !StringUtils.equals((CharSequence)ui, (CharSequence)MetaTemplateConventions.BRANDING_COM_CONVENTION_TYPES[i])) continue;
                    mapping = MetaTemplateConventions.BRANDING_COM_CONVENTION_VALUE_FROM[i];
                    break;
                }
                if (addSelectionComponent) {
                    JSONObject selectionComponent = BrandingComponentUtils.getSelectionComponent(brandingComponent, metaTemplateRef, mapping, type, i18n);
                    items.put(brandingNode.getName() + UUID.randomUUID(), (Object)selectionComponent);
                    JSONObject hiddenInput = new JSONObject();
                    hiddenInput.put("sling:resourceType", (Object)"/libs/granite/ui/components/coral/foundation/form/hidden");
                    hiddenInput.put("name", (Object)(selectionComponent.getString("name") + "@IgnoreBlanks"));
                    hiddenInput.put("value", true);
                    items.put(brandingNode.getName() + UUID.randomUUID(), (Object)hiddenInput);
                    brandingComponent.remove("fieldLabel");
                }
            }
        }
        catch (JSONException e) {
            logger.error("Error while adding selection component from meta template", (Throwable)e);
        }
    }

    private static String getFieldLabel(Node brandingNode) {
        String fieldLabel = "";
        Value caption = (Value)brandingNode.resolveNode("#caption.#value", true, false, true);
        fieldLabel = BrandingComponentUtils.getValue(caption);
        if (StringUtils.isEmpty((CharSequence)fieldLabel)) {
            Content content = (Content)brandingNode.resolveNode("#desc.fieldLabel", true, false, true);
            fieldLabel = DoRUtils.getValue(content);
        }
        if (StringUtils.isBlank((CharSequence)fieldLabel)) {
            String name = brandingNode.getName();
            for (int i = 0; i < MetaTemplateConventions.BRANDING_COM_CONVENTION_NAMES.length; ++i) {
                if (!StringUtils.equals((CharSequence)name, (CharSequence)MetaTemplateConventions.BRANDING_COM_CONVENTION_NAMES[i])) continue;
                name = MetaTemplateConventions.BRANDING_COM_CONVENTION_FIELD_LABELS[i];
                break;
            }
            fieldLabel = name;
        }
        return fieldLabel;
    }

    private static String getValue(Value valueNode) {
        if (valueNode == null) {
            return null;
        }
        Content value = (Content)valueNode.getOneOfChild(true, false);
        return DoRUtils.getValue(value);
    }
}

