/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.model;

import com.adobe.aem.dermis.model.AbstractAsset;
import com.adobe.aem.dermis.model.IOperation;
import com.adobe.aem.dermis.model.IProperty;
import com.adobe.aem.dermis.model.PropertyType;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class Operation
extends AbstractAsset
implements IOperation {
    private String href;
    private String rel;
    private IOperation.MethodType method;
    private IProperty targetSchema;
    private IProperty schema;
    private String source;
    private boolean genericOperation;

    public Operation() {
    }

    public Operation(String name, String description, IOperation.MethodType method, IProperty targetSchema, IProperty schema) {
        super(name, description);
        this.method = method;
        this.targetSchema = targetSchema;
        this.schema = schema;
    }

    public Operation(String name, String description, IOperation.MethodType method, IProperty targetSchema, IProperty schema, boolean genericOperation) {
        this(name, description, method, targetSchema, schema);
        this.genericOperation = genericOperation;
    }

    public Operation(String name, String description, IOperation.MethodType method, IProperty targetSchema, IProperty schema, String href) {
        this(name, description, method, targetSchema, schema);
        this.href = href;
    }

    @Override
    public String getRel() {
        return this.rel;
    }

    public void setRel(String rel) {
        this.rel = rel;
    }

    @Override
    public String getHref() {
        return this.href;
    }

    @Override
    public IOperation.MethodType getMethod() {
        return this.method;
    }

    @Override
    public IProperty getTargetSchema() {
        return this.targetSchema;
    }

    @Override
    public IProperty getSchema() {
        return this.schema;
    }

    @Override
    @JsonIgnore
    public boolean hasMultipleArguments() {
        IProperty argument = this.getSchema();
        boolean result = false;
        result = argument != null && PropertyType.OBJECT == argument.getType();
        return result;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public boolean isGenericOperation() {
        return this.genericOperation;
    }

    public void setGenericOperation(boolean genericOperation) {
        this.genericOperation = genericOperation;
    }
}

