/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeLocation {
    @NotNull
    public static TreeLocation create(@NotNull Tree tree) {
        return new NodeLocation(tree);
    }

    @NotNull
    public static TreeLocation create(@NotNull Root root, @NotNull String path) {
        Preconditions.checkArgument(PathUtils.isAbsolute(path));
        TreeLocation location = TreeLocation.create(root.getTree("/"));
        for (String name : PathUtils.elements(path)) {
            location = location.getChild(name);
        }
        return location;
    }

    @NotNull
    public static TreeLocation create(@NotNull Root root) {
        return TreeLocation.create(root, "/");
    }

    @NotNull
    public abstract TreeLocation getParent();

    public abstract boolean exists();

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract String getPath();

    public abstract boolean remove();

    @NotNull
    public TreeLocation getChild(String name) {
        return new NullLocation(this, name);
    }

    @Nullable
    public Tree getTree() {
        return null;
    }

    @Nullable
    public PropertyState getProperty() {
        return null;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("path", this.getPath()).toString();
    }

    private static final class NullLocation
    extends TreeLocation {
        public static final NullLocation NULL = new NullLocation();
        private final TreeLocation parent;
        private final String name;

        public NullLocation(@NotNull TreeLocation parent, @NotNull String name) {
            this.parent = parent;
            this.name = name;
        }

        private NullLocation() {
            this.parent = this;
            this.name = "";
        }

        @Override
        @NotNull
        public TreeLocation getParent() {
            return this.parent;
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public String getPath() {
            return this.parent == this ? "" : PathUtils.concat(this.parent.getPath(), this.name);
        }

        @Override
        public boolean remove() {
            return false;
        }
    }

    private static class PropertyLocation
    extends TreeLocation {
        private final Tree parent;
        private final String name;

        public PropertyLocation(@NotNull Tree parent, @NotNull String name) {
            this.parent = parent;
            this.name = name;
        }

        @Override
        @NotNull
        public TreeLocation getParent() {
            return new NodeLocation(this.parent);
        }

        @Override
        public boolean exists() {
            return this.parent.hasProperty(this.name);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @Nullable
        public PropertyState getProperty() {
            return this.parent.getProperty(this.name);
        }

        @Override
        @NotNull
        public String getPath() {
            return PathUtils.concat(this.parent.getPath(), this.name);
        }

        @Override
        public boolean remove() {
            this.parent.removeProperty(this.name);
            return true;
        }
    }

    private static class NodeLocation
    extends TreeLocation {
        private final Tree tree;

        public NodeLocation(Tree tree) {
            this.tree = tree;
        }

        @Override
        @NotNull
        public TreeLocation getParent() {
            return this.tree.isRoot() ? NullLocation.NULL : new NodeLocation(this.tree.getParent());
        }

        @Override
        @NotNull
        public TreeLocation getChild(String name) {
            if (this.tree.hasProperty(name)) {
                return new PropertyLocation(this.tree, name);
            }
            return new NodeLocation(this.tree.getChild(name));
        }

        @Override
        public boolean exists() {
            return this.tree.exists();
        }

        @Override
        @NotNull
        public String getName() {
            return this.tree.getName();
        }

        @Override
        @Nullable
        public Tree getTree() {
            return this.exists() ? this.tree : null;
        }

        @Override
        @NotNull
        public String getPath() {
            return this.tree.getPath();
        }

        @Override
        public boolean remove() {
            return this.exists() && this.tree.remove();
        }
    }
}

