/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.workflow.process;

import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.Collections;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={WorkflowProcess.class})
@Properties(value={@Property(name="process.label", value={"Delete Page"})})
public class DeletePageProcess
implements WorkflowProcess {
    @Reference
    protected ResourceResolverFactory resourceResolverFactory;
    private static final Logger log = LoggerFactory.getLogger(DeletePageProcess.class);
    private static final String TYPE_JCR_PATH = "JCR_PATH";

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        try {
            String payloadData;
            Session session = workflowSession.getSession();
            ResourceResolver resolver = this.resourceResolverFactory.getResourceResolver(Collections.singletonMap("user.jcr.session", session));
            WorkflowData data = workItem.getWorkflowData();
            String path = null;
            String type = data.getPayloadType();
            if (type.equals(TYPE_JCR_PATH) && data.getPayload() != null && session.itemExists(payloadData = (String)data.getPayload())) {
                path = payloadData;
            }
            if (path == null) {
                throw new WorkflowException("No path was given for the workflow");
            }
            Resource resource = resolver.getResource(path);
            Node node = resource.adaptTo(Node.class);
            if (session.nodeExists(node.getPath())) {
                node.remove();
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new WorkflowException(e);
        }
        catch (LoginException e) {
            throw new WorkflowException(e);
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

