/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.msm.commons;

import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.msm.api.ActionConfig;
import com.day.cq.wcm.msm.api.LiveAction;
import com.day.cq.wcm.msm.api.LiveRelationship;
import com.day.cq.wcm.msm.commons.BaseActionFactory;
import java.util.HashMap;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseAction
implements LiveAction {
    private static final Logger log = LoggerFactory.getLogger(BaseAction.class);
    private final ValueMap config;
    private final BaseActionFactory<? extends LiveAction> liveActionFactory;

    protected BaseAction(ValueMap config, BaseActionFactory<? extends LiveAction> liveActionFactory) {
        this.config = config;
        this.liveActionFactory = liveActionFactory;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    protected abstract boolean handles(Resource var1, Resource var2, LiveRelationship var3, boolean var4) throws RepositoryException, WCMException;

    protected abstract void doExecute(Resource var1, Resource var2, LiveRelationship var3, boolean var4) throws RepositoryException, WCMException;

    @Override
    public void execute(Resource source, Resource target, LiveRelationship relation, boolean autoSave, boolean isResetRollout) throws WCMException {
        try {
            if (this.handles(source, target, relation, isResetRollout)) {
                this.doExecute(source, target, relation, isResetRollout);
                log.debug("Executed action {} on rolling out source {} to target {}", this.getName(), relation.getSourcePath(), relation.getTargetPath());
                if (autoSave && (BaseAction.resourceHasNode(source) || BaseAction.resourceHasNode(target))) {
                    ResourceResolver resourceResolver;
                    ResourceResolver resourceResolver2 = resourceResolver = source == null ? target.getResourceResolver() : source.getResourceResolver();
                    if (resourceResolver != null && resourceResolver.hasChanges()) {
                        resourceResolver.commit();
                    }
                }
            } else {
                log.debug("{} did not act on request to roll-out {} to {}: precondition was not met", this.getName(), relation.getSourcePath(), relation.getTargetPath());
            }
        }
        catch (RepositoryException e) {
            throw new WCMException(e);
        }
        catch (PersistenceException pe) {
            throw new WCMException(pe);
        }
    }

    protected ValueMap getConfig() {
        return this.config;
    }

    protected BaseActionFactory<? extends LiveAction> getActionFactory() {
        return this.liveActionFactory;
    }

    public static boolean resourceHasNode(Resource resource) {
        return resource != null && resource.adaptTo(Node.class) != null;
    }

    public static boolean isPage(Node node) throws RepositoryException {
        if (node == null) {
            return false;
        }
        boolean isPage = node.isNodeType("cq:Page");
        if (!isPage) {
            isPage = "jcr:content".equals(node.getName()) && node.getDefinition().getDeclaringNodeType().isNodeType("cq:Page");
        }
        return isPage;
    }

    @Override
    @Deprecated
    public void execute(ResourceResolver resolver, LiveRelationship relation, ActionConfig config, boolean autoSave) throws WCMException {
        this.execute(resolver, relation, config, autoSave, false);
    }

    @Override
    @Deprecated
    public void execute(ResourceResolver resolver, LiveRelationship relation, ActionConfig config, boolean autoSave, boolean isResetRollout) throws WCMException {
        ValueMapDecorator valueMap = new ValueMapDecorator(new HashMap<String, Object>());
        valueMap.putAll(config.getProperties());
        LiveAction liveAction = this.liveActionFactory.newActionInstance(valueMap);
        liveAction.execute(resolver.getResource(relation.getSourcePath()), resolver.getResource(relation.getTargetPath()), relation, autoSave, isResetRollout);
    }

    @Override
    @Deprecated
    public String getParameterName() {
        String paramName = this.config != null ? this.config.get("cq.wcm.msm.action.parameter", "") : "";
        return paramName;
    }

    @Override
    @Deprecated
    public int getRank() {
        return 0;
    }

    @Override
    @Deprecated
    public String getTitle() {
        String title = this.config != null ? this.config.get("jcr:title", this.getName()) : "";
        return title;
    }

    @Override
    @Deprecated
    public String[] getPropertiesNames() {
        HashSet<String> propertySet = new HashSet<String>();
        if (this.config != null) {
            for (String key : this.config.keySet()) {
                if (key == null || key.matches("^(cq|sling|jcr):.*") || this.config.get(key, String.class) == null) continue;
                propertySet.add(key);
            }
        }
        return propertySet.toArray(new String[propertySet.size()]);
    }

    @Override
    @Deprecated
    public void write(JSONWriter jsonWriter) throws JSONException {
        jsonWriter.object();
        jsonWriter.key("name").value(this.getName());
        jsonWriter.key("parameter").value(this.getParameterName());
        jsonWriter.key("title").value(this.getTitle());
        jsonWriter.key("rank").value(this.getRank());
        jsonWriter.key("properites");
        jsonWriter.array();
        for (String prop : this.getPropertiesNames()) {
            jsonWriter.value(prop);
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }
}

