/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageFilter;
import com.day.text.Text;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;

public class Navigation
implements Iterable<Element> {
    private final PageFilter filter;
    private final int depth;
    private final Page root;
    private final String currentPath;
    private final String currentPathS;

    public Navigation(Page current, int absParent, PageFilter filter, int depth) {
        this.currentPath = current.getPath();
        this.currentPathS = this.currentPath + "/";
        Page r = current.getAbsoluteParent(absParent);
        this.root = r == null ? current : r;
        this.filter = filter;
        this.depth = depth;
    }

    @Override
    public Iterator<Element> iterator() {
        ArrayList<Element> list = new ArrayList<Element>();
        if (this.root != null) {
            this.fillList(list, this.root.listChildren(this.filter), this.depth - 1);
        }
        return list.iterator();
    }

    private void fillList(List<Element> list, Iterator<Page> pages, int limit) {
        boolean first = true;
        while (pages.hasNext()) {
            Page p = pages.next();
            Element e = new Element(p);
            e.first = first;
            first = false;
            e.last = !pages.hasNext();
            String path = p.getPath();
            if (path.equals(this.currentPath)) {
                e.current = true;
                e.onTrail = true;
            } else if (this.currentPathS.startsWith(path + "/")) {
                e.onTrail = true;
            }
            Iterator<Page> cs = null;
            if (limit > 0) {
                cs = p.listChildren(this.filter);
            }
            if (cs != null && cs.hasNext()) {
                e.children = true;
            }
            e.type = Element.Type.ITEM_BEGIN;
            list.add(e);
            if (e.children) {
                list.add(new Element(e, Element.Type.NODE_OPEN));
                this.fillList(list, cs, limit - 1);
                list.add(new Element(e, Element.Type.NODE_CLOSE));
            }
            list.add(new Element(e, Element.Type.ITEM_END));
        }
    }

    public static class Element {
        private Type type = Type.ITEM_BEGIN;
        private final Page page;
        private final String title;
        private boolean children;
        private boolean onTrail;
        private boolean current;
        private boolean first;
        private boolean last;

        private Element(Element e, Type type) {
            this.type = type;
            this.page = e.page;
            this.title = e.title;
            this.children = e.children;
            this.onTrail = e.onTrail;
            this.current = e.current;
            this.first = e.first;
            this.last = e.last;
        }

        private Element(Page page) {
            this.page = page;
            String t = page.getNavigationTitle();
            if (t == null) {
                t = page.getTitle();
            }
            this.title = t == null ? page.getName() : t;
        }

        public Type getType() {
            return this.type;
        }

        public Page getPage() {
            return this.page;
        }

        public String getPath() {
            return Text.escape(this.page.getPath(), '%', true);
        }

        public String getRawTitle() {
            return this.title;
        }

        public String getTitle() {
            return StringEscapeUtils.escapeHtml4(this.title);
        }

        public boolean hasChildren() {
            return this.children;
        }

        public boolean isOnTrail() {
            return this.onTrail;
        }

        public boolean isCurrent() {
            return this.current;
        }

        public boolean isFirst() {
            return this.first;
        }

        public boolean isLast() {
            return this.last;
        }

        public static enum Type {
            NODE_OPEN,
            ITEM_BEGIN,
            ITEM_END,
            NODE_CLOSE;

        }
    }
}

