/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization.tags;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.personalization.ClientContextUtil;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.jsp.util.TagUtil;

public class ContextProfilePropertyTag
extends TagSupport {
    private static final long serialVersionUID = 4646561799994266940L;
    private String propertyName;
    private String store;
    private String prefix;
    private String suffix;

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.propertyName = null;
        this.store = "profile";
        this.prefix = "";
        this.suffix = "";
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        SlingHttpServletRequest request = TagUtil.getRequest(this.pageContext);
        try {
            out.println(this.getScript(request));
        }
        catch (IOException e) {
            throw new JspException("Could not write script for context profile property", (Throwable)e);
        }
        return 6;
    }

    String getScript(SlingHttpServletRequest request) {
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        XSSAPI xssAPI = bindings.getSling().getService(XSSAPI.class).getRequestSpecificAPI(request);
        StringBuilder res = new StringBuilder();
        String id = this.store + "-" + this.propertyName + "-" + ClientContextUtil.getId(request.getResource().getPath());
        res.append("<span id=\"").append(xssAPI.encodeForHTMLAttr(id)).append("\">").append("</span>");
        res.append("<script type=\"text/javascript\">\n");
        res.append("if( window.CQ_Analytics ) {");
        res.append("CQ_Analytics.ClientContextUtils.renderStoreProperty(");
        res.append("'").append(xssAPI.encodeForJSString(id)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(this.store)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(this.propertyName)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(this.prefix)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(this.suffix)).append("',");
        res.append("'").append("").append("'");
        res.append(");");
        res.append("}");
        res.append("</script>");
        return res.toString();
    }
}

