/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.commons.metadata.SimpleXmpToJcrMetadataBuilder;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.commons.util.AssetCache;
import com.day.cq.dam.commons.util.AssetUpdate;
import com.day.cq.dam.commons.util.AssetUpdateMonitor;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.dam.core.process.MetadataExtractor;
import com.day.cq.dam.core.process.ProcessingProfileApplier;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.contentdetection.ContentAwareMimeTypeService;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true)
@Service
@Property(name="process.label", value={"Metadata Processor"})
public class MetadataProcessorProcess
extends AbstractAssetWorkflowProcess {
    private static final String METADATA_EXTRACED = "com.day.cq.dam.core.process.meta.extraced";
    private boolean sha1Enabled = false;
    private ProcessingProfileApplier processingProfileApplier = new ProcessingProfileApplier();
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policyOption=ReferencePolicyOption.GREEDY)
    protected volatile ContentAwareMimeTypeService contentAwareMimeTypeService;
    @Property(boolValue={true})
    public static final String ENABLE_SHA1_GEN = "cq.dam.enable.sha1";
    @Property(value={"adobe_dam:restrictions"}, unbounded=PropertyUnbounded.ARRAY, label="XSS protected properties", description="These properties will be passed through xss api before saving")
    public static final String XSS_PROTECTED_PROPERTIES = "cq.dam.metadata.xssprotected.properties";
    private String[] xssProtectedProperties;
    private static final String[] DEFAULT_XSS_PROTECTED_PROPERTIES = new String[]{"adobe_dam:restrictions"};
    private static final String ATTRIBUTE_EXTRACT_METADATA = "dam:extractMetadata";
    @Reference
    private XSSAPI xssApi;
    @Reference
    private SimpleXmpToJcrMetadataBuilder metadataBuilder;
    @Reference
    private AssetUpdateMonitor monitor;
    private static final Logger log = LoggerFactory.getLogger(MetadataProcessorProcess.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        block13: {
            if (workItem.getWorkflow().getMetaDataMap().get(METADATA_EXTRACED, Boolean.FALSE).booleanValue()) {
                log.debug("already executed in workflow {}", (Object)workItem.getWorkflow().getId());
                return;
            }
            AssetCache cache = DamUtil.getAssetCache();
            AssetUpdate update = this.monitor.startUpdate(workItem, this.getResourceResolver(workflowSession.getSession()), this);
            try {
                Session session = workflowSession.getSession();
                Asset asset = update.getAsset(new AssetUpdate.Check(){

                    @Override
                    public boolean isNullAcceptable() throws WorkflowException {
                        String wfPayload = workItem.getWorkflowData().getPayload().toString();
                        String message = "execute: cannot extract metadata, create references and apply processing profile, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
                        throw new WorkflowException(message);
                    }
                });
                if (null == asset) break block13;
                asset.setBatchMode(true);
                try {
                    asset.adaptTo(AssetManager.class).assignAssetID(asset);
                }
                catch (RepositoryException e) {
                    update.error(e);
                    log.error("Couldn't assign Asset ID to asset at {}.Please see if sufficient privileges are available", (Object)asset.getPath(), (Object)e);
                }
                AssetHandler assetHandler = this.getAssetHandler(asset.getMimeType());
                if (null != assetHandler) {
                    Node assetNode = asset.adaptTo(Node.class);
                    if (MetadataProcessorProcess.extractMetadataRequired(assetNode)) {
                        MetadataExtractor metadataExtractor = new MetadataExtractor(this.metadataBuilder);
                        metadataExtractor.extractMetadata(session, asset, assetHandler, this.sha1Enabled, null != this.contentAwareMimeTypeService ? this.contentAwareMimeTypeService : this.mimeTypeService);
                        assetHandler.processRelated(asset);
                    } else {
                        log.debug("execute: Metadata not extracted on Asset : {}. Property dam:extractMetadata is found to be false", (Object)asset.getPath());
                        update.ignore();
                    }
                    MetadataProcessorProcess.removeExtractMetadataProperty(assetNode);
                } else {
                    log.error("execute: cannot extract metadata, no handler found for asset [{}] with mime type [{}]", (Object)asset.getPath(), (Object)asset.getMimeType());
                    update.ignore();
                }
                String dcFormat = asset.getMimeType();
                String originalMime = asset.getOriginal().getMimeType();
                if (StringUtils.equalsIgnoreCase(originalMime, "application/octet-stream") && StringUtils.isNotBlank(dcFormat)) {
                    session.getNode(asset.getOriginal().getChild("jcr:content").getPath()).setProperty("jcr:mimeType", dcFormat);
                }
                this.processingProfileApplier.applyProcessingProfile(session, asset);
                this.processXSSProtectedProperties(asset, this.getResourceResolver(session));
                log.debug("remembering execution in workflow {}", (Object)workItem.getWorkflow().getId());
            }
            catch (Exception e) {
                update.error(e);
                log.warn("unexpected error occurred during metadata extraction. Cause: {}", (Object)e.getMessage(), (Object)e);
            }
            finally {
                cache.release();
                update.done();
            }
        }
    }

    private void processXSSProtectedProperties(Asset asset, ResourceResolver resourceResolver) {
        try {
            Resource assetResource = resourceResolver.getResource(asset.getPath());
            Resource metadataResource = assetResource.getChild("jcr:content/metadata");
            ModifiableValueMap metadataVM = metadataResource.adaptTo(ModifiableValueMap.class);
            for (String prop : this.xssProtectedProperties) {
                String propValue = asset.getMetadataValue(prop);
                if (!StringUtils.isNotBlank(propValue)) continue;
                metadataVM.put(prop, this.xssApi.encodeForHTML(propValue));
            }
        }
        catch (Exception e) {
            log.error("Exception occured while applying for xss to xss protected properties", (Object)e.getMessage());
        }
    }

    @Activate
    protected void Actiate(ComponentContext context) throws RepositoryException {
        this.sha1Enabled = OsgiUtil.toBoolean(context.getProperties().get(ENABLE_SHA1_GEN), true);
        this.xssProtectedProperties = OsgiUtil.toStringArray(context.getProperties().get(XSS_PROTECTED_PROPERTIES), DEFAULT_XSS_PROTECTED_PROPERTIES);
    }

    private static boolean extractMetadataRequired(Node assetNode) {
        boolean retVal = true;
        try {
            Node contentNode;
            if (assetNode.hasNode("jcr:content") && (contentNode = assetNode.getNode("jcr:content")).hasProperty(ATTRIBUTE_EXTRACT_METADATA)) {
                retVal = contentNode.getProperty(ATTRIBUTE_EXTRACT_METADATA).getBoolean();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return retVal;
    }

    private static void removeExtractMetadataProperty(Node assetNode) throws RepositoryException {
        try {
            Node contentNode;
            if (assetNode.hasNode("jcr:content") && (contentNode = assetNode.getNode("jcr:content")).hasProperty(ATTRIBUTE_EXTRACT_METADATA)) {
                contentNode.getProperty(ATTRIBUTE_EXTRACT_METADATA).remove();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    protected void bindContentAwareMimeTypeService(ContentAwareMimeTypeService contentAwareMimeTypeService) {
        this.contentAwareMimeTypeService = contentAwareMimeTypeService;
    }

    protected void unbindContentAwareMimeTypeService(ContentAwareMimeTypeService contentAwareMimeTypeService) {
        if (this.contentAwareMimeTypeService == contentAwareMimeTypeService) {
            this.contentAwareMimeTypeService = null;
        }
    }

    protected void bindXssApi(XSSAPI xSSAPI) {
        this.xssApi = xSSAPI;
    }

    protected void unbindXssApi(XSSAPI xSSAPI) {
        if (this.xssApi == xSSAPI) {
            this.xssApi = null;
        }
    }

    protected void bindMetadataBuilder(SimpleXmpToJcrMetadataBuilder simpleXmpToJcrMetadataBuilder) {
        this.metadataBuilder = simpleXmpToJcrMetadataBuilder;
    }

    protected void unbindMetadataBuilder(SimpleXmpToJcrMetadataBuilder simpleXmpToJcrMetadataBuilder) {
        if (this.metadataBuilder == simpleXmpToJcrMetadataBuilder) {
            this.metadataBuilder = null;
        }
    }

    protected void bindMonitor(AssetUpdateMonitor assetUpdateMonitor) {
        this.monitor = assetUpdateMonitor;
    }

    protected void unbindMonitor(AssetUpdateMonitor assetUpdateMonitor) {
        if (this.monitor == assetUpdateMonitor) {
            this.monitor = null;
        }
    }
}

