/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.util;

import com.day.cq.analytics.sitecatalyst.Framework;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MboxHelper {
    private static final Logger log = LoggerFactory.getLogger(MboxHelper.class);

    private MboxHelper() {
    }

    public static String getMboxName(Resource rsrc) {
        String mboxName = "";
        ValueMap resourceConfig = (rsrc = MboxHelper.getStartResource(rsrc)).adaptTo(ValueMap.class);
        if (resourceConfig != null) {
            mboxName = resourceConfig.get("jcr:title", "");
            if ("".equals(mboxName)) {
                mboxName = MboxHelper.getMboxId(rsrc);
            }
            mboxName = mboxName.replaceAll("\\s", "");
        }
        return mboxName;
    }

    public static String generateLocationName(Resource currentResource, WCMMode wcmMode, String ... ambitMappings) {
        String mboxName;
        String mboxBaseName = MboxHelper.getMboxName(currentResource);
        if (ambitMappings != null && ambitMappings.length > 0) {
            TreeSet<String> mappings = new TreeSet<String>();
            for (String mapping : ambitMappings) {
                if (mapping.endsWith("master")) continue;
                mappings.add(mapping);
            }
            String hashedInfo = mappings.size() > 0 ? "-" + MboxHelper.hashData(StringUtils.join(mappings, "#")) : "";
            mboxName = MboxHelper.qualifyMboxNameOrId(mboxBaseName + hashedInfo, wcmMode);
        } else {
            mboxName = MboxHelper.qualifyMboxNameOrId(mboxBaseName, wcmMode);
        }
        return mboxName;
    }

    public static String getMboxId(Resource rsrc) {
        String mboxId = "";
        if ((rsrc = MboxHelper.getStartResource(rsrc)) != null) {
            ValueMap vm = rsrc.adaptTo(ValueMap.class);
            String loc = vm.get("location", rsrc.getPath());
            mboxId = MboxHelper.getMboxId(loc);
        }
        return mboxId;
    }

    public static String qualifyMboxNameOrId(String mboxNameOrId, WCMMode wcmMode) {
        if (wcmMode == WCMMode.DISABLED) {
            return mboxNameOrId;
        }
        return mboxNameOrId + "--author";
    }

    public static String qualifyMboxNameOrId(String mboxNameOrId, WCMMode wcmMode, String ambitName) {
        if (StringUtils.isEmpty(ambitName) || "master".equals(ambitName)) {
            return MboxHelper.qualifyMboxNameOrId(mboxNameOrId, wcmMode);
        }
        return MboxHelper.qualifyMboxNameOrId(StringUtils.join((Object[])new String[]{mboxNameOrId, ambitName}, "-"), wcmMode);
    }

    public static String getMboxId(String location) {
        if (location.startsWith("/")) {
            location = location.substring(1);
        }
        return location.replaceAll("/", "-").replaceAll("-jcr:content", "");
    }

    public static Resource searchStartElement(Resource resource) {
        Resource current;
        if (ResourceUtil.getName(resource).equals("jcr:content")) {
            return null;
        }
        if (resource.getPath().lastIndexOf("/") == 0) {
            return null;
        }
        if (ResourceUtil.isA(resource, "cq/personalization/components/mbox/start")) {
            return resource;
        }
        Resource parent = ResourceUtil.getParent(resource);
        ArrayList<Resource> predecessor = new ArrayList<Resource>();
        Iterator<Resource> i = ResourceUtil.listChildren(parent);
        while (i.hasNext() && !(current = i.next()).getPath().equals(resource.getPath())) {
            predecessor.add(current);
        }
        Collections.reverse(predecessor);
        for (Resource current2 : predecessor) {
            if (ResourceUtil.isA(current2, "cq/personalization/components/mbox/start")) {
                return current2;
            }
            if (!ResourceUtil.isA(current2, "cq/personalization/components/mbox/end")) continue;
            return null;
        }
        return MboxHelper.searchStartElement(parent);
    }

    private static Resource getStartResource(Resource rsrc) {
        Resource startElement;
        if (ResourceUtil.isA(rsrc, "cq/personalization/components/mbox/end") && (startElement = MboxHelper.searchStartElement(rsrc)) != null) {
            return startElement;
        }
        return rsrc;
    }

    public static String getCustomMboxJsPath(Resource resource, Page currentPage, ConfigurationManager cfgMgr) throws RepositoryException {
        boolean isValidConfig;
        Configuration configuration = null;
        HierarchyNodeInheritanceValueMap mboxProperties = new HierarchyNodeInheritanceValueMap(resource);
        String[] services = mboxProperties.getInherited("cq:cloudserviceconfigs", new String[0]);
        if (services.length == 0) {
            mboxProperties = new HierarchyNodeInheritanceValueMap(currentPage.getContentResource());
            services = mboxProperties.getInherited("cq:cloudserviceconfigs", new String[0]);
        }
        if (cfgMgr != null) {
            configuration = cfgMgr.getConfiguration("testandtarget", services);
        }
        boolean bl = isValidConfig = configuration != null && configuration.getInherited("clientcode", null) != null;
        if (isValidConfig) {
            Node configNode = null;
            if (configuration != null) {
                configNode = configuration.getResource().adaptTo(Node.class);
            }
            if (configNode.hasNode("./jcr:content/public/mbox.js")) {
                Node scriptNode = configNode.getNode("./jcr:content/public/mbox.js");
                return scriptNode.getPath();
            }
        }
        return null;
    }

    public static boolean isAccurateRendering(Resource resource) throws RepositoryException {
        return resource.adaptTo(ValueMap.class).get("accurateTargeting", false);
    }

    public static List<String> getClientContextParameterNames(Resource resource, InheritanceValueMap pageProperties, ConfigurationManager configurationManager) throws RepositoryException {
        return new ArrayList<String>(MboxHelper.getMappedClientContextParameterNames(resource, pageProperties, configurationManager).values());
    }

    public static Map<String, String> getMappedClientContextParameterNames(Resource resource, InheritanceValueMap pageProperties, ConfigurationManager configurationManager) throws RepositoryException {
        LinkedHashMap<String, String> mappedProperties = new LinkedHashMap<String, String>();
        List<Object> directMappings = Arrays.asList((Object[])resource.adaptTo(ValueMap.class).get("cq:mappings", new String[0]));
        for (String string : directMappings) {
            mappedProperties.put(string, string.replace('/', '.'));
        }
        Framework framework = MboxHelper.getFramework(pageProperties, configurationManager);
        if (framework == null) {
            return mappedProperties;
        }
        for (String scVar : framework.scVars()) {
            mappedProperties.put(framework.getMapping(scVar), scVar);
        }
        return mappedProperties;
    }

    public static Map<String, String> getStaticParameters(Resource resource) {
        String[] staticParameters = resource.adaptTo(ValueMap.class).get("staticParams", new String[0]);
        HashMap<String, String> toReturn = new HashMap<String, String>();
        try {
            for (String keyAndValue : staticParameters) {
                JSONArray array = new JSONArray(keyAndValue);
                toReturn.put(array.getString(0), array.getString(1));
            }
        }
        catch (JSONException e) {
            log.error(e.getMessage(), e);
        }
        return toReturn;
    }

    private static Framework getFramework(InheritanceValueMap pageProperties, ConfigurationManager configurationManager) {
        String[] services = pageProperties.getInherited("cq:cloudserviceconfigs", new String[0]);
        log.debug("Found has {} service configs", (Object)services.length);
        if (services.length == 0) {
            return null;
        }
        Configuration configuration = configurationManager.getConfiguration("testandtarget", services);
        if (configuration == null) {
            return null;
        }
        log.debug("Resource configured to use configuration at {}", (Object)configuration.getPath());
        return configuration.getContentResource().adaptTo(Framework.class);
    }

    private static String hashData(String data) {
        MessageDigest md = null;
        String mappings = "";
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return data;
        }
        md.update(data.getBytes());
        byte[] hashedBytes = md.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hashedBytes.length; ++i) {
            sb.append(Integer.toString((hashedBytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }
}

