/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.content;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Element;
import com.adobe.xfa.Int;
import com.adobe.xfa.Node;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.content.DecimalScript;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.Numeric;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;

public final class DecimalValue
extends Content {
    int mnInputFracDigits;

    public DecimalValue(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, "decimal", "decimal", null, 92, "decimal");
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return super.equals(object) && this.getValue() == ((DecimalValue)object).getValue();
    }

    @Override
    public int hashCode() {
        long bits = Double.doubleToLongBits(this.getValue());
        return super.hashCode() ^ (int)(bits ^ bits >>> 32);
    }

    public String getFormattedValue() {
        int nFoundAt;
        boolean bNegativeNumber;
        int nNeedFracDigits;
        String value = this.getStrValue();
        if (StringUtils.isEmpty(value)) {
            return "";
        }
        Int oInt = (Int)this.getAttribute(508);
        int nFracDigits = oInt.getValue();
        Int oInt2 = (Int)this.getAttribute(539);
        int nLeadDigits = oInt2.getValue();
        if (nFracDigits == -1) {
            nNeedFracDigits = this.mnInputFracDigits;
        } else if (nFracDigits >= 0) {
            nNeedFracDigits = nFracDigits;
        } else {
            return "";
        }
        StringBuilder sFormattedValue = new StringBuilder(value);
        boolean bl = bNegativeNumber = value.indexOf(45) == 0;
        if (bNegativeNumber) {
            sFormattedValue.deleteCharAt(0);
        }
        if ((nFoundAt = sFormattedValue.toString().indexOf(46)) != -1) {
            if (nLeadDigits >= 0 && nFoundAt > nLeadDigits) {
                return "";
            }
            int nHaveFracDigits = sFormattedValue.length() - ++nFoundAt;
            if (nHaveFracDigits > nNeedFracDigits) {
                sFormattedValue.setLength(sFormattedValue.length() - (nHaveFracDigits - nNeedFracDigits));
            } else if (nFracDigits == -1) {
                while (nHaveFracDigits < nNeedFracDigits) {
                    sFormattedValue.append('0');
                    ++nHaveFracDigits;
                }
            }
        } else {
            if (nLeadDigits >= 0 && sFormattedValue.length() > nLeadDigits) {
                return "";
            }
            if (nFracDigits == -1 && nNeedFracDigits > 0) {
                sFormattedValue.append('.');
                while (nNeedFracDigits > 0) {
                    sFormattedValue.append('0');
                    --nNeedFracDigits;
                }
            }
        }
        if (bNegativeNumber) {
            sFormattedValue.insert(0, '-');
        }
        return sFormattedValue.toString();
    }

    @Override
    public ScriptTable getScriptTable() {
        return DecimalScript.getScriptTable();
    }

    public double getValue() {
        String sValue = this.getFormattedValue();
        double dVal = Numeric.stringToDouble(sValue, false);
        return dVal;
    }

    @Override
    public void setStrValue(String sText, boolean bNotify, boolean bDefault) {
        this.trackInputFracDigits(sText);
        super.setStrValue(sText, bNotify, bDefault);
    }

    public void setValue(double dValue, boolean bFromData, boolean bNotify, boolean bDefault) {
        Int oFracInt = (Int)this.getAttribute(508);
        Int oLeadInt = (Int)this.getAttribute(539);
        int nFracDigits = oFracInt.getValue();
        int nLeadDigits = oLeadInt.getValue();
        if (nFracDigits == -1) {
            nFracDigits = this.mnInputFracDigits;
        }
        String sValue = Numeric.doubleToString(dValue, nFracDigits, false);
        if (nLeadDigits < 0) {
            this.setStrValue(sValue, bNotify, bDefault);
            return;
        }
        boolean bNegativeNumber = sValue.indexOf(45) == 0;
        boolean bTooManyLeadDigits = false;
        int nFoundAt = sValue.indexOf(46);
        if (nFoundAt != -1) {
            if (bNegativeNumber) {
                --nFoundAt;
            }
            if (nFoundAt > nLeadDigits) {
                bTooManyLeadDigits = true;
            }
        } else if (sValue.length() > nLeadDigits) {
            bTooManyLeadDigits = true;
        }
        if (!bFromData && bTooManyLeadDigits) {
            if (!this.getAppModel().getLegacySetting(AppModel.XFA_LEGACY_V30_SCRIPTING)) {
                MsgFormatPos message = new MsgFormatPos(ResId.TypeMismatch);
                message.format(this.getSOMExpression());
                message.format(sValue);
                this.getModel().addErrorList(new ExFull(message), 3, this);
            }
            return;
        }
        this.setStrValue(sValue, bNotify, bDefault);
    }

    @Override
    public void setValue(String sValue, boolean bFromData, boolean bNotify, boolean bDefault) {
        if (StringUtils.isEmpty(sValue)) {
            super.setStrValue(null, true, false);
        } else {
            boolean bTypeMismatch;
            double dVal = Numeric.stringToDouble(sValue, true);
            boolean bl = bTypeMismatch = Double.isInfinite(dVal) || Double.isNaN(dVal);
            if (bTypeMismatch) {
                if (!this.getAppModel().getLegacySetting(AppModel.XFA_LEGACY_V30_SCRIPTING)) {
                    MsgFormatPos message = new MsgFormatPos(ResId.TypeMismatch);
                    message.format(this.getSOMExpression());
                    message.format(sValue);
                    this.getModel().addErrorList(new ExFull(message), 3, this);
                }
                if (this.getAppModel().getLegacySetting(AppModel.XFA_LEGACY_V29_SCRIPTING) && !this.getAppModel().getLegacySetting(AppModel.XFA_PATCH_W_2447677)) {
                    this.setStrValue(null, true, false);
                } else if (bFromData) {
                    this.setStrValue(sValue, bNotify, bDefault);
                }
                return;
            }
            try {
                Int oFracInt = (Int)this.getAttribute(508);
                int nFracDigits = oFracInt.getValue();
                if (bFromData || nFracDigits == -1) {
                    this.setStrValue(sValue, bNotify, bDefault);
                } else {
                    this.trackInputFracDigits(sValue);
                    this.setValue(dVal, bFromData, bNotify, bDefault);
                }
            }
            catch (NumberFormatException e) {
                super.setStrValue(null, true, false);
            }
        }
    }

    @Override
    public String toString() {
        return this.getFormattedValue();
    }

    private void trackInputFracDigits(String sValue) {
        int nFoundAt;
        this.mnInputFracDigits = 0;
        Int oFracInt = (Int)this.getAttribute(508);
        if (oFracInt.getValue() == -1 && sValue != null && (nFoundAt = sValue.indexOf(46)) != -1) {
            for (int i = nFoundAt + 1; i < sValue.length(); ++i) {
                char c = sValue.charAt(i);
                if ('0' > c || c > '9') {
                    this.mnInputFracDigits = -1;
                    break;
                }
                ++this.mnInputFracDigits;
            }
        }
    }

    public boolean valueHasTypeMismatch() {
        Int oLeadInt;
        int nLeadDigits;
        String sValue = this.getFormattedValue();
        double dVal = Numeric.stringToDouble(sValue, true);
        if (Double.isNaN(dVal) || Double.isInfinite(dVal)) {
            return true;
        }
        Int oFracInt = (Int)this.getAttribute(508);
        int nFracDigits = oFracInt.getValue();
        if (nFracDigits == -1) {
            nFracDigits = Integer.MAX_VALUE;
        }
        if ((nLeadDigits = (oLeadInt = (Int)this.getAttribute(539)).getValue()) == -1) {
            nLeadDigits = Integer.MAX_VALUE;
        }
        String sVal = this.getStrValue();
        boolean bBeforeDecimal = true;
        int length = sVal.length();
        int i = 0;
        while (i < length) {
            int c;
            i += (c = sVal.codePointAt(i)) <= 65535 ? 1 : 2;
            if (48 <= c && c <= 57) {
                if (bBeforeDecimal) {
                    --nLeadDigits;
                } else {
                    --nFracDigits;
                }
                if (nLeadDigits < 0) {
                    return true;
                }
                if (nFracDigits >= 0) continue;
                return true;
            }
            if (c != 46) continue;
            bBeforeDecimal = false;
        }
        return false;
    }
}

