/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.util;

import com.adobe.internal.util.Stack;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ArrayListStack<T>
implements Stack<T>,
List<T>,
Serializable {
    private ArrayList<T> items;
    private static final long serialVersionUID = 1L;

    public ArrayListStack() {
        this.items = new ArrayList();
    }

    public ArrayListStack(int size) {
        this.items = new ArrayList(size);
    }

    public ArrayListStack(ArrayList<T> list) {
        this.items = list;
    }

    public ArrayList<T> getArrayList() {
        return this.items;
    }

    @Override
    public T push(T elem) {
        this.items.add(elem);
        return elem;
    }

    @Override
    public T pop() throws EmptyStackException {
        int len = this.size();
        T obj = this.peek();
        this.items.remove(len - 1);
        return obj;
    }

    @Override
    public T peek() throws EmptyStackException {
        int len = this.size();
        if (len == 0) {
            throw new EmptyStackException();
        }
        return this.items.get(len - 1);
    }

    @Override
    public boolean empty() {
        return this.items.isEmpty();
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = this.size() - 1; i >= 0; --i) {
            result.append(this.items.get(i)).append('\n');
        }
        return result.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ArrayListStack)) {
            return false;
        }
        ArrayListStack oStack = (ArrayListStack)obj;
        if (this.items.size() != oStack.size()) {
            return false;
        }
        ListIterator<T> e1 = this.items.listIterator();
        ListIterator<T> e2 = oStack.getArrayList().listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            T o1 = e1.next();
            T o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (T obj : this.items) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public int search(T o) {
        int i = this.items.lastIndexOf(o);
        if (i >= 0) {
            return this.size() - i;
        }
        return -1;
    }

    @Override
    public void add(int index, T element) {
        this.items.add(index, element);
    }

    @Override
    public boolean add(T element) {
        return this.items.add(element);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        return this.items.addAll(collection);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        return this.items.addAll(index, collection);
    }

    @Override
    public boolean contains(Object o) {
        return this.items.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.items.containsAll(collection);
    }

    @Override
    public T get(int index) {
        return this.items.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.items.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.items.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.items.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.items.listIterator(index);
    }

    @Override
    public T remove(int index) {
        return this.items.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.items.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.items.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.items.retainAll(collection);
    }

    @Override
    public T set(int index, T element) {
        return this.items.set(index, element);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.items.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.items.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.items.toArray(a);
    }
}

