/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.foundation.service.handlers;

import com.adobe.forms.foundation.service.FormsAssetType;
import com.adobe.forms.foundation.service.FormsDependencyManager;
import com.adobe.granite.references.ReferenceProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={ReferenceProvider.class})
public class FormsReferenceProvider
implements ReferenceProvider {
    @Reference
    private FormsDependencyManager formsDependencyManager;
    private static final Logger logger = LoggerFactory.getLogger(FormsReferenceProvider.class);

    @Override
    public String getType() {
        return "formReferences";
    }

    @Override
    public List<com.adobe.granite.references.Reference> getReferences(Resource resource) {
        ArrayList<com.adobe.granite.references.Reference> references = new ArrayList<com.adobe.granite.references.Reference>();
        if (resource != null) {
            String resourceId = resource.getPath();
            try {
                ResourceResolver resourceResolver = resource.getResourceResolver();
                Map<FormsAssetType, Set<String>> parentDeps = this.formsDependencyManager.getImmediateParentDependencies(resourceId);
                for (FormsAssetType assetType : parentDeps.keySet()) {
                    Set<String> ids = parentDeps.get((Object)assetType);
                    for (String id : ids) {
                        references.add(new com.adobe.granite.references.Reference(resource, resourceResolver.getResource(id), this.getType()));
                    }
                }
            }
            catch (Exception e) {
                logger.error("Error in retrieving dependencies for the given resource : " + resourceId, e);
            }
        }
        return references;
    }

    protected void bindFormsDependencyManager(FormsDependencyManager formsDependencyManager) {
        this.formsDependencyManager = formsDependencyManager;
    }

    protected void unbindFormsDependencyManager(FormsDependencyManager formsDependencyManager) {
        if (this.formsDependencyManager == formsDependencyManager) {
            this.formsDependencyManager = null;
        }
    }
}

