/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.common.servlet;

import com.adobe.forms.common.service.FormsCommonConfigurationService;
import com.adobe.forms.common.service.FormsException;
import com.adobe.forms.common.utils.FormsConstants;
import com.adobe.forms.common.utils.TempStorageUtils;
import com.day.cq.commons.jcr.JcrUtil;
import java.io.IOException;
import java.net.URI;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"fd/af/components/guideContainer", "xfaforms/profile"}), @Property(name="sling.servlet.methods", value={"POST"}), @Property(name="service.description", value={"Adaptive Form UUID ACL Creator"}), @Property(name="sling.servlet.selectors", value={"fd.tempstorageprovider"})})
public class TempStorageProviderServlet
extends SlingAllMethodsServlet {
    private Logger logger = LoggerFactory.getLogger(TempStorageProviderServlet.class);
    @Reference
    private SlingRepository repository;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private FormsCommonConfigurationService formsCommonConfigurationService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String uuidPath = request.getParameter("uuidPath");
        if (uuidPath != null && uuidPath.length() > 0) {
            try {
                boolean isAnonymous;
                URI uuidURI = new URI(uuidPath);
                String uuidNormalizedPath = uuidURI.normalize().getPath();
                Session userSession = request.getResourceResolver().adaptTo(Session.class);
                Session serviceSession = this.repository.loginService(null, null);
                boolean bl = isAnonymous = request.getAuthType() == null;
                if (TempStorageUtils.isPreviewDisabled(this.formsCommonConfigurationService.getTempStorageConfig(), isAnonymous)) return;
                for (int i = 0; i < FormsConstants.FD_TEMP_PATHS.length; ++i) {
                    if (!uuidNormalizedPath.startsWith(FormsConstants.FD_TEMP_PATHS[i])) continue;
                    try {
                        String userFolder = uuidNormalizedPath.substring(uuidNormalizedPath.lastIndexOf(47) + 1);
                        Node userCreationTempNode = serviceSession.getNode(FormsConstants.FD_TEMP_PATHS[i]);
                        Node node = JcrUtil.createUniqueNode(userCreationTempNode, userFolder, "sling:Folder", serviceSession);
                        node.setProperty("tmpNode", true);
                        if (isAnonymous) {
                            node.setProperty("guideComponentType", "anonymousTempStorage");
                        }
                        serviceSession.save();
                        UserManager userManager = AccessControlUtil.getUserManager(userSession);
                        Authorizable authorizable = userManager.getAuthorizable(userSession.getUserID());
                        if (authorizable == null) continue;
                        AccessControlUtil.replaceAccessControlEntry(serviceSession, uuidNormalizedPath, authorizable.getPrincipal(), new String[]{"{http://www.jcp.org/jcr/1.0}read", "{http://www.jcp.org/jcr/1.0}modifyProperties", "{http://www.jcp.org/jcr/1.0}addChildNodes", "{http://www.jcp.org/jcr/1.0}nodeTypeManagement"}, new String[0], new String[0], null);
                        continue;
                    }
                    catch (Exception e) {
                        String errorMsg = "There was an error in uploading attachments";
                        this.logger.error(errorMsg, e);
                        response.setStatus(500);
                        response.getWriter().write(errorMsg);
                        throw new FormsException(errorMsg, e);
                    }
                    finally {
                        if (serviceSession != null) {
                            if (serviceSession.hasPendingChanges()) {
                                serviceSession.save();
                            }
                            serviceSession.logout();
                        }
                    }
                }
                return;
            }
            catch (Exception e) {
                String errorMsg = "There was an error in uploading attachments";
                this.logger.error(errorMsg + e.getMessage(), e);
                response.setStatus(500);
                response.getWriter().write(errorMsg);
                throw new FormsException(e);
            }
        } else {
            this.logger.debug("UUID path is null or its length is 0");
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindFormsCommonConfigurationService(FormsCommonConfigurationService formsCommonConfigurationService) {
        this.formsCommonConfigurationService = formsCommonConfigurationService;
    }

    protected void unbindFormsCommonConfigurationService(FormsCommonConfigurationService formsCommonConfigurationService) {
        if (this.formsCommonConfigurationService == formsCommonConfigurationService) {
            this.formsCommonConfigurationService = null;
        }
    }
}

