/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTSelectors;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.Tag;
import com.adobe.fontengine.font.type1.Type1Font;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.infontformatting.BaseFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.InFontFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.LookupsCache;

public final class GlyphFormatter
extends BaseFormatter {
    private static final int[] gposFeatures = new int[]{Tag.feature_mark, Tag.feature_mkmk};

    protected boolean canFormatOT() {
        return true;
    }

    protected int formatOT(OpenTypeFont otFont, AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        this.posFromAdvanceWidth(run, otFont, start, limit);
        if (otFont.gpos != null) {
            int scriptTag = GlyphFormatter.getOTScriptTag((Integer)run.getElementStyle(start, InFontFormatter.scriptAttribute));
            int langTag = GlyphFormatter.getOTLanguageTag((ULocale)run.getElementStyle(start, ElementAttribute.locale));
            int[][] gposLookups = LookupsCache.resolveFeatureTag(otFont.gpos, scriptTag, langTag, gposFeatures);
            limit = otFont.gpos.applyLookups(gposLookups[0], run, start, limit, OTSelectors.everywhere, otFont.gdef);
            limit = otFont.gpos.applyLookups(gposLookups[1], run, start, limit, OTSelectors.everywhere, otFont.gdef);
        } else if (shouldKern && otFont.kern != null) {
            this.applyKernTable(otFont, run, start, limit);
        }
        return limit;
    }

    protected boolean canFormatTT() {
        return true;
    }

    protected int formatTT(OpenTypeFont otFont, AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        this.posFromAdvanceWidth(run, otFont, start, limit);
        if (shouldKern && otFont.kern != null) {
            this.applyKernTable(otFont, run, start, limit);
        }
        return limit;
    }

    protected boolean canFormatT1() {
        return true;
    }

    protected int formatT1(Type1Font t1Font, AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        this.posFromAdvanceWidth(run, t1Font, start, limit);
        if (shouldKern) {
            for (int i = start; i < limit - 1; ++i) {
                double kernValue = t1Font.getKernValue(run.elementAt(i), run.elementAt(i + 1));
                run.adjustPlacementAndAdvance(i, 0.0, 0.0, kernValue, 0.0);
            }
        }
        return limit;
    }

    protected boolean canFormatGeneric() {
        return true;
    }

    protected int formatGeneric(FontData fontData, AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        this.posFromAdvanceWidth(run, fontData, start, limit);
        return limit;
    }
}

