/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.postscript.Reader;
import com.adobe.fontengine.font.postscript.Tokenizer;
import java.io.IOException;

final class AsciiEexecReader
implements Reader {
    private int hiNib = -1;
    private int cipherR = 55665;
    private int lastRead;
    private int secondToLastRead;
    private int lastCipher;

    AsciiEexecReader() {
    }

    public int read(FontInputStream stream) throws IOException, InvalidFontException {
        this.lastCipher = this.cipherR;
        this.secondToLastRead = stream.read();
        while (this.secondToLastRead != -1 && Tokenizer.digitValue((byte)this.secondToLastRead) > 15) {
            this.secondToLastRead = stream.read();
        }
        this.lastRead = stream.read();
        while (this.lastRead != -1 && Tokenizer.digitValue((byte)this.lastRead) > 15) {
            this.lastRead = stream.read();
        }
        if (this.secondToLastRead == -1 || this.lastRead == -1) {
            throw new InvalidFontException("unexpected end of file");
        }
        this.decryptByte((byte)this.secondToLastRead);
        return this.decryptByte((byte)this.lastRead);
    }

    public void unreadLast(FontInputStream stream) throws IOException {
        this.cipherR = this.lastCipher;
        stream.unread(this.lastRead);
        stream.unread(this.secondToLastRead);
    }

    public int decryptByte(byte inputByte) {
        if (this.hiNib == -1) {
            this.hiNib = Tokenizer.digitValue(inputByte);
            return -1;
        }
        byte cipher = (byte)(this.hiNib << 4 | Tokenizer.digitValue(inputByte));
        byte dst = (byte)(cipher ^ this.cipherR >> 8);
        this.cipherR = ((cipher & 0xFF) + this.cipherR) * 52845 + 22719 & 0xFFFF;
        this.hiNib = -1;
        return dst & 0xFF;
    }

    int decryptBuffer(byte[] buffer, int numBytesToDecrypt) {
        int dest = 0;
        for (int i = 0; i < numBytesToDecrypt; ++i) {
            int j;
            if (Tokenizer.digitValue(buffer[i]) > 15 || (j = this.decryptByte(buffer[i])) == -1) continue;
            buffer[dest++] = (byte)j;
        }
        return dest;
    }
}

