/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.GlyphBBoxCalculator;
import com.adobe.fontengine.font.GlyphBBoxOutlineConsumer;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.TTParser;
import com.adobe.fontengine.font.opentype.TTScaler;

public class TrueTypeGlyphBBoxCalculator
implements GlyphBBoxCalculator {
    private final boolean hinted;
    private final int scaling;

    TrueTypeGlyphBBoxCalculator(boolean hinted, int scaling) throws InvalidFontException, UnsupportedFontException {
        this.hinted = hinted;
        this.scaling = scaling;
    }

    public Rect calculateBBox(FontData font, int glyphID) throws InvalidFontException, UnsupportedFontException {
        GlyphBBoxOutlineConsumer consumer;
        if (this.hinted) {
            TTScaler hintedOutline = new TTScaler((OpenTypeFont)font, null);
            hintedOutline.setScale(this.scaling, this.scaling, this.scaling, 0.0, 0.0);
            consumer = new GlyphBBoxOutlineConsumer(Matrix.IDENTITY_MATRIX);
            consumer.reset();
            consumer.setMatrix(Matrix.IDENTITY_MATRIX);
            hintedOutline.getOutline(glyphID, consumer);
        } else {
            consumer = new GlyphBBoxOutlineConsumer(new Matrix(this.scaling, 0.0, 0.0, this.scaling, 0.0, 0.0));
            consumer.reset();
            TTParser unhintedOutline = new TTParser();
            unhintedOutline.parse((OpenTypeFont)font, glyphID, consumer);
        }
        return consumer.getBBox();
    }
}

