/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.opentype.OTSelector;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.InterElementAttribute;
import com.adobe.fontengine.inlineformatting.LigatureLevel;

public final class OTSelectorAtLigatureLevel
extends OTSelector {
    private final LigatureLevel level;

    public OTSelectorAtLigatureLevel(LigatureLevel level) {
        this.level = level;
    }

    public boolean isApplied(AttributedRun run, int position) {
        LigatureLevel allowedLigLevel = (LigatureLevel)run.getInterElementStyleBefore(position, InterElementAttribute.ligatureLevel);
        return LigatureLevel.lessThanOrEqual(this.level, allowedLigLevel);
    }

    public boolean isApplied(AttributedRun run, int from, int to) {
        for (int i = from + 1; i <= to; ++i) {
            LigatureLevel allowedLigLevel = (LigatureLevel)run.getInterElementStyleBefore(i, InterElementAttribute.ligatureLevel);
            if (LigatureLevel.lessThanOrEqual(this.level, allowedLigLevel)) continue;
            return false;
        }
        return true;
    }

    public boolean isApplied(AttributedRun run, int[] positions) {
        for (int i = positions[0] + 1; i <= positions[positions.length - 1]; ++i) {
            LigatureLevel allowedLigLevel = (LigatureLevel)run.getInterElementStyleBefore(i, InterElementAttribute.ligatureLevel);
            if (LigatureLevel.lessThanOrEqual(this.level, allowedLigLevel)) continue;
            return false;
        }
        return true;
    }
}

