/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.IntGrowableArray;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LookupTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class LookupTableHarvester {
    protected final int numGlyphs;
    final LookupTable lookupTable;

    LookupTableHarvester(LookupTable lookupTable, int numGlyphs) {
        this.lookupTable = lookupTable;
        this.numGlyphs = numGlyphs;
    }

    abstract List harvestSubtables(Subset var1, int var2, int var3, int var4, Map var5) throws InvalidFontException, UnsupportedFontException;

    protected IntGrowableArray getAllFeatureListFeatures() throws InvalidFontException {
        int featureListOffset = this.lookupTable.getFeatureListOffset();
        int featureCount = this.lookupTable.data.getuint16(featureListOffset);
        IntGrowableArray featuresInFeatureList = new IntGrowableArray();
        for (int f = 0; f < featureCount; ++f) {
            int featureOffset = featureListOffset + this.lookupTable.data.getuint16(featureListOffset + 2 + f * 6 + 4);
            int lookupCount = this.lookupTable.data.getuint16(featureOffset + 2);
            for (int l = 0; l < lookupCount; ++l) {
                featuresInFeatureList.set(this.lookupTable.data.getuint16(featureOffset + 4 + l * 2));
            }
        }
        Arrays.sort(featuresInFeatureList.getBuffer(), 0, featuresInFeatureList.getLength());
        return featuresInFeatureList;
    }

    protected void harvestAllFeatures(IntGrowableArray featuresInFeatureList, Map applicableLookups, Subset gids) throws InvalidFontException, UnsupportedFontException {
        if (featuresInFeatureList.getLength() > 0) {
            this.harvest(gids, featuresInFeatureList.getBuffer()[0], applicableLookups);
            for (int i = 1; i < featuresInFeatureList.getLength(); ++i) {
                if (featuresInFeatureList.get(i) == featuresInFeatureList.get(i - 1)) continue;
                this.harvest(gids, featuresInFeatureList.get(i), applicableLookups);
            }
        }
    }

    protected void harvest(Subset gids, int lookupIndex, Map lookups) throws InvalidFontException, UnsupportedFontException {
        int lookupFlag;
        int lookupType;
        int lookupListOffset = this.lookupTable.getLookupListOffset();
        int offset = this.lookupTable.data.getOffset(lookupListOffset, 2 + 2 * lookupIndex);
        List subtables = this.harvestSubtables(gids, offset, lookupType = this.lookupTable.data.getuint16(offset), lookupFlag = this.lookupTable.data.getuint16(offset + 2), lookups);
        if (subtables != null) {
            lookups.put(new Integer(lookupIndex), subtables);
        }
    }

    protected List gatherLookupsForCoverage(int stOffset, int coverageDelta, Subset gids, List subtables, CoverageLookupHarvester harvester, int subtable) throws InvalidFontException, UnsupportedFontException {
        CoverageHarvester coverageHarvester = new CoverageHarvester(stOffset, gids, subtables, harvester, subtable);
        this.lookupTable.iterateCoverage(this.lookupTable.data.getOffset(stOffset, coverageDelta), gids, coverageHarvester);
        return coverageHarvester.subtables;
    }

    protected List gatherLookupsForCoverageAllSubtables(Subset gids, int offset, CoverageLookupHarvester harvester) throws InvalidFontException, UnsupportedFontException {
        List subtables = null;
        int subtableCount = this.lookupTable.data.getuint16(offset + 4);
        for (int i = 0; i < subtableCount; ++i) {
            int stOffset = this.lookupTable.data.getOffset(offset, 6 + 2 * i);
            subtables = this.gatherLookupsForCoverage(stOffset, 2, gids, subtables, harvester, i);
        }
        return subtables;
    }

    protected class CoverageHarvester
    implements LayoutTable.CoverageConsumer {
        final int stOffset;
        final Subset gids;
        final CoverageLookupHarvester harvester;
        final int subtable;
        List subtables;

        CoverageHarvester(int stOffset, Subset gids, List subtables, CoverageLookupHarvester harvester, int subtable) {
            this.stOffset = stOffset;
            this.gids = gids;
            this.subtables = subtables;
            this.harvester = harvester;
            this.subtable = subtable;
        }

        public boolean glyphInfo(int gid, int coverageIndex) throws InvalidFontException, UnsupportedFontException {
            if (this.harvester.lookupApplies(gid, this.stOffset, coverageIndex, this.gids)) {
                Integer i;
                if (this.subtables == null) {
                    this.subtables = new ArrayList();
                }
                if (!this.subtables.contains(i = new Integer(this.subtable))) {
                    this.subtables.add(i);
                }
                return this.harvester.keepGoing();
            }
            return true;
        }
    }

    protected static interface CoverageLookupHarvester {
        public boolean lookupApplies(int var1, int var2, int var3, Subset var4) throws InvalidFontException, UnsupportedFontException;

        public boolean keepGoing();
    }
}

