/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.LookupTableHarvester;
import java.util.Map;

class ChainingFormat1Harvester
implements LookupTableHarvester.CoverageLookupHarvester {
    private final LookupTableHarvester harvester;
    private Map lookups;
    private final boolean continueIterating;

    ChainingFormat1Harvester(LookupTableHarvester harvester, Map lookups, boolean continueIteratingWhenLookupApplies) {
        this.harvester = harvester;
        this.lookups = lookups;
        this.continueIterating = continueIteratingWhenLookupApplies;
    }

    public boolean keepGoing() {
        return this.continueIterating;
    }

    private boolean glyphsApply(int numGlyphs, int chainSubruleOffset, int delta, Subset gids) throws InvalidFontException, UnsupportedFontException {
        for (int j = 0; j < numGlyphs; ++j) {
            int gid = this.harvester.lookupTable.data.getuint16(chainSubruleOffset + delta + 2 + 2 * j);
            if (gids.getExistingSubsetGid(gid) != -1) continue;
            return false;
        }
        return true;
    }

    public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) throws InvalidFontException, UnsupportedFontException {
        int chainSubruleSetOffset = this.harvester.lookupTable.data.getOffset(stOffset, 6 + 2 * coverageIndex);
        int chainSubruleCount = this.harvester.lookupTable.data.getuint16(chainSubruleSetOffset);
        boolean applies = false;
        for (int i = 0; i < chainSubruleCount; ++i) {
            int lookaheadCount;
            int delta;
            int glyphCount;
            int chainSubruleOffset = this.harvester.lookupTable.data.getOffset(chainSubruleSetOffset, 2 + 2 * i);
            int backtrackCount = this.harvester.lookupTable.data.getuint16(chainSubruleOffset);
            if (!this.glyphsApply(backtrackCount, chainSubruleOffset, 0, gids) || !this.glyphsApply(glyphCount = this.harvester.lookupTable.data.getuint16(chainSubruleOffset + (delta = 2 + 2 * backtrackCount)) - 1, chainSubruleOffset, delta, gids) || !this.glyphsApply(lookaheadCount = this.harvester.lookupTable.data.getuint16(chainSubruleOffset + (delta += 2 + 2 * glyphCount)), chainSubruleOffset, delta, gids)) continue;
            int lookupCount = this.harvester.lookupTable.data.getuint16(chainSubruleOffset + (delta += 2 + 2 * lookaheadCount));
            for (int j = 0; j < lookupCount; ++j) {
                int lookupIndex = this.harvester.lookupTable.data.getuint16(chainSubruleOffset + delta + 2 + 4 * j + 2);
                this.harvester.harvest(gids, lookupIndex, this.lookups);
            }
            applies = true;
        }
        return applies;
    }
}

