/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.templates.api;

import com.adobe.cq.social.commons.Attachment;
import com.adobe.cq.social.communityfunctions.api.CommunityFunction;
import com.adobe.cq.social.console.utils.AttachmentUtils;
import com.adobe.cq.social.console.utils.ConsoleUtils;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.cq.social.templates.api.CommunityTemplate;
import com.adobe.cq.social.templates.api.FunctionDefinition;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommunityTemplateImpl
extends BaseSocialComponent
implements CommunityTemplate {
    protected final Resource resource;
    protected final ValueMap properties;
    private LinkedList<FunctionDefinition> functionDefinitions;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCommunityTemplateImpl.class);
    private static final String COMMUNITY_IMAGE_WIDTH = "302";
    private static final String COMMUNITY_IMAGE_HEIGHT = "222";
    private static final String COMMUNITY_IMAGE_THUMB_OPERATOR = "thumb";
    private static final String COMMUNITY_IMAGE_EXTENSION = ".png";

    public AbstractCommunityTemplateImpl(Resource resource, ClientUtilities clientUtilities) {
        super(resource, clientUtilities);
        this.resource = resource;
        this.properties = this.resource.adaptTo(ValueMap.class);
    }

    @Override
    public String getTitle() {
        return this.properties == null ? "" : this.properties.get("jcr:title", "");
    }

    @Override
    public String getSitePath() {
        return this.properties == null ? "" : this.properties.get("sitePath", "");
    }

    public boolean hasImage() {
        ResourceResolver resourceResolver = this.resource.getResourceResolver();
        Resource imageResource = resourceResolver.getResource(this.resource.getPath() + "/" + "image");
        return imageResource != null;
    }

    @Override
    public String getImage() {
        String imagePath = "";
        String imageUrl = "";
        imagePath = this.hasImage() ? this.resource.getPath() + "/" + "image" : "/content/communities/templates/functions/page";
        imageUrl = this.clientUtils.externalLink(imagePath + "." + COMMUNITY_IMAGE_THUMB_OPERATOR + "." + COMMUNITY_IMAGE_HEIGHT + "." + COMMUNITY_IMAGE_WIDTH + "." + System.currentTimeMillis() + COMMUNITY_IMAGE_EXTENSION, false);
        return imageUrl;
    }

    @Override
    public String getDescription() {
        return this.properties == null ? "" : this.properties.get("jcr:description", "");
    }

    @Override
    public boolean isDisabled() {
        return this.properties.get("isDisabled", false);
    }

    @Override
    public LinkedList<FunctionDefinition> getStructure() {
        if (this.functionDefinitions != null) {
            return this.functionDefinitions;
        }
        Resource functions = this.resource.getChild("functions");
        if (functions == null) {
            return null;
        }
        this.functionDefinitions = new LinkedList();
        QueryRequestInfo dummyRequestInfo = QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create();
        for (final Resource function : functions.getChildren()) {
            ValueMap functionDef = function.getValueMap();
            final String url = functionDef.get("url", "");
            final String title = functionDef.get("title", "");
            String functionMetaPath = functionDef.get("function", "");
            Resource functionMeta = this.resource.getResourceResolver().getResource(functionMetaPath);
            SocialComponentFactory commFuncFactory = this.clientUtils.getSocialComponentFactoryManager().getSocialComponentFactory(functionMeta);
            final CommunityFunction commFunction = (CommunityFunction)commFuncFactory.getSocialComponent(functionMeta, this.clientUtils, dummyRequestInfo);
            FunctionDefinition funDef = new FunctionDefinition(){

                @Override
                public String getUrl() {
                    return StringUtils.isEmpty(url) ? function.getName() : url;
                }

                @Override
                public String getTitle() {
                    return StringUtils.isEmpty(title) ? commFunction.getTitle() : title;
                }

                @Override
                public CommunityFunction getFunction() {
                    return commFunction;
                }

                @Override
                public Map<String, Object> getConfiguration() {
                    Resource config = function.getChild("configuration");
                    if (config == null) {
                        return Collections.emptyMap();
                    }
                    ValueMap configValueMap = config.getValueMap();
                    HashMap<String, Object> configMap = new HashMap<String, Object>(4);
                    for (String configId : configValueMap.keySet()) {
                        if (StringUtils.startsWith(configId, "jcr:")) continue;
                        configMap.put(configId, configValueMap.get(configId));
                    }
                    return configMap;
                }

                @Override
                public Resource getResource() {
                    return function;
                }
            };
            this.functionDefinitions.add(funDef);
        }
        return this.functionDefinitions;
    }

    @Override
    public Attachment getImageAttachment() {
        return this.hasImage() ? AttachmentUtils.getAttachment((Resource)this.resource.getChild("image"), (ClientUtilities)this.clientUtils) : null;
    }

    @Override
    public boolean isNew() {
        Calendar created = (Calendar)((Object)this.properties.get("jcr:created", Calendar.class));
        Calendar modified = (Calendar)((Object)this.properties.get("jcr:lastModified", Calendar.class));
        if (modified == null) {
            modified = created;
        }
        return ConsoleUtils.isNew((Calendar)created, (Calendar)modified);
    }
}

