/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.tally.client.api;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.tally.Voting;
import com.adobe.cq.social.tally.client.api.AbstractTally;
import com.adobe.cq.social.tally.client.api.Response;
import com.adobe.cq.social.tally.client.api.TallyException;
import com.adobe.cq.social.tally.client.api.Vote;
import com.adobe.cq.social.tally.client.api.VotingSocialComponent;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;

public class AbstractVoting
extends AbstractTally
implements VotingSocialComponent {
    private Voting votingComponent;

    public AbstractVoting(Resource resource) {
        this(resource, null);
    }

    public AbstractVoting(Resource resource, ClientUtilities clientUtils) {
        super(resource, clientUtils);
        this.initComponent();
    }

    private void initComponent() {
        this.votingComponent = this.getResource().adaptTo(Voting.class);
        this.tally = this.votingComponent;
    }

    @Override
    public long getNetCount() {
        return this.votingComponent.getPositiveCount() - this.votingComponent.getNegativeCount();
    }

    @Override
    public long getPositiveCount() {
        return this.votingComponent.getPositiveCount();
    }

    @Override
    public long getNegativeCount() {
        return this.votingComponent.getNegativeCount();
    }

    @Override
    public String getPositiveLabel() {
        return this.votingComponent.getPositiveLabel();
    }

    @Override
    public String getNegativeLabel() {
        return this.votingComponent.getNegativeLabel();
    }

    @Override
    public boolean isCurrentUserLike() {
        try {
            if (this.clientUtils.userIsAnonymous()) {
                return false;
            }
            Response resp = this.votingComponent.getUserResponse(this.currentUser);
            if (resp == null) {
                return false;
            }
            return Vote.LIKE.equals(resp.getResponseValue());
        }
        catch (RepositoryException e) {
            return false;
        }
        catch (TallyException e) {
            return false;
        }
    }
}

