/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.srp;

import com.adobe.cq.social.srp.SocialResourceProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Callable;

public class SocialResourcePrefetch {
    private static ThreadLocal<Deque<SocialResourceProvider.PrefetchPerResult>> stackThreadLocal = new ThreadLocal();

    private static Deque<SocialResourceProvider.PrefetchPerResult> getStack() {
        Deque<SocialResourceProvider.PrefetchPerResult> stack = stackThreadLocal.get();
        if (stack == null) {
            stack = new LinkedList<SocialResourceProvider.PrefetchPerResult>();
            stackThreadLocal.set(stack);
        }
        return stack;
    }

    public static <T> T call(SocialResourceProvider.PrefetchPerResult prefetch, Callable<T> call) throws InvocationTargetException {
        boolean pushed = false;
        Deque<SocialResourceProvider.PrefetchPerResult> stack = SocialResourcePrefetch.getStack();
        try {
            stack.push(prefetch);
            pushed = true;
            T t = call.call();
            return t;
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        finally {
            if (pushed) {
                stack.pop();
            }
            if (stack.size() == 0) {
                stackThreadLocal.remove();
            }
        }
    }

    public static void call(SocialResourceProvider.PrefetchPerResult prefetch, final Runnable runnable) throws InvocationTargetException {
        SocialResourcePrefetch.call(prefetch, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                runnable.run();
                return Void.TYPE.newInstance();
            }
        });
    }

    public static Iterator<SocialResourceProvider.PrefetchPerResult> getPrefetches() {
        return SocialResourcePrefetch.getStack().iterator();
    }
}

