/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.site.api;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;
import com.adobe.cq.social.scf.core.BaseQueryRequestInfo;
import com.adobe.cq.social.site.impl.CommunitySiteCollectionImpl;
import com.adobe.cq.social.user.internal.HttpToPublisher;
import com.adobe.cq.social.user.internal.TunnelValidator;
import com.adobe.cq.social.user.internal.validator.CommunityAdminTunnelValidator;
import java.util.HashMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class PublishedCommunitySiteCollectionComponentFactory
extends AbstractSocialComponentFactory
implements SocialComponentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PublishedCommunitySiteCollectionComponentFactory.class);
    @Reference
    private HttpToPublisher httpPublish;

    @Override
    public SocialComponent getSocialComponent(Resource resource) {
        if (this.httpPublish.isAuthorMode()) {
            if (!this.httpPublish.isEnabled()) {
                LOG.error("Tunnel service is not enabled.");
                return null;
            }
            BaseQueryRequestInfo defaultRequestInfo = new BaseQueryRequestInfo(false, new HashMap<String, String[]>(), CollectionPagination.DEFAULT_PAGINATION);
            return this.getFromPublisher(resource, defaultRequestInfo);
        }
        return new CommunitySiteCollectionImpl(resource, this.getClientUtilities(resource.getResourceResolver()));
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest req) {
        if (this.httpPublish.isAuthorMode()) {
            if (!this.httpPublish.isEnabled()) {
                LOG.error("Tunnel service is not enabled.");
                return null;
            }
            return this.getFromPublisher(resource, new BaseQueryRequestInfo(req, false));
        }
        return new CommunitySiteCollectionImpl(resource, this.getClientUtilities(req));
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, ClientUtilities c, QueryRequestInfo q) {
        if (this.httpPublish.isAuthorMode()) {
            if (!this.httpPublish.isEnabled()) {
                LOG.error("Tunnel service is not enabled.");
                return null;
            }
            return this.getFromPublisher(resource, q);
        }
        return new CommunitySiteCollectionImpl(resource, c, q.getPagination(), q.getSortOrder());
    }

    private SocialComponent getFromPublisher(Resource resource, QueryRequestInfo requestInfo) {
        return this.httpPublish.getFromPublisher(resource, requestInfo, resource.getResourceResolver(), (TunnelValidator)new CommunityAdminTunnelValidator());
    }

    @Override
    public String getSupportedResourceType() {
        return "social/console/components/hbs/publishedsitecollection";
    }

    protected void bindHttpPublish(HttpToPublisher httpToPublisher) {
        this.httpPublish = httpToPublisher;
    }

    protected void unbindHttpPublish(HttpToPublisher httpToPublisher) {
        if (this.httpPublish == httpToPublisher) {
            this.httpPublish = null;
        }
    }
}

