/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.reporting.dv.api;

import com.adobe.cq.social.reporting.dv.model.api.DonutChartData;
import com.adobe.cq.social.reporting.dv.model.api.DonutChartLabels;
import com.adobe.cq.social.reporting.dv.model.api.DonutChartModel;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import java.util.ArrayList;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;

public abstract class AbstractDVDonutChartComponent
extends BaseSocialComponent {
    protected DonutChartModel responseObject = new DonutChartModel(null, null);

    protected AbstractDVDonutChartComponent(Resource resource, ClientUtilities clientUtils) {
        super(resource, clientUtils);
    }

    protected void postProcessDV(JSONArray result, int maxSegments) throws JSONException {
        int totalCount = result.getJSONObject(maxSegments).getInt("count");
        if (totalCount == 0) {
            return;
        }
        ArrayList<Long> x = new ArrayList<Long>();
        ArrayList<Long> y = new ArrayList<Long>();
        ArrayList<String> category1 = new ArrayList<String>();
        ArrayList<Long> x2 = new ArrayList<Long>();
        ArrayList<Long> y2 = new ArrayList<Long>();
        ArrayList<String> percentLabels = new ArrayList<String>();
        ArrayList<String> category2 = new ArrayList<String>();
        int percentSum = 100;
        for (int i = 0; i < maxSegments; ++i) {
            int count = result.getJSONObject(i).getInt("count");
            long percent = Math.round((double)count * 100.0 / (double)totalCount);
            x.add(1L);
            if (count > 0) {
                category1.add(0, result.getJSONObject(i).getString("description"));
                category2.add(0, result.getJSONObject(i).getString("description"));
                y.add(0, Long.valueOf(count));
                x2.add(2L);
                y2.add(0, (long)percentSum - percent / 2L);
                percentLabels.add(0, percent + "%");
            } else {
                category1.add(result.getJSONObject(i).getString("description"));
                y.add(Long.valueOf(count));
            }
            percentSum = (int)((long)percentSum - percent);
        }
        DonutChartData dData = new DonutChartData(x, y, category1);
        DonutChartLabels dLabels = new DonutChartLabels(x2, y2, category2, percentLabels, totalCount);
        this.responseObject = new DonutChartModel(dData, dLabels);
    }

    public DonutChartData getData() {
        return this.responseObject == null ? null : this.responseObject.getData();
    }

    public DonutChartLabels getLabels() {
        return this.responseObject == null ? null : this.responseObject.getLabels();
    }

    @Override
    protected List<String> getIgnoredProperties() {
        this.ignoredProperties.add("jcr:.*");
        return this.ignoredProperties;
    }
}

