/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.forum.client.api;

import com.adobe.cq.social.forum.client.api.Forum;
import com.adobe.cq.social.forum.client.api.Post;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.SocialEvent;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.event.Event;

public final class ForumEvent
extends SocialEvent<Type>
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String PROP_EVENT_TYPE = "EventType";
    private static final String PROP_EVENT_PATH = "EventPath";
    private static final String PROP_FORUM_PATH = "ForumPath";
    public static final String FORUM_TOPIC = "forum";
    private static final String MENTIONS = "mentions";
    public static final String EVENT_TOPIC = "com/adobe/cq/social/forum";
    @Deprecated
    public static final String COLLAB_EVENT_TOPIC = "com/day/cq/collab/forum";
    protected static final String PROP_TOPIC_PATH = "TopicPath";

    private static Map<String, Object> getPropertiesMap(Dictionary<String, Object> properties) {
        HashMap<String, Object> additionalProps = new HashMap<String, Object>(properties.size());
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (PROP_EVENT_PATH.equals(key) || PROP_EVENT_TYPE.equals(key) || "userId".equals(key)) continue;
            additionalProps.put(key, properties.get(key));
        }
        return additionalProps;
    }

    private ForumEvent(Event event) {
        super(event);
    }

    public ForumEvent(Post post, String user, Type action) {
        super(FORUM_TOPIC, post.getResource().getPath(), user, action, post.isTopic() ? ForumEvent.buildTopicProperties(post, action) : ForumEvent.buildPostProperties(post, action));
    }

    private static Map<String, Object> buildTopicProperties(final Post post, Type action) {
        if (action.getVerb().equals("delete")) {
            return new HashMap<String, Object>(2){
                private static final long serialVersionUID = 1L;
                {
                    super(x0);
                    this.put(SocialEvent.OBJECT, new SocialEvent.BaseEventObject("a topic", post.getResource().getPath(), "comment"));
                    this.put(SocialEvent.TARGET, new SocialEvent.BaseEventObject(ForumEvent.getDisplayName(post.getParentComponent()), post.getForumId(), "collection"));
                }
            };
        }
        return new HashMap<String, Object>(3){
            private static final long serialVersionUID = 1L;
            {
                super(x0);
                this.put(SocialEvent.OBJECT, new SocialEvent.BaseEventObject(ForumEvent.getDisplayName(post), post.getResource().getPath(), "comment"));
                this.put(SocialEvent.TARGET, new SocialEvent.BaseEventObject(ForumEvent.getDisplayName(post.getParentComponent()), post.getForumId(), "collection"));
                if (post.getProperties().get(ForumEvent.MENTIONS) != null) {
                    this.put(ForumEvent.MENTIONS, post.getProperties().get(ForumEvent.MENTIONS));
                }
            }
        };
    }

    private static Map<String, Object> buildPostProperties(final Post post, final Type action) {
        return new HashMap<String, Object>(2){
            private static final long serialVersionUID = 1L;
            {
                super(x0);
                this.put(SocialEvent.OBJECT, new SocialEvent.BaseEventObject(action.getVerb().equals("delete") ? "a post" : ForumEvent.getDisplayName(post), post.getResource().getPath(), "comment"));
                SocialComponent parent = post.getParentComponent();
                this.put(SocialEvent.TARGET, new SocialEvent.BaseEventObject(ForumEvent.getDisplayName(parent), parent.getResource().getPath(), "collection"));
                if (post.getProperties().get(ForumEvent.MENTIONS) != null) {
                    this.put(ForumEvent.MENTIONS, post.getProperties().get(ForumEvent.MENTIONS));
                }
            }
        };
    }

    private static String getDisplayName(SocialComponent post) {
        if (post instanceof Post) {
            String name = ((Post)post).getSubject();
            if (StringUtils.isNotEmpty(name)) {
                return name;
            }
            return ((Post)post).isTopic() ? "a topic" : "a post";
        }
        if (post instanceof Forum) {
            return ((Forum)post).getTitle();
        }
        return null;
    }

    protected static String getUserId(String userId) {
        if (StringUtils.isNotEmpty(userId) && userId.startsWith("/social/authors/")) {
            return userId.substring("/social/authors/".length());
        }
        return userId;
    }

    public static enum Type implements SocialEvent.SocialActions
    {
        TopicAdded,
        PostAdded,
        PostApproved,
        TopicEdited,
        PostEdited,
        TopicDeleted,
        PostDeleted;

        private static final Set<String> FORUM_ACTIONS;

        @Override
        public String getVerb() {
            switch (this) {
                case TopicAdded: {
                    return "post";
                }
                case PostAdded: {
                    return "add";
                }
                case PostApproved: {
                    return "approve";
                }
                case TopicEdited: 
                case PostEdited: {
                    return "update";
                }
                case TopicDeleted: 
                case PostDeleted: {
                    return "delete";
                }
            }
            throw new IllegalArgumentException();
        }

        static {
            FORUM_ACTIONS = new HashSet<String>();
            for (Type action : Type.values()) {
                FORUM_ACTIONS.add("forum." + action.getVerb());
            }
        }
    }
}

