/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.comments.endpoints;

import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.commons.CommentException;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.day.cq.commons.Externalizer;
import com.day.image.Layer;
import com.day.text.Text;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadOperationUtils {
    private static String UGC_ROOT_DIR = "/content/usergenerated";
    private static String TEMP_ROOT_DIR = "tmp";
    private static String SOCIAL_DIR = "social";
    private static String[] SKIP_DIRS = new String[]{"jcr:content"};
    private static String IMAGES_DIR = "images";
    private static String TEMP_DIR = UGC_ROOT_DIR + "/" + TEMP_ROOT_DIR + "/" + SOCIAL_DIR + "/" + IMAGES_DIR;
    private static final Logger LOG = LoggerFactory.getLogger(UploadOperationUtils.class);
    private static final Pattern IMG_SRC_PATTERN = Pattern.compile("(<img [^<>]*?src=\")(.+?)(\"[^<>]*?>)");
    private static final Pattern IMG_WIDTH_PATTERN = Pattern.compile("(<img [^<>]*?width=\")(.+?)(\"[^<>]*?>)");
    private static final Pattern IMG_HEIGHT_PATTERN = Pattern.compile("(<img [^<>]*?height=\")(.+?)(\"[^<>]*?>)");
    private static final Pattern ANCHOR_HREF_PATTERN = Pattern.compile("(<a [^<>]*?href=\")(.+?)(\"[^<>]*?>)(<img [^<>]*?src=\")(.+?)(\"[^<>]*?>)");
    private static final String THUMBNAIL_PREFIX = "rendition_";
    private static final String RENDITION_SRC_PREFIX = "/content/usergenerated/asi/";
    private static final String ACTUAL_IMAGE_PREFIX = "original_";
    private static final String INLINE_IMAGE_PREFIX = ":";

    public static Node addAttachment(Node root, String name, InputStream inputStream, String mimeType) throws RepositoryException {
        Node contentNode;
        Node attachmentNode;
        String fileName = FilenameUtils.getName(name);
        if (root.hasNode(fileName)) {
            attachmentNode = root.getNode(fileName);
            contentNode = attachmentNode.getNode("jcr:content");
        } else {
            attachmentNode = root.addNode(fileName, "nt:file");
            contentNode = attachmentNode.addNode("jcr:content", "nt:resource");
        }
        contentNode.setProperty("jcr:mimeType", mimeType);
        contentNode.setProperty("jcr:data", inputStream);
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        return attachmentNode;
    }

    public static Node createOrGetUploadResource(Session session, String path) throws PathNotFoundException, RepositoryException {
        Node ugc = session.getNode(UGC_ROOT_DIR);
        if (ugc != null) {
            int i;
            Node tmp = JcrUtils.getOrAddFolder(ugc, TEMP_ROOT_DIR);
            String[] folders = path.split("/");
            Node parent = JcrUtils.getOrAddFolder(tmp, SOCIAL_DIR);
            parent = JcrUtils.getOrAddFolder(parent, IMAGES_DIR);
            int n = i = path.startsWith("/") ? 0 : 1;
            while (i < folders.length) {
                if (!UploadOperationUtils.skipFolder(folders[i])) {
                    parent = JcrUtils.getOrAddFolder(parent, folders[i]);
                }
                ++i;
            }
            return parent;
        }
        return null;
    }

    public static void moveImages(Externalizer externalizer, boolean author, SocialUtils socialUtils, com.adobe.cq.social.commons.comments.api.Comment comment) throws PersistenceException {
        UploadOperationUtils.moveImages(null, externalizer, author, socialUtils, comment);
    }

    public static void moveImages(String contextPath, Externalizer externalizer, boolean author, SocialUtils socialUtils, com.adobe.cq.social.commons.comments.api.Comment comment) throws PersistenceException {
        String message = comment.getMessage();
        Resource resource = comment.getResource();
        Comment ocomment = resource.adaptTo(Comment.class);
        ResourceResolver resolver = comment.getResource().getResourceResolver();
        boolean updated = false;
        Matcher imgMatcher = IMG_SRC_PATTERN.matcher(message);
        StringBuffer updatedMessage = new StringBuffer();
        while (imgMatcher.find()) {
            String startTag = imgMatcher.group(1);
            LOG.debug("Move Images - Image Matcher - start tag - " + startTag);
            String imgUrl = imgMatcher.group(2);
            LOG.debug("Move Images - Image Matcher - img URL - " + imgUrl);
            String endTag = imgMatcher.group(3);
            LOG.debug("Move Images - Image Matcher - end Tag - " + endTag);
            String externalUrl = null;
            if (imgUrl.startsWith(TEMP_DIR)) {
                String name = FilenameUtils.getName(imgUrl);
                Resource imgResource = resolver.getResource(imgUrl);
                if (imgResource != null && imgResource.hasChildren()) {
                    imgResource = imgResource.getChild("jcr:content");
                }
                if (imgResource != null) {
                    InputStream inputStream = imgResource.adaptTo(InputStream.class);
                    ValueMap valueMap = imgResource.adaptTo(ValueMap.class);
                    String mimeType = (String)((Object)valueMap.get("jcr:mimeType", String.class));
                    Resource image = ocomment.addImage(name, inputStream, mimeType);
                    externalUrl = UploadOperationUtils.externalizeLink(contextPath, externalizer, author, resolver, image.getPath());
                    LOG.debug("Move Images - external url - " + externalUrl);
                }
            }
            if (externalUrl == null) continue;
            imgMatcher.appendReplacement(updatedMessage, Matcher.quoteReplacement(startTag + externalUrl + endTag));
            LOG.debug("Move Images - updated message after tag replacement - " + updatedMessage.toString());
            updated = true;
        }
        imgMatcher.appendTail(updatedMessage);
        LOG.debug("Move Images - Final Updated message - " + updatedMessage.toString());
        if (updated) {
            ModifiableValueMap mvm = resource.adaptTo(ModifiableValueMap.class);
            mvm.put("jcr:description", updatedMessage.toString());
            resolver.commit();
        }
    }

    public static void moveImages(ClientUtilities clientUtils, com.adobe.cq.social.commons.comments.api.Comment comment, ResourceResolver serviceUserResolver) throws PersistenceException {
        UploadOperationUtils.moveImages(clientUtils, comment, serviceUserResolver, null);
    }

    public static void moveImages(ClientUtilities clientUtils, com.adobe.cq.social.commons.comments.api.Comment comment, ResourceResolver serviceUserResolver, String contextPath) throws PersistenceException {
        String message = comment.getMessage();
        String commentPath = comment.getResource().getPath();
        Resource resource = serviceUserResolver.getResource(commentPath);
        Comment ocomment = resource.adaptTo(Comment.class);
        int thumbNailSize = comment.getConfiguration().getThumbNailSize();
        long imgMinSizeForThumbNail = comment.getConfiguration().getMinimumImgSizeForThumbnail();
        SocialUtils socialUtils = clientUtils.getSocialUtils();
        HashSet<String> deletedResources = new HashSet<String>();
        Matcher imgMatcher = IMG_SRC_PATTERN.matcher(message);
        Matcher heightMatcher = null;
        Matcher widthMatcher = null;
        StringBuffer updatedMessage = new StringBuffer();
        ArrayList<String> inlineImagesToBeUpdated = new ArrayList<String>();
        Long imageSize = null;
        int endIndexOfPreviousMatch = 0;
        try {
            while (imgMatcher.find()) {
                boolean generateThumbnailImage;
                heightMatcher = IMG_HEIGHT_PATTERN.matcher(imgMatcher.group());
                widthMatcher = IMG_WIDTH_PATTERN.matcher(imgMatcher.group());
                String startTag = UploadOperationUtils.getStartTag(imgMatcher);
                LOG.debug("Move Images - Image Matcher - start tag - " + startTag);
                String imgUrl = UploadOperationUtils.getImgUrl(imgMatcher);
                LOG.debug("Move Images - Image Matcher - imgUrl - " + imgUrl);
                String endTag = UploadOperationUtils.getEndTag(imgMatcher);
                LOG.debug("Move Images - Image Matcher - endTag - " + endTag);
                ThumbnailConfig config = new ThumbnailConfig(thumbNailSize, thumbNailSize, false);
                int imageHeight = UploadOperationUtils.getImageAttributeValue(heightMatcher);
                int imageWidth = UploadOperationUtils.getImageAttributeValue(widthMatcher);
                if (imageWidth < config.getWidth() && imageHeight < config.getHeight()) {
                    config.setHeight(imageHeight);
                    config.setWidth(imageWidth);
                }
                imgUrl = Text.unescape(imgUrl);
                String externalUrl = null;
                String renditionUrl = null;
                if (imgUrl.startsWith(contextPath)) {
                    imgUrl = imgUrl.substring(contextPath.length());
                }
                String imageName = FilenameUtils.getName(imgUrl);
                inlineImagesToBeUpdated.add(imageName);
                InputStream renditionInputStream = null;
                String mimeType = null;
                Resource imgResource = serviceUserResolver.getResource(imgUrl);
                if (imgResource == null) {
                    LOG.debug("Empty image resource, hence not moving " + imgUrl);
                    continue;
                }
                Resource targetResource = imgResource;
                if (imgUrl.startsWith(TEMP_DIR)) {
                    if (imgResource.hasChildren()) {
                        targetResource = imgResource.getChild("jcr:content");
                    }
                    InputStream inputStream = targetResource.adaptTo(InputStream.class);
                    ValueMap valueMap = targetResource.adaptTo(ValueMap.class);
                    imageSize = (Long)((Object)valueMap.get("jcr:data", Long.class));
                    mimeType = (String)((Object)valueMap.get("jcr:mimeType", String.class));
                    externalUrl = UploadOperationUtils.uploadImageToSRP(clientUtils, contextPath, ocomment, ACTUAL_IMAGE_PREFIX + imageName, inputStream, mimeType);
                    deletedResources.add(imgResource.getPath());
                    LOG.debug("Deleting temp image " + imgResource.getPath());
                } else {
                    ValueMap valueMap = targetResource.adaptTo(ValueMap.class);
                    imageSize = (Long)((Object)valueMap.get("length", Long.class));
                    mimeType = (String)((Object)valueMap.get("mimetype", String.class));
                    externalUrl = UploadOperationUtils.generateImageUrl(clientUtils, contextPath, targetResource);
                }
                boolean bl = imageSize != null ? imageSize > imgMinSizeForThumbNail : (generateThumbnailImage = true);
                if (generateThumbnailImage) {
                    InputStream imgResourceInputStream = targetResource.adaptTo(InputStream.class);
                    renditionInputStream = UploadOperationUtils.generateRenditionImage(imgResourceInputStream, mimeType, config);
                    renditionUrl = UploadOperationUtils.uploadImageToSRP(clientUtils, contextPath, ocomment, THUMBNAIL_PREFIX + imageName, renditionInputStream, mimeType);
                } else {
                    LOG.debug("Image size is less then threshold so rendition not needed");
                }
                int currentMatchEndtIndex = imgMatcher.end();
                String messageSubString = message.substring(endIndexOfPreviousMatch, currentMatchEndtIndex);
                endIndexOfPreviousMatch = currentMatchEndtIndex;
                if (externalUrl != null) {
                    if (renditionUrl != null) {
                        Matcher anchorHrefMatcher = ANCHOR_HREF_PATTERN.matcher(messageSubString);
                        if (anchorHrefMatcher.find()) {
                            boolean isRenditionATag = anchorHrefMatcher.group(2).startsWith(RENDITION_SRC_PREFIX);
                            if (!isRenditionATag) {
                                LOG.debug("Image with linked url " + anchorHrefMatcher.group(2));
                                String resultUrl = UploadOperationUtils.updateImgProps(imgMatcher, imageWidth, imageHeight, config, externalUrl);
                                imgMatcher.appendReplacement(updatedMessage, Matcher.quoteReplacement(resultUrl));
                                continue;
                            }
                            LOG.debug("Image is linked with Rendition URL");
                            continue;
                        }
                        String resultUrl = UploadOperationUtils.createThumbnailURL(imgMatcher, imageWidth, imageHeight, config, externalUrl, renditionUrl);
                        imgMatcher.appendReplacement(updatedMessage, Matcher.quoteReplacement(resultUrl));
                        LOG.debug("Matched Images updated - " + updatedMessage.toString());
                        continue;
                    }
                    imgMatcher.appendReplacement(updatedMessage, Matcher.quoteReplacement(startTag + externalUrl + endTag));
                    LOG.debug("Move Images updated message post replacement - " + updatedMessage.toString());
                    continue;
                }
                imgMatcher.appendReplacement(updatedMessage, "");
            }
        }
        catch (IllegalStateException e) {
            LOG.error("exception occured while uploading images", e);
            updatedMessage = new StringBuffer();
            Matcher deleteImgMatcher = IMG_SRC_PATTERN.matcher(message);
            while (deleteImgMatcher.find()) {
                String imgUrl = UploadOperationUtils.getImgUrl(deleteImgMatcher);
                Resource imgResource = serviceUserResolver.getResource(imgUrl);
                if (imgResource == null) {
                    LOG.debug("Empty image resource, hence not moving " + imgUrl);
                    continue;
                }
                if (!imgUrl.startsWith(TEMP_DIR)) continue;
                deletedResources.add(imgResource.getPath());
                deleteImgMatcher.appendReplacement(updatedMessage, "");
            }
            imgMatcher = deleteImgMatcher;
        }
        boolean areImagesRemoved = UploadOperationUtils.removeInlineImages(inlineImagesToBeUpdated, resource, socialUtils, ocomment);
        imgMatcher.appendTail(updatedMessage);
        LOG.debug("Move Images final updated message to be committed - " + updatedMessage.toString());
        ModifiableValueMap mvm = resource.adaptTo(ModifiableValueMap.class);
        mvm.put("jcr:description", updatedMessage.toString());
        for (String deletedResourcePath : deletedResources) {
            Resource resourceToDelete = serviceUserResolver.getResource(deletedResourcePath);
            serviceUserResolver.delete(resourceToDelete);
        }
        LOG.debug("Move Images : areImagesRemoved flag is " + areImagesRemoved);
        serviceUserResolver.commit();
    }

    private static String uploadImageToSRP(ClientUtilities clientUtils, String contextPath, Comment ocomment, String imageName, InputStream inputStream, String mimeType) {
        Resource imageSource;
        String imageUrl = null;
        if (inputStream != null && (imageSource = ocomment.addImage(imageName, inputStream, mimeType)) != null) {
            imageUrl = UploadOperationUtils.generateImageUrl(clientUtils, contextPath, imageSource);
            LOG.debug("Uploaded Image - URL - " + imageUrl);
        }
        return imageUrl;
    }

    private static String generateImageUrl(ClientUtilities clientUtils, String contextPath, Resource imageSource) {
        return UploadOperationUtils.encode(StringUtils.isBlank(contextPath) ? imageSource.getPath() : contextPath + imageSource.getPath(), clientUtils);
    }

    private static List<String> getCurrentImageList(Resource resource, SocialUtils socialUtils) {
        Resource imagesRoot = resource.getChild(IMAGES_DIR);
        if (imagesRoot == null) {
            return Collections.emptyList();
        }
        if (!socialUtils.checkPermission(imagesRoot.getResourceResolver(), imagesRoot.getPath(), "read").booleanValue()) {
            throw new CommentException(String.format("Not allowed read attachments for comment: %s", imagesRoot.getPath()));
        }
        ValueMap tvm = imagesRoot.getValueMap();
        List<String> imagePathList = UploadOperationUtils.getAttachmentList(tvm);
        ArrayList<String> imageNameList = new ArrayList<String>();
        for (String imagePath : imagePathList) {
            imageNameList.add(FilenameUtils.getName(imagePath));
        }
        return imageNameList;
    }

    private static List<String> getAttachmentList(ValueMap vm) {
        if (vm.containsKey("social:attachments")) {
            Object alist = vm.get("social:attachments");
            if (alist instanceof String[]) {
                return new ArrayList<String>(Arrays.asList((String[])alist));
            }
            if (alist instanceof List) {
                return (List)alist;
            }
            if (alist instanceof Object[]) {
                Object[] attArray = (Object[])alist;
                ArrayList<String> attachmentList = new ArrayList<String>(attArray.length);
                for (int i = 0; i < attArray.length; ++i) {
                    if (!(attArray[i] instanceof String)) continue;
                    attachmentList.add((String)attArray[i]);
                }
                return attachmentList;
            }
        }
        return Collections.emptyList();
    }

    private static boolean removeInlineImages(List<String> images, Resource resource, SocialUtils socialUtils, Comment comment) {
        boolean areImagesRemoved = false;
        List<String> currentImages = UploadOperationUtils.getCurrentImageList(resource, socialUtils);
        for (String image : currentImages) {
            if (images.contains(image)) continue;
            areImagesRemoved = true;
            comment.removeAttachment(INLINE_IMAGE_PREFIX + image);
        }
        return areImagesRemoved;
    }

    public static InputStream generateAttachmentRenditionImage(InputStream inputStream, String thumbnailMimeType, int thumbnailSize) {
        ThumbnailConfig thumbnailConfig = new ThumbnailConfig(thumbnailSize, thumbnailSize, false);
        InputStream thumbnailStream = UploadOperationUtils.generateRenditionImage(inputStream, thumbnailMimeType, thumbnailConfig);
        return thumbnailStream;
    }

    private static String getStartTag(Matcher imgMatcher) {
        String startTag = imgMatcher.group(1);
        return startTag;
    }

    private static String getImgUrl(Matcher imgMatcher) {
        String endTag = imgMatcher.group(2);
        return endTag;
    }

    private static String getEndTag(Matcher imgMatcher) {
        String endTag = imgMatcher.group(3);
        return endTag;
    }

    private static String createThumbnailURL(Matcher imgMatcher, int imageWidth, int imageHeight, ThumbnailConfig config, String externalUrl, String renditionUrl) {
        String startTag = UploadOperationUtils.getStartTag(imgMatcher);
        String endTag = UploadOperationUtils.getEndTag(imgMatcher);
        String aTagOpen = "<a id=\"renditionAnchor\" href=\"" + externalUrl + "\" >";
        String imgTag = startTag + renditionUrl + endTag;
        String aTagClose = "</a>";
        String resultUrl = aTagOpen + imgTag + aTagClose;
        resultUrl = resultUrl.replaceAll("height=\"" + imageHeight + "\"", "height=\"" + config.getHeight() + "\"");
        resultUrl = resultUrl.replaceAll("width=\"" + imageWidth + "\"", "width=\"" + config.getWidth() + "\"");
        return resultUrl;
    }

    private static String updateImgProps(Matcher imgMatcher, int imageWidth, int imageHeight, ThumbnailConfig config, String renditionUrl) {
        String startTag = UploadOperationUtils.getStartTag(imgMatcher);
        String endTag = UploadOperationUtils.getEndTag(imgMatcher);
        String imgTag = startTag + renditionUrl + endTag;
        imgTag = imgTag.replaceAll("height=\"" + imageHeight + "\"", "height=\"" + config.getHeight() + "\"");
        imgTag = imgTag.replaceAll("width=\"" + imageWidth + "\"", "width=\"" + config.getWidth() + "\"");
        return imgTag;
    }

    private static int getImageAttributeValue(Matcher matcher) {
        String attributeValue;
        int result = Integer.MAX_VALUE;
        if (matcher.find() && StringUtils.isNumeric(attributeValue = matcher.group(2))) {
            result = Integer.parseInt(attributeValue);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream generateRenditionImage(InputStream inputStream, String thumbnailMimeType, ThumbnailConfig config) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(inputStream);
        }
        catch (Exception e) {
            LOG.error("Error in creating image from inpustream ", e.getStackTrace());
            IOUtils.closeQuietly(inputStream);
            return null;
        }
        Layer layer = new Layer(image);
        Layer tLayer = UploadOperationUtils.createThumb(layer, config);
        config.setHeight(layer.getHeight());
        config.setWidth(layer.getWidth());
        FileOutputStream out = null;
        FileInputStream in = null;
        try {
            File tmpFile = File.createTempFile("thumbnail", ".tmp");
            out = FileUtils.openOutputStream(tmpFile);
            tLayer.write(thumbnailMimeType, 0.8, out);
            in = FileUtils.openInputStream(tmpFile);
        }
        catch (Exception e) {
            try {
                LOG.error("Error in writing thumbnail image", e.getStackTrace());
                IOUtils.closeQuietly(in);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly(out);
        }
        IOUtils.closeQuietly(out);
        if (tLayer != layer) {
            tLayer.dispose();
        }
        return in;
    }

    private static Layer createThumb(Layer layer, ThumbnailConfig config) {
        Layer finalLayer = null;
        int maxWidth = config.getWidth();
        int maxHeight = config.getHeight();
        boolean doCenter = config.doCenter();
        int width = layer.getWidth();
        int height = layer.getHeight();
        Color bgColor = layer.getBackgroundColor();
        if (height > maxHeight || width > maxWidth) {
            int newWidth;
            int newHeight;
            if (height > width) {
                newHeight = maxHeight;
                newWidth = width * maxHeight / height;
                if (newWidth > maxWidth) {
                    newWidth = maxWidth;
                    newHeight = height * maxWidth / width;
                }
            } else {
                newWidth = maxWidth;
                newHeight = height * maxWidth / width;
                if (newHeight > maxHeight) {
                    newHeight = maxHeight;
                    newWidth = width * maxHeight / height;
                }
            }
            layer.resize(newWidth, newHeight, true);
        }
        if ((layer.getHeight() < maxHeight || layer.getWidth() < maxWidth) && doCenter) {
            Color bg = null != bgColor ? bgColor : Color.WHITE;
            finalLayer = new Layer(maxWidth, maxHeight, bg);
            finalLayer.setTransparency(bg);
            int y = (maxHeight - layer.getHeight()) / 2;
            int x = (maxWidth - layer.getWidth()) / 2;
            layer.setX(x);
            layer.setY(y);
            finalLayer.merge(layer);
            layer = finalLayer;
        }
        return layer;
    }

    private static String encode(String str, ClientUtilities clientUtils) {
        String result = clientUtils.externalLink(str, false);
        return Text.escapePath(str);
    }

    private static String replace(String text, String replacement, int startIndex, int length) {
        int replLength = replacement.length();
        int increase = replacement.length() - length;
        increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text.length() + (increase *= 16));
        buf = buf.append(text, 0, startIndex + 1).append(replacement).append(text.substring(startIndex + length));
        return buf.toString();
    }

    private static String externalizeLink(String contextPath, Externalizer externalizer, boolean author, ResourceResolver resolver, String url) {
        String externalUrl;
        String string = externalUrl = StringUtils.isBlank(contextPath) ? url : contextPath + "/" + url;
        if (externalizer != null) {
            externalUrl = author ? externalizer.authorLink(resolver, externalUrl) : externalizer.publishLink(resolver, externalUrl);
        }
        return UploadOperationUtils.getRootBasedURL(url);
    }

    private static String getRootBasedURL(String url) {
        try {
            URL startURL = new URL(url);
            String HOST_CHECK_HEADER = "origin";
            if (StringUtils.startsWithIgnoreCase(startURL.getProtocol(), "http")) {
                return StringUtils.removeStart(url.toString(), startURL.getProtocol() + "://" + startURL.getHost() + (startURL.getPort() == -1 ? "" : INLINE_IMAGE_PREFIX + startURL.getPort()));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    private static boolean skipFolder(String name) {
        for (int i = 0; i < SKIP_DIRS.length; ++i) {
            if (!name.equals(SKIP_DIRS[i])) continue;
            return true;
        }
        return false;
    }

    private static class ThumbnailConfig {
        private int width;
        private int height;
        private boolean doCenter;

        public ThumbnailConfig(int width, int height, boolean doCenter) {
            this.width = width;
            this.height = height;
            this.doCenter = doCenter;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public boolean doCenter() {
            return this.doCenter;
        }
    }
}

