/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.screens.impl.aemio;

import com.adobe.cq.screens.device.Device;
import com.adobe.cq.screens.device.DeviceManager;
import com.adobe.cq.screens.impl.aemio.ScreensModelLookup;
import com.adobe.granite.haf.annotations.ApiAction;
import com.adobe.granite.haf.annotations.ApiModel;
import com.adobe.granite.haf.annotations.HttpFormParam;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={Resource.class})
@ApiModel(category="screens", type={"aem-io/screens/device"}, modelLookup=ScreensModelLookup.class)
public class ScreensDeviceModel {
    @Inject
    @Self
    protected Resource baseResource;

    @ApiAction(method="POST", name="broadcast-command")
    public void executeCommand(@HttpFormParam(value="command") String msg, @HttpFormParam(value="command_payload", optional=true) String msgPayload) throws RepositoryException, JSONException {
        this.executeCommand(msg, msgPayload, false);
    }

    @ApiAction(method="POST", name="broadcast-command-with-ack")
    public void executeCommand(@HttpFormParam(value="command") String msg, @HttpFormParam(value="command_payload", optional=true) String msgPayload, @HttpFormParam(value="requires_ack", optional=true) Boolean requiresAck) throws RepositoryException, JSONException {
        DeviceManager dm = this.baseResource.getResourceResolver().adaptTo(DeviceManager.class);
        if (dm == null) {
            return;
        }
        Device device = this.baseResource.adaptTo(Device.class);
        if (device == null) {
            return;
        }
        JSONObject payload = null;
        if (msgPayload != null) {
            payload = new JSONObject(msgPayload);
        }
        dm.executeCommand(device, msg, payload, requiresAck != null && requiresAck != false);
    }
}

