/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.utils.GuideConstants;
import java.util.HashMap;
import org.apache.commons.lang3.text.WordUtils;

public final class NameUtils {
    private NameUtils() {
        throw new UnsupportedOperationException();
    }

    public static String getOrGenerateUniqueName(String localName, HashMap<String, Integer> nameCountMap) {
        String normalizedName = localName.replace('.', '_');
        if (GuideConstants.GUIDE_RESERVED_WORDS.contains(normalizedName) || nameCountMap.containsKey(normalizedName)) {
            int count = nameCountMap.getOrDefault(normalizedName, 0) + 1;
            nameCountMap.put(normalizedName, count);
            normalizedName = normalizedName + "_" + count;
        } else {
            nameCountMap.put(normalizedName, 0);
        }
        return normalizedName;
    }

    public static String humanize(String name) {
        if (name == null) {
            return null;
        }
        String humanizedName = name.replaceAll("_", " ");
        humanizedName = humanizedName.replaceAll("([A-Z][a-z]+)", " $1").replaceAll("([A-Z][A-Z]+)", " $1").replaceAll("([^A-Za-z ]+)", " $1").trim();
        humanizedName = WordUtils.capitalize(humanizedName);
        return humanizedName;
    }
}

