/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.resourcemerger.api.ResourceMergerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideStyleMigrationUtils {
    private static Logger logger = LoggerFactory.getLogger(GuideStyleMigrationUtils.class);

    public static Map<String, String> getSelectorResourceMap(Resource styleConfig, Map map, String pathPrefix) {
        if (styleConfig != null) {
            Iterable<Resource> children = styleConfig.getChildren();
            Iterator<Resource> iterator = children.iterator();
            while (iterator.hasNext()) {
                String prefix = pathPrefix;
                Resource childResource = iterator.next();
                Resource actualChildResource = GuideStyleMigrationUtils.getTargetResource(childResource);
                prefix = prefix + "/" + childResource.getName();
                Map<String, String> tempMap = GuideStyleMigrationUtils.getSelectorResourceMap(actualChildResource, map, prefix);
                map.putAll(tempMap);
            }
            ValueMap values = styleConfig.getValueMap();
            String id = (String)((Object)values.get("id", String.class));
            if (id != null) {
                if ((pathPrefix = pathPrefix.replaceAll("/items/", "/")).startsWith("/")) {
                    pathPrefix = pathPrefix.substring(1);
                }
                map.put(id, pathPrefix);
            }
        }
        return map;
    }

    public static Map<String, String> getSelectorResourceMap(Resource styleConfig, Map map) {
        if (styleConfig != null) {
            Iterable<Resource> children = styleConfig.getChildren();
            for (Resource childResource : children) {
                Resource actualChildResource = GuideStyleMigrationUtils.getTargetResource(childResource);
                Map<String, String> tempMap = GuideStyleMigrationUtils.getSelectorResourceMap(actualChildResource, map);
                map.putAll(tempMap);
            }
            ValueMap values = styleConfig.getValueMap();
            String id = (String)((Object)values.get("id", String.class));
            if (id != null) {
                map.put(id, styleConfig.getPath());
            }
        }
        return map;
    }

    private static String removeConfigPrefix(String fullPathString) {
        String selectorPath = fullPathString;
        if (fullPathString.contains("cq:styleConfig")) {
            selectorPath = fullPathString.substring(fullPathString.indexOf("cq:styleConfig") + 21);
        }
        if (fullPathString.contains("cq:themeConfig")) {
            selectorPath = fullPathString.substring(fullPathString.indexOf("cq:themeConfig") + 21);
        }
        return selectorPath;
    }

    private static boolean isTargetResource(Resource resource) {
        ValueMap values = resource.getValueMap();
        return values.containsKey("target");
    }

    private static Resource getTargetResource(Resource resource) {
        ValueMap values = resource.getValueMap();
        String target = (String)((Object)values.get("target", String.class));
        if (target != null) {
            ResourceResolver resolver = resource.getResourceResolver();
            return resolver.getResource(target);
        }
        return resource;
    }

    public static void migrateBreakpointJson(JSONObject styleJSON, Resource styleResource, String componentResourceType, ResourceMergerService resourceMergerService) throws PersistenceException, RepositoryException, JSONException {
        ResourceResolver resolver = styleResource.getResourceResolver();
        JSONObject selectorsParent = styleJSON.getJSONObject("selectors");
        Iterator<String> selectorKeys = selectorsParent.keys();
        Map selectorMap = GuideStyleMigrationUtils.getSelectorIDMap(componentResourceType, resolver, resourceMergerService, "cq:styleConfig");
        while (selectorKeys.hasNext()) {
            String selectorKey = selectorKeys.next();
            String updatedKey = GuideStyleMigrationUtils.getIDBasedSelector(selectorMap, selectorKey);
            HashMap<String, Object> selectorProperties = new HashMap<String, Object>();
            JSONObject selectorObject = selectorsParent.getJSONObject(selectorKey);
            JSONObject breakpointParent = selectorObject.getJSONObject("breakpoints");
            Iterator<String> breakpointsKeys = breakpointParent.keys();
            while (breakpointsKeys.hasNext()) {
                String breakpointName = breakpointsKeys.next();
                JSONObject breakpointJson = breakpointParent.getJSONObject(breakpointName);
                JSONObject statesParent = breakpointJson.getJSONObject("states");
                Iterator<String> statesKeys = statesParent.keys();
                while (statesKeys.hasNext()) {
                    String stateName = statesKeys.next();
                    Map stateProperties = GuideStyleMigrationUtils.getStatePropertiesMap(breakpointName, stateName, statesParent.getJSONObject(stateName));
                    selectorProperties.putAll(stateProperties);
                }
            }
            resolver.create(styleResource, updatedKey, selectorProperties);
        }
    }

    public static String getIDBasedSelector(Map<String, String> selectorMap, String selectorKey) {
        String updatedKey = selectorKey;
        if (!selectorMap.containsKey(selectorKey) && selectorMap.containsValue(selectorKey)) {
            for (String key : selectorMap.keySet()) {
                String value = selectorMap.get(key);
                if (!selectorKey.equals(value)) continue;
                updatedKey = key;
                break;
            }
        }
        return updatedKey.replace("/", "_");
    }

    public static Map getStatePropertiesMap(String breakpointName, String stateName, JSONObject stateJSON) throws RepositoryException, JSONException {
        String key;
        ArrayList<String> properties;
        Iterator<String> keys;
        JSONObject uiPropertiesJSON;
        HashMap<String, String[]> stateMap = new HashMap<String, String[]>();
        String cssPropertyName = breakpointName + "#" + stateName;
        String uiPropertyName = breakpointName + "#" + stateName + "#ui";
        if (stateJSON.has("cssProperties")) {
            uiPropertiesJSON = (JSONObject)stateJSON.get("cssProperties");
            keys = uiPropertiesJSON.keys();
            properties = new ArrayList<String>();
            while (keys.hasNext()) {
                key = keys.next();
                properties.add(key + ":" + uiPropertiesJSON.getString(key));
            }
            if (properties.size() > 0) {
                stateMap.put(cssPropertyName, properties.toArray(new String[properties.size()]));
            }
        }
        if (stateJSON.has("uiProperties")) {
            uiPropertiesJSON = (JSONObject)stateJSON.get("uiProperties");
            keys = uiPropertiesJSON.keys();
            properties = new ArrayList();
            while (keys.hasNext()) {
                key = keys.next();
                properties.add(key + ":" + uiPropertiesJSON.getString(key));
            }
            if (properties.size() > 0) {
                stateMap.put(uiPropertyName, properties.toArray(new String[properties.size()]));
            }
        }
        return stateMap;
    }

    public static Map getSelectorMap(String componentType, ResourceResolver resolver, ResourceMergerService resourceMergerService, String configNodeName) {
        Map<Object, Object> selectorResourceMap = new HashMap();
        if (componentType.endsWith("fd/af/components/rootPanel")) {
            componentType = "fd/af/components/panel";
        } else if (componentType.endsWith("fd/af/components/guideContainerWrapper")) {
            componentType = "fd/af/components/guideContainer";
        }
        String componentPath = resolver.getResource(componentType).getPath();
        Resource componentRes = resolver.getResource("/mnt/override/" + componentPath);
        if (componentRes != null) {
            Resource styleConfigMergedRes = componentRes.getChild(configNodeName);
            selectorResourceMap = GuideStyleMigrationUtils.getSelectorResourceMap(styleConfigMergedRes, selectorResourceMap);
        }
        return selectorResourceMap;
    }

    public static Map getSelectorIDMap(String componentType, ResourceResolver resolver, ResourceMergerService resourceMergerService, String configNodeName) {
        Map<Object, Object> selectorResourceMap = new HashMap();
        String componentPath = resolver.getResource(componentType).getPath();
        Resource componentRes = resolver.getResource("/mnt/override/" + componentPath);
        if (componentRes != null) {
            Resource styleConfigMergedRes = componentRes.getChild(configNodeName);
            selectorResourceMap = GuideStyleMigrationUtils.getSelectorResourceMap(styleConfigMergedRes, selectorResourceMap, "");
        }
        return selectorResourceMap;
    }
}

