/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.servlet;

import com.adobe.aem.transaction.core.ITransactionRecorder;
import com.adobe.aem.transaction.core.exception.TransactionException;
import com.adobe.aem.transaction.core.model.TransactionRecord;
import com.adobe.aemds.guide.common.GuideError;
import com.adobe.aemds.guide.common.GuideValidationResult;
import com.adobe.aemds.guide.model.FormSubmitInfo;
import com.adobe.aemds.guide.model.SignAgreementInfo;
import com.adobe.aemds.guide.model.SubmitType;
import com.adobe.aemds.guide.model.ValidationOptions;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideModelTransformer;
import com.adobe.aemds.guide.service.GuidePDFSubmitHelper;
import com.adobe.aemds.guide.service.GuideStoreContentSubmission;
import com.adobe.aemds.guide.service.SignAgreementService;
import com.adobe.aemds.guide.service.external.FormPortalSubmitPreprocessor;
import com.adobe.aemds.guide.service.external.GuideSubmitPostProcessor;
import com.adobe.aemds.guide.service.external.PortalRecordInfo;
import com.adobe.aemds.guide.submitutils.FileRequestParameter;
import com.adobe.aemds.guide.submitutils.FormFieldRequestParameter;
import com.adobe.aemds.guide.utils.GuideConstants;
import com.adobe.aemds.guide.utils.GuideSubmitErrorCause;
import com.adobe.aemds.guide.utils.GuideSubmitUtils;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.forms.common.service.FileAttachmentWrapper;
import com.adobe.forms.common.submitutils.CustomParameterRequest;
import com.adobe.forms.common.submitutils.CustomResponse;
import com.adobe.forms.common.submitutils.ParameterMap;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.ServiceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"fd/af/components/guideContainer"}), @Property(name="sling.servlet.methods", value={"POST"}), @Property(name="service.description", value={"Adaptive Form Submit"}), @Property(name="sling.servlet.selectors", value={"af.submit", "af.agreement", "af.signSubmit"})})
public class GuideSubmitServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -5597140632392446185L;
    public static final String REQ_ATTR_FORWARD_PATH = "forward.path";
    public static final String REQ_ATTR_FORWARD_OPTIONS = "forward.options";
    public static final String REQUEST_ATTR_WORKFLOW_PATH = "Forms.workflow.path";
    public static final String REQUEST_ATTR_WORKFLOW_PAYLOAD_PATH = "Forms.workflow.payloadPath";
    public static final String REQUEST_ATTR_REDIRECT_PARAMETER_MAP = "redirectParameters";
    private Logger logger = LoggerFactory.getLogger(GuideSubmitServlet.class);
    @Reference
    private ITransactionRecorder transactionRecorder;
    @Reference
    private GuideModelTransformer guideModelTransformer;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private volatile SignAgreementService signAgreementService;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private GuidePDFSubmitHelper guidePDFSubmitHelper;
    @Reference
    private GuideStoreContentSubmission guideStoreContentSubmission;
    @Reference(policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private FormPortalSubmitPreprocessor formsPortalPreProcessor;
    @Reference(name="guideSubmitPostProcessors", referenceInterface=GuideSubmitPostProcessor.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private Map<Comparable<Object>, GuideSubmitPostProcessor> guideSubmitPostProcessors = new ConcurrentSkipListMap(Collections.reverseOrder());

    private TransactionRecord getAdaptiveFormSubmitTransaction(Resource formResource) {
        String resId = formResource != null ? formResource.getPath() : "";
        String resType = "FORM";
        String resSubType = "ADAPTIVE-FORM";
        String transactionType = "SUBMIT";
        String transactionSubType = null;
        String resName = formResource != null && formResource.getParent() != null ? formResource.getParent().getValueMap().get("jcr:title", "") : "";
        Integer transactionCount = 1;
        return new TransactionRecord(transactionCount, resType, resSubType, transactionType, transactionSubType, resId, resName);
    }

    private String getLocale(SlingHttpServletRequest request) {
        String locale = request.getParameter("runtimeLocale");
        if (locale == null || locale.isEmpty()) {
            locale = "en";
        }
        return locale;
    }

    private GuideValidationResult validateForm(SlingHttpServletRequest request, String locale) {
        ValidationOptions validationOptions = new ValidationOptions.ValidationOptionsBuilder().setFormContainerResource(request.getResource()).setData(request.getParameter("jcr:data")).setCaptchaData(request.getParameter("captchaData")).setServerUrl(this.getServerUrl(request)).setContextPath(request.getContextPath()).setLocale(locale).setFileAttachmentMap(request.getParameter("fileAttachmentMap")).build();
        return this.guideModelTransformer.validateForm(validationOptions);
    }

    private SignAgreementInfo doPostPrerequisites(SlingHttpServletRequest request, SlingHttpServletResponse response, ParameterMap wrappedParameterMap, SubmitType submitType) {
        SignAgreementInfo signAgreementInfo = null;
        SlingHttpServletRequest wrappedRequest = request;
        String locale = this.getLocale(request);
        GuideValidationResult guideValidationResult = this.validateForm(request, locale);
        try {
            if (guideValidationResult != null && guideValidationResult.hasErrors()) {
                throw new GuideException("Server validation failed.");
            }
            guideValidationResult = null;
            FormSubmitInfo submitInfo = new FormSubmitInfo();
            Resource formContainerResource = request.getResource();
            boolean isDorConfigured = GuideUtils.isDORConfigured(formContainerResource);
            ValueMap properties = ResourceUtil.getValueMap(formContainerResource);
            Boolean isAdobeSignEnabled = Boolean.valueOf(properties.get("_useSignedPdf", ""));
            Boolean isRedirectURLSet = StringUtils.isNotEmpty(properties.get("redirect", ""));
            String postSignUrl = "";
            List<FileAttachmentWrapper> fileAttachmentWrapperList = this.getFileAttachmentWrapperList(wrappedParameterMap);
            String fileAttachmentMap = request.getParameter("fileAttachmentMap");
            ResourceResolver resourceResolver = request.getResourceResolver();
            Authorizable auth = resourceResolver.adaptTo(Authorizable.class);
            submitInfo.setFormContainerPath(formContainerResource.getPath());
            submitInfo.setFormContainerResource(formContainerResource);
            submitInfo.setContentType(GuideUtils.getDataMimeType(formContainerResource));
            submitInfo.setFileAttachments(fileAttachmentWrapperList);
            submitInfo.setFileAttachmentMap(fileAttachmentMap);
            submitInfo.setData(request.getParameter("jcr:data"));
            submitInfo.setFormSubmitter(auth.getID());
            submitInfo.setLocale(GuideUtils.getXFALocale(locale));
            if (request.getParameter("_useSignedPdf") != null || isAdobeSignEnabled.booleanValue()) {
                if (isDorConfigured) {
                    try {
                        wrappedParameterMap = this.guidePDFSubmitHelper.getWrappedParameterMapForPdfSubmit(request, response, wrappedParameterMap);
                    }
                    catch (Exception ex) {
                        throw new GuideException(ex);
                    }
                    String pdfName = (String)request.getAttribute("pdfName");
                    FileRequestParameter pdfRequestParam = (FileRequestParameter)((RequestParameter[])wrappedParameterMap.get(pdfName))[0];
                    submitInfo.setDocumentOfRecord(new FileAttachmentWrapper(pdfName, "application/pdf", pdfRequestParam.get()));
                } else {
                    this.logger.debug("DOR Template is not configured for the form. Skipping DOR generation");
                }
            }
            request.setAttribute("FormSubmitInfo", submitInfo);
            if (isRedirectURLSet.booleanValue() && isAdobeSignEnabled.booleanValue() && (postSignUrl = GuideSubmitServlet.getRedirectUrl(wrappedRequest)) != null) {
                postSignUrl = this.getServerUrl(wrappedRequest) + request.getContextPath() + postSignUrl;
            }
            if (isAdobeSignEnabled.booleanValue() && submitInfo.getDocumentOfRecord() != null && (signAgreementInfo = this.signAgreementService.createAgreement(submitInfo, postSignUrl, SubmitType.IMMEDIATE == submitType)).getAgreementId() == null) {
                GuideError guideError = new GuideError(null, "Error During Agreement Creation");
                ArrayList<GuideError> guideErrorList = new ArrayList<GuideError>();
                guideErrorList.add(guideError);
                guideValidationResult = new GuideValidationResult(guideErrorList, GuideSubmitErrorCause.AGREEMENT_CREATION);
                throw new GuideException("There is an error in agreement creation.");
            }
            if (this.formsPortalPreProcessor != null) {
                HashMap<String, Object> preProcessorOptions = new HashMap<String, Object>();
                preProcessorOptions.put("FormSubmitInfo", submitInfo);
                preProcessorOptions.put("enablePortalSubmit", Boolean.valueOf(properties.get("enablePortalSubmit", "false")));
                if (signAgreementInfo != null) {
                    submitInfo.setAgreementId(signAgreementInfo.getAgreementId());
                    preProcessorOptions.put("signAgreementInfo", signAgreementInfo);
                }
                preProcessorOptions.put("submitType", (Object)submitType);
                preProcessorOptions.put("draftID", request.getParameter("draftID"));
                preProcessorOptions.put("afSubmissionInfo", request.getParameter("afSubmissionInfo"));
                PortalRecordInfo portalResult = this.formsPortalPreProcessor.doPreProcess(preProcessorOptions);
                submitInfo.setPortalRecordInfo(portalResult);
            }
        }
        catch (GuideException e) {
            this.sendErrorBackToClient(wrappedRequest, response, wrappedParameterMap, guideValidationResult);
            this.logger.error("Could not complete Submit Action due to " + e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            this.sendErrorBackToClient(wrappedRequest, response, wrappedParameterMap, guideValidationResult);
            this.logger.error("Could not complete Submit Action due to " + e.getMessage(), e);
            throw new GuideException(e);
        }
        return signAgreementInfo;
    }

    private ParameterMap addGuideValueMap(SlingHttpServletRequest request, SlingHttpServletResponse response, ParameterMap wrappedParameterMap) {
        String guideValues = request.getParameter("_guideValuesMap");
        try {
            JSONObject guideValueMapJson = StringUtils.isNotEmpty(guideValues) ? new JSONObject(guideValues) : new JSONObject();
            FormSubmitInfo submitInfo = (FormSubmitInfo)request.getAttribute("FormSubmitInfo");
            PortalRecordInfo portalResult = submitInfo.getPortalRecordInfo();
            if (portalResult != null) {
                String submitLink;
                String submitId = portalResult.getSubmitID();
                if (StringUtils.isNotEmpty(submitId)) {
                    guideValueMapJson.put("submitID", submitId);
                }
                if (StringUtils.isNotEmpty(submitLink = portalResult.getSubmitLink())) {
                    guideValueMapJson.put("submitLink", submitLink);
                }
            }
            FormFieldRequestParameter paramValue = new FormFieldRequestParameter(guideValueMapJson.toString());
            RequestParameter[] paramArr = new RequestParameter[]{paramValue};
            GuideUtils.addToRequestMap(wrappedParameterMap, "_guideValuesMap", paramArr);
        }
        catch (Exception e) {
            this.logger.error("Corrupted Guide Value map " + e.getMessage(), e);
            throw new GuideException(e);
        }
        return wrappedParameterMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doSubmit(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        SlingHttpServletRequest wrappedRequest = request;
        ParameterMap wrappedParameterMap = null;
        try {
            wrappedParameterMap = this.addToNewRequest(wrappedRequest, response);
        }
        catch (Exception e) {
            this.sendErrorBackToClient(request, response, null, null);
            this.logger.error("Failes Submit Action due to " + e.getMessage(), e);
            throw new GuideException(e);
        }
        SignAgreementInfo signAgreementInfo = this.doPostPrerequisites(request, response, wrappedParameterMap, SubmitType.DEFERRED);
        Resource formResource = request.getResource();
        ValueMap properties = ResourceUtil.getValueMap(formResource);
        Boolean isAdobeSignEnabled = Boolean.valueOf(properties.get("_useSignedPdf", ""));
        Boolean isPortalSubmitEnabled = Boolean.valueOf(properties.get("enablePortalSubmit", "false"));
        boolean asyncSubmit = "true".equals(request.getParameter("_asyncSubmit"));
        String pendingSignUrl = null;
        if (signAgreementInfo != null) {
            pendingSignUrl = signAgreementInfo.getSigningURL();
        }
        if (!asyncSubmit && isAdobeSignEnabled.booleanValue() && StringUtils.isNotEmpty(pendingSignUrl)) {
            try {
                response.sendRedirect(pendingSignUrl);
                return;
            }
            catch (Exception e) {
                this.logger.error("Could not redirect to pending sign URL " + e.getMessage(), e);
                throw new GuideException(e);
            }
        }
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        Adaptable forwardResource = null;
        String forwardPath = null;
        try {
            wrappedParameterMap = this.addGuideValueMap(wrappedRequest, response, wrappedParameterMap);
            wrappedRequest = new CustomParameterRequest(request, wrappedParameterMap, "POST");
            CustomResponse wrappedResp = new CustomResponse(response);
            if (!isAdobeSignEnabled.booleanValue()) {
                String actionType;
                String string = actionType = properties == null ? "" : properties.get("actionType", "");
                if (StringUtils.isEmpty(actionType)) {
                    this.logger.warn("Author has not associated any submit action with the form.");
                }
                FormsHelper.runAction(actionType, "post", formResource, wrappedRequest, wrappedResp);
            }
            if (wrappedResp != null && wrappedResp.getStatus() == 500) {
                throw new GuideException("Form submission failed due to internal server error from response");
            }
            String redirectUrl = GuideSubmitServlet.getRedirectUrl(wrappedRequest);
            FormSubmitInfo submitInfo = (FormSubmitInfo)request.getAttribute("FormSubmitInfo");
            if (asyncSubmit || redirectUrl == null || redirectUrl.length() == 0) {
                JSONObject successPayload = this.prepareSuccessPayload(wrappedRequest, properties, redirectUrl);
                Map<String, String> redirectParamsMap = GuideSubmitUtils.getRedirectParameters(wrappedRequest);
                if (redirectParamsMap == null) {
                    redirectParamsMap = new HashMap<String, String>();
                }
                redirectParamsMap.put("afSuccessPayload", successPayload.toString());
                if (isAdobeSignEnabled.booleanValue()) {
                    redirectParamsMap.put("agreementId", signAgreementInfo.getAgreementId());
                    redirectParamsMap.put("systemId", submitInfo.getPortalRecordInfo().getSubmitID());
                } else if (isPortalSubmitEnabled.booleanValue()) {
                    PortalRecordInfo portalRecordInfo = submitInfo.getPortalRecordInfo();
                    redirectParamsMap.put("submitID", portalRecordInfo.getSubmitID());
                    redirectParamsMap.put("path", portalRecordInfo.getSubmitLink());
                }
                GuideSubmitUtils.setRedirectParameters(wrappedRequest, redirectParamsMap);
                redirectUrl = request.getResource().getPath() + "." + "guideAsyncThankYouPage.html";
                redirectUrl = this.prepareRedirectUrl(wrappedRequest, redirectUrl);
            } else if (redirectUrl != null && redirectUrl.length() > 0) {
                redirectUrl = this.prepareRedirectUrl(wrappedRequest, redirectUrl);
            }
            FormFieldRequestParameter rpm = new FormFieldRequestParameter(redirectUrl);
            RequestParameter[] f = new RequestParameter[]{rpm};
            GuideUtils.addToRequestMap(wrappedParameterMap, ":redirect", f);
            this.removeUnusedParameters(wrappedParameterMap);
            wrappedRequest = new CustomParameterRequest(request, wrappedParameterMap, "POST");
            forwardPath = this.getForwardPath(wrappedRequest);
            if (forwardPath != null && forwardPath.length() > 0) {
                forwardResource = wrappedRequest.getResourceResolver().resolve(forwardPath);
                request.getRequestDispatcher((Resource)forwardResource, this.getForwardOptions(wrappedRequest)).forward(wrappedRequest, response);
            } else {
                redirectUrl = GuideSubmitUtils.addContextPath(redirectUrl, request.getContextPath());
                response.sendRedirect(redirectUrl);
            }
            if (!isAdobeSignEnabled.booleanValue()) {
                for (GuideSubmitPostProcessor guideSubmitPostProcessor : this.guideSubmitPostProcessors.values()) {
                    try {
                        guideSubmitPostProcessor.handlePostProcess(submitInfo.getData(), submitInfo.getFileAttachments(), optionsMap);
                    }
                    catch (Exception e) {
                        this.logger.error("The current guideSubmitPostProcessor could not give path", e);
                    }
                }
            }
        }
        catch (GuideException e) {
            try {
                this.sendErrorBackToClient(request, response, wrappedParameterMap, null);
                this.logger.error("Could not complete Submit Action due to " + e.getMessage(), e);
                throw e;
                catch (Exception e2) {
                    this.sendErrorBackToClient(request, response, wrappedParameterMap, null);
                    this.logger.error("Could not complete Submit Action due to " + e2.getMessage(), e2);
                    throw new GuideException(e2);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (forwardResource == null) throw throwable;
                    ModifiableValueMap forwardResourceProperties = forwardResource.adaptTo(ModifiableValueMap.class);
                    if (forwardResourceProperties == null) throw throwable;
                    if (!forwardResourceProperties.containsKey("afStoreContentTempPermission")) throw throwable;
                    forwardResourceProperties.remove("afStoreContentTempPermission");
                    request.getResourceResolver().commit();
                    this.guideStoreContentSubmission.unsetPrivilegesForStoreContent(GuideUtils.getUserSessionFromRequest(request), forwardPath);
                    throw throwable;
                }
                catch (Exception ex) {
                    this.logger.error("Could not unset privileges", ex);
                }
                throw throwable;
            }
        }
        try {
            if (forwardResource == null) return;
            ModifiableValueMap forwardResourceProperties = forwardResource.adaptTo(ModifiableValueMap.class);
            if (forwardResourceProperties == null) return;
            if (!forwardResourceProperties.containsKey("afStoreContentTempPermission")) return;
            forwardResourceProperties.remove("afStoreContentTempPermission");
            request.getResourceResolver().commit();
            this.guideStoreContentSubmission.unsetPrivilegesForStoreContent(GuideUtils.getUserSessionFromRequest(request), forwardPath);
            return;
        }
        catch (Exception ex) {
            this.logger.error("Could not unset privileges", ex);
            return;
        }
    }

    private void sendAgreementInfo(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        SlingHttpServletRequest wrappedRequest = request;
        ParameterMap wrappedParameterMap = this.addToNewRequest(wrappedRequest, response);
        SignAgreementInfo signAgreementInfo = this.doPostPrerequisites(request, response, wrappedParameterMap, SubmitType.IMMEDIATE);
        JSONObject jsonObject = new JSONObject();
        FormSubmitInfo submitInfo = (FormSubmitInfo)request.getAttribute("FormSubmitInfo");
        PortalRecordInfo portalResult = submitInfo.getPortalRecordInfo();
        try {
            if (StringUtils.isNotEmpty(signAgreementInfo.getSigningURL())) {
                jsonObject.put("signingURL", signAgreementInfo.getSigningURL());
            }
            jsonObject.put("agreementId", signAgreementInfo.getAgreementId());
            jsonObject.put("systemId", portalResult.getSubmitID());
            this.sendJSONResponse(request, response, jsonObject);
        }
        catch (GuideException e) {
            this.logger.error("Failed to create response JSON " + e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Failed to create response JSON " + e.getMessage(), e);
            throw new GuideException(e);
        }
    }

    private void doSignSubmit(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        Resource formContainerResource = request.getResource();
        Resource signerInfoResource = formContainerResource.getChild("signerInfo");
        String signConfigPath = "";
        String agreementId = request.getParameter("agreementId");
        String systemId = request.getParameter("systemId");
        String newSystemId = "";
        String pendingSignId = "";
        String link = "";
        if (signerInfoResource != null) {
            signConfigPath = signerInfoResource.getValueMap().get("signConfigPath", "");
        }
        if (StringUtils.isNotEmpty(signConfigPath)) {
            Map<String, Object> result = this.signAgreementService.submitAgreement(systemId, agreementId, signConfigPath);
            if (result != null) {
                link = (String)result.get("path");
                newSystemId = (String)result.get("submitID");
                pendingSignId = (String)result.get("pendingSignID");
            } else {
                pendingSignId = systemId;
                link = "/content/forms/portal/render.dor.pdf/pendingSign/" + pendingSignId;
            }
        }
        Resource afResource = GuideSubmitUtils.getParentResource(formContainerResource, "cq:Page");
        String formName = afResource.getValueMap().get("jcr:title", afResource.getName());
        String submitId = "";
        if (StringUtils.isNotEmpty(newSystemId)) {
            submitId = newSystemId;
        } else if (StringUtils.isNotEmpty(pendingSignId)) {
            submitId = pendingSignId;
        }
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("agreementId", agreementId);
            jsonObject.put("guideName", formName);
            jsonObject.put("submitID", submitId);
            jsonObject.put("owner", GuideSubmitUtils.getUserID(request));
            jsonObject.put("path", link);
            this.sendJSONResponse(request, response, jsonObject);
        }
        catch (Exception e) {
            this.logger.error("Failed to create response JSON " + e.getMessage(), e);
            throw new GuideException(e);
        }
    }

    private void sendJSONResponse(SlingHttpServletRequest request, SlingHttpServletResponse response, JSONObject jsonObject) {
        SlingHttpServletRequest wrappedRequest = request;
        try {
            response.setContentType("application/json");
            response.getWriter().write(jsonObject.toString());
        }
        catch (Exception e) {
            this.logger.error("Could not send response back due to " + e.getMessage(), e);
            throw new GuideException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String[] requestSelectors = request.getRequestPathInfo().getSelectors();
        String requestSelector = "";
        if (requestSelectors.length > 1) {
            requestSelector = requestSelectors[1];
        }
        boolean recordTransaction = true;
        try {
            this.transactionRecorder.startContext();
            if ("signSubmit".equals(requestSelector)) {
                recordTransaction = false;
                this.doSignSubmit(request, response);
            } else if ("agreement".equals(requestSelector)) {
                this.sendAgreementInfo(request, response);
            } else {
                this.doSubmit(request, response);
            }
            if (recordTransaction) {
                if (response.getStatus() < 400) {
                    TransactionRecord transactionRecord = this.getAdaptiveFormSubmitTransaction(request.getResource());
                    this.transactionRecorder.recordTransaction(transactionRecord);
                } else {
                    this.transactionRecorder.discardTransaction();
                }
            }
        }
        catch (TransactionException e) {
            this.logger.error("Transaction exception while recording transaction", e);
        }
        catch (Exception e) {
            if (recordTransaction) {
                this.transactionRecorder.discardTransaction();
            }
            this.logger.error("Exception in post request. " + e.getMessage(), e);
        }
        finally {
            this.transactionRecorder.endContext();
        }
    }

    private void sendErrorBackToClient(SlingHttpServletRequest request, SlingHttpServletResponse response, ParameterMap wrappedParameterMap, GuideValidationResult guideValidationResult) {
        if (guideValidationResult == null) {
            GuideError guideError = new GuideError(null, "Error During Form Submission");
            ArrayList<GuideError> guideErrorList = new ArrayList<GuideError>();
            guideErrorList.add(guideError);
            guideValidationResult = new GuideValidationResult(guideErrorList, GuideSubmitErrorCause.FORM_SUBMISSION);
        }
        CustomParameterRequest wrappedErrorRequest = new CustomParameterRequest(request, wrappedParameterMap, "GET");
        wrappedErrorRequest.setAttribute("guideErrorList", guideValidationResult);
        JSONObject errorObject = guideValidationResult.getValidationPayload();
        wrappedErrorRequest.setAttribute("guideError", errorObject);
        wrappedErrorRequest.setAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME, (Object)WCMMode.DISABLED);
        wrappedErrorRequest.setAttribute("data", request.getParameter("jcr:data"));
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        options.setReplaceSuffix(null);
        options.setReplaceSelectors(null);
        if ("XMLHttpRequest".equals(request.getHeader("X-Requested-With")) || "true".equals(request.getParameter("_asyncSubmit"))) {
            response.setStatus(500);
            response.setContentType("application/json");
            try {
                response.getWriter().write(errorObject.toString());
            }
            catch (IOException e) {
                if (errorObject != null) {
                    this.logger.debug("sendErrorBackToClient: errorObject:" + errorObject.toString());
                }
                this.logger.error("sendErrorBackToClient: failed to write to response " + e.getMessage(), e);
            }
        } else {
            try {
                request.getRequestDispatcher(request.getParameter(":selfUrl") + ".html", options).forward(wrappedErrorRequest, response);
            }
            catch (Exception e) {
                this.logger.error("sendErrorBackToClient: failed to forward request " + e.getMessage(), e);
            }
        }
    }

    protected void bindGuideSubmitPostProcessors(GuideSubmitPostProcessor guideSubmitPostProcessor, Map<String, Object> config) {
        this.guideSubmitPostProcessors.put(ServiceUtil.getComparableForServiceRanking(config), guideSubmitPostProcessor);
    }

    protected void unbindGuideSubmitPostProcessors(GuideSubmitPostProcessor guideSubmitPostProcessor, Map<String, Object> config) {
        this.guideSubmitPostProcessors.remove(ServiceUtil.getComparableForServiceRanking(config));
    }

    private RequestDispatcherOptions getForwardOptions(ServletRequest req) {
        return (RequestDispatcherOptions)req.getAttribute(REQ_ATTR_FORWARD_OPTIONS);
    }

    private String getServerUrl(SlingHttpServletRequest req) {
        String scheme = req.getScheme();
        String serverName = req.getServerName();
        int serverPort = req.getServerPort();
        StringBuffer url = new StringBuffer();
        url.append(scheme).append("://").append(serverName);
        if (serverPort != 80 && serverPort != 443) {
            url.append(":").append(serverPort);
        }
        return url.toString();
    }

    private String getForwardPath(SlingHttpServletRequest req) {
        return (String)req.getAttribute(REQ_ATTR_FORWARD_PATH);
    }

    @Deprecated
    public static void setForwardPath(SlingHttpServletRequest req, String path, String selector, String suffix) {
        GuideSubmitUtils.setForwardPath(req, path, selector, suffix);
    }

    private static String getRedirectUrl(SlingHttpServletRequest request) {
        String redirectUrl = null;
        redirectUrl = (String)request.getAttribute(":redirect");
        if (redirectUrl == null) {
            redirectUrl = request.getParameter(":redirect");
        }
        return redirectUrl;
    }

    @Deprecated
    public static void setRedirectUrl(SlingHttpServletRequest req, String redirectUrl) {
        GuideSubmitUtils.setRedirectUrl(req, redirectUrl);
    }

    @Deprecated
    public static Map<String, String> getRedirectParameters(SlingHttpServletRequest request) {
        return GuideSubmitUtils.getRedirectParameters(request);
    }

    @Deprecated
    public static void setRedirectParameters(SlingHttpServletRequest request, Map<String, String> value) {
        GuideSubmitUtils.setRedirectParameters(request, value);
    }

    @Deprecated
    public static String getReqAttrPdfName(SlingHttpServletRequest request) {
        return GuideSubmitUtils.getReqAttrPdfName(request);
    }

    public static void setRequestAttrPdfName(SlingHttpServletRequest request, String value) {
        request.setAttribute("pdfName", value);
    }

    private ParameterMap addToNewRequest(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        ParameterMap wrappedParameterMap = new ParameterMap();
        RequestParameterMap originalParams = request.getRequestParameterMap();
        ArrayList attachments = new ArrayList();
        for (Map.Entry param : originalParams.entrySet()) {
            String paramName;
            RequestParameter rp = ((RequestParameter[])param.getValue())[0];
            boolean isFile = false;
            boolean bl = isFile = ((String)param.getKey()).indexOf("_guideFileAttachment.") != -1 && "_guideFileAttachment.".equals(((String)param.getKey()).substring(0, 21));
            if (!rp.isFormField()) {
                RequestParameter[] fileRpm = new RequestParameter[]{new FileRequestParameter(rp.getName(), rp.get(), rp.getContentType())};
                GuideUtils.addToRequestMap(wrappedParameterMap, (String)param.getKey(), fileRpm);
                continue;
            }
            if (!isFile) {
                GuideUtils.addToRequestMap(wrappedParameterMap, (String)param.getKey(), (RequestParameter[])param.getValue());
                continue;
            }
            String filename = paramName = ((String)param.getKey()).substring(21);
            RequestParameter rpm = ((RequestParameter[])param.getValue())[0];
            RequestParameter[] fileRpm = new RequestParameter[1];
            String fileUrl = rpm.toString();
            String normalizedFileUrl = "";
            normalizedFileUrl = ResourceUtil.normalize(fileUrl);
            if (normalizedFileUrl == null) {
                this.logger.error("[AEMAF] Invalid Path in File Attachement " + fileUrl);
                throw new GuideException("Invalid Path in File Attachement " + fileUrl);
            }
            if (normalizedFileUrl.startsWith("/tmp/fd/af/")) {
                Resource fileResource = request.getResourceResolver().getResource(normalizedFileUrl);
                if (fileResource != null) {
                    fileRpm[0] = new FileRequestParameter(filename, fileResource);
                }
            } else {
                try {
                    ParameterMap newMap = new ParameterMap();
                    CustomParameterRequest newRequest = new CustomParameterRequest(request, newMap, "GET");
                    CustomResponse newResponse = new CustomResponse(response);
                    newRequest.getRequestDispatcher(normalizedFileUrl, new RequestDispatcherOptions()).forward(newRequest, newResponse);
                    byte[] fileBytes = newResponse.getCopy();
                    String contentType = newResponse.getContentType();
                    fileRpm[0] = new FileRequestParameter(filename, fileBytes, contentType);
                }
                catch (Exception e) {
                    this.logger.error("[AEMAF]Error while hitting REST URL", e);
                    throw new GuideException(e);
                }
            }
            GuideUtils.addToRequestMap(wrappedParameterMap, paramName, fileRpm);
        }
        return wrappedParameterMap;
    }

    private List<FileAttachmentWrapper> getFileAttachmentWrapperList(ParameterMap parameterMap) {
        ArrayList<FileAttachmentWrapper> fileAttachments = new ArrayList<FileAttachmentWrapper>();
        for (Map.Entry param : parameterMap.entrySet()) {
            RequestParameter[] rpm = (RequestParameter[])param.getValue();
            if (rpm != null && rpm.length > 0 && rpm[0] == null) {
                this.logger.error("getFileAttachmentWrapperList: rpm[0] is null for:" + (String)param.getKey());
                throw new GuideException("Exception: data loss - missing parameter value");
            }
            if (rpm == null || rpm.length <= 0 || rpm[0].isFormField()) continue;
            FileAttachmentWrapper fileAttachment = new FileAttachmentWrapper(rpm[0].getFileName(), rpm[0].getContentType(), rpm[0].get());
            fileAttachments.add(fileAttachment);
        }
        return fileAttachments;
    }

    private String prepareRedirectUrl(SlingHttpServletRequest request, String redirectUrl) throws UnsupportedEncodingException {
        redirectUrl = redirectUrl.indexOf("?") == -1 ? redirectUrl + "?" : redirectUrl + "&";
        Map<String, String> redirectParameters = GuideSubmitUtils.getRedirectParameters(request);
        if (redirectParameters != null && !redirectParameters.isEmpty()) {
            for (Map.Entry<String, String> param : redirectParameters.entrySet()) {
                redirectUrl = redirectUrl + URLEncoder.encode(param.getKey(), "UTF-8") + "=" + URLEncoder.encode(param.getValue(), "UTF-8") + "&";
            }
        }
        if (redirectUrl.charAt(redirectUrl.length() - 1) == '&' || redirectUrl.charAt(redirectUrl.length() - 1) == '?') {
            redirectUrl = redirectUrl.substring(0, redirectUrl.length() - 1);
        }
        return redirectUrl;
    }

    private void removeUnusedParameters(ParameterMap map) {
        map.remove("_useSignedPdf");
        map.remove("_asyncSubmit");
    }

    private JSONObject prepareSuccessPayload(SlingHttpServletRequest request, ValueMap properties, String redirectUrl) throws UnsupportedEncodingException {
        Resource aemFormResource;
        String aemFormCompPath = request.getParameter("aemFormComponentPath");
        String defaultThankYouPageUrl = request.getParameter("guideContainerPath") + "." + "guideThankYouPage.html";
        String defaultThankYouMessage = I18n.get(request, "Thank you for submitting the form.");
        String thankYouOption = null;
        String thankYouContent = null;
        String locale = this.getLocale(request);
        I18n i18n = new I18n(request.getResourceBundle(new Locale(locale)));
        Resource resource = aemFormResource = StringUtils.isBlank(aemFormCompPath) ? null : request.getResourceResolver().getResource(aemFormCompPath);
        if (redirectUrl == null) {
            redirectUrl = defaultThankYouPageUrl;
        }
        if (aemFormResource != null) {
            ValueMap aemFormProperties = aemFormResource.adaptTo(ValueMap.class);
            thankYouOption = aemFormProperties.get("thankyouConfig", GuideConstants.ThankYouOption.PAGE.toString());
            String thankYouPage = GuideUtils.getRedirectUrl(aemFormProperties.get("thankyouPage", ""), null);
            String thankYouMessage = aemFormProperties.get("thankyouMessage", defaultThankYouMessage);
            if (GuideConstants.ThankYouOption.PAGE.toString().equals(thankYouOption)) {
                thankYouContent = StringUtils.isBlank(thankYouPage) ? GuideSubmitUtils.addContextPath(defaultThankYouPageUrl, request.getContextPath()) : GuideSubmitUtils.addContextPath(thankYouPage, request.getContextPath());
                thankYouContent = this.prepareRedirectUrl(request, thankYouContent);
            } else {
                thankYouContent = thankYouMessage;
            }
        } else {
            thankYouOption = properties.get("thankYouOption", GuideConstants.ThankYouOption.PAGE.toString());
            if (GuideConstants.ThankYouOption.PAGE.toString().equals(thankYouOption)) {
                thankYouContent = GuideSubmitUtils.addContextPath(redirectUrl, request.getContextPath());
                thankYouContent = this.prepareRedirectUrl(request, thankYouContent);
            } else {
                thankYouContent = properties.get("thankYouMessage", defaultThankYouMessage);
                thankYouContent = GuideUtils.translateOrReturnOriginal(thankYouContent, i18n);
            }
        }
        JSONObject successPayload = new JSONObject();
        try {
            successPayload.put("thankYouOption", thankYouOption);
            successPayload.put("thankYouContent", thankYouContent);
        }
        catch (JSONException e) {
            this.logger.error("Error while writing JSON.", e);
        }
        return successPayload;
    }

    protected void bindTransactionRecorder(ITransactionRecorder iTransactionRecorder) {
        this.transactionRecorder = iTransactionRecorder;
    }

    protected void unbindTransactionRecorder(ITransactionRecorder iTransactionRecorder) {
        if (this.transactionRecorder == iTransactionRecorder) {
            this.transactionRecorder = null;
        }
    }

    protected void bindGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        this.guideModelTransformer = guideModelTransformer;
    }

    protected void unbindGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        if (this.guideModelTransformer == guideModelTransformer) {
            this.guideModelTransformer = null;
        }
    }

    protected void bindSignAgreementService(SignAgreementService signAgreementService) {
        this.signAgreementService = signAgreementService;
    }

    protected void unbindSignAgreementService(SignAgreementService signAgreementService) {
        if (this.signAgreementService == signAgreementService) {
            this.signAgreementService = null;
        }
    }

    protected void bindGuidePDFSubmitHelper(GuidePDFSubmitHelper guidePDFSubmitHelper) {
        this.guidePDFSubmitHelper = guidePDFSubmitHelper;
    }

    protected void unbindGuidePDFSubmitHelper(GuidePDFSubmitHelper guidePDFSubmitHelper) {
        if (this.guidePDFSubmitHelper == guidePDFSubmitHelper) {
            this.guidePDFSubmitHelper = null;
        }
    }

    protected void bindGuideStoreContentSubmission(GuideStoreContentSubmission guideStoreContentSubmission) {
        this.guideStoreContentSubmission = guideStoreContentSubmission;
    }

    protected void unbindGuideStoreContentSubmission(GuideStoreContentSubmission guideStoreContentSubmission) {
        if (this.guideStoreContentSubmission == guideStoreContentSubmission) {
            this.guideStoreContentSubmission = null;
        }
    }

    protected void bindFormsPortalPreProcessor(FormPortalSubmitPreprocessor formPortalSubmitPreprocessor) {
        this.formsPortalPreProcessor = formPortalSubmitPreprocessor;
    }

    protected void unbindFormsPortalPreProcessor(FormPortalSubmitPreprocessor formPortalSubmitPreprocessor) {
        if (this.formsPortalPreProcessor == formPortalSubmitPreprocessor) {
            this.formsPortalPreProcessor = null;
        }
    }
}

