/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.model;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
public class TextVariable {
    @Inject
    @Optional
    private String name;
    @Inject
    @Optional
    private String bindRef;
    @Inject
    @Optional
    @Named(value="_value")
    private String defaultValue;
    @Inject
    @Optional
    @Named(value="cq:master")
    private String master;
    private String dataType;
    private String displayPictureClause;
    @Self
    private Resource resource;
    private static Logger logger = LoggerFactory.getLogger(TextVariable.class);

    public String getName() {
        return this.name;
    }

    public String getBindRef() {
        return this.bindRef;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getMaster() {
        return this.master;
    }

    public String getDataType() {
        return this.dataType;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getVariableId() {
        return this.getResource().getName();
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDisplayPictureClause() {
        return this.displayPictureClause;
    }

    public void setDisplayPictureClause(String displayPictureClause) {
        this.displayPictureClause = displayPictureClause;
    }

    public boolean isLocked() {
        return true;
    }

    public JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("variableId", this.getVariableId());
            jsonObject.put("name", this.getName());
            jsonObject.put("bindRef", this.getBindRef());
            jsonObject.put("dataType", this.getDataType());
            jsonObject.put("_value", this.getDefaultValue());
            jsonObject.put("displayPictureClause", this.getDisplayPictureClause());
        }
        catch (JSONException exception) {
            logger.error("Error during creation of text variable.", exception);
        }
        return jsonObject;
    }
}

