/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideItemsContainer;
import com.adobe.aemds.guide.common.GuideNode;
import com.adobe.aemds.guide.common.GuidePanel;
import com.adobe.aemds.guide.service.AdaptiveFormConfigurationService;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideIntegrationService;
import com.adobe.aemds.guide.service.GuideModelTransformer;
import com.adobe.aemds.guide.service.GuideSchemaType;
import com.adobe.aemds.guide.utils.GuideContainerThreadLocal;
import com.adobe.aemds.guide.utils.GuideThemeUtils;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.JSONCreationOptions;
import com.adobe.aemds.guide.utils.NodeStructureUtils;
import com.adobe.forms.common.service.FormsCommonConfigurationService;
import com.adobe.forms.common.utils.TempStorageUtils;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.WCMMode;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.script.SimpleBindings;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;

public class GuideContainer
extends GuideNode {
    private GuideModelTransformer guideModelTransformer = null;
    private String defaultDataXml = null;
    private boolean renderCall = false;

    public GuideContainer() {
    }

    public GuideContainer(SlingHttpServletRequest request, Resource resource) {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("resource", (Object)resource);
        bindings.put("request", (Object)request);
        this.init(bindings);
    }

    public GuideContainer(Resource resource) {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("resource", (Object)resource);
        this.init(bindings);
    }

    public String getRedirect() {
        String redirectUrl = this.resourceProps.get("redirect", "");
        return GuideUtils.getRedirectUrl(redirectUrl, this.getPath());
    }

    public void setMaxCallCounter(SlingHttpServletRequest request) {
        AdaptiveFormConfigurationService adaptiveFormConfigurationService;
        boolean setSlingMaxCalls = false;
        SlingBindings slingBindings = GuideUtils.getSlingBinding(request);
        if (slingBindings != null && (adaptiveFormConfigurationService = slingBindings.getSling().getService(AdaptiveFormConfigurationService.class)) != null) {
            setSlingMaxCalls = adaptiveFormConfigurationService.isSlingMaxCallValueSmall();
        }
        if (setSlingMaxCalls && request.getAttribute("sling.max.calls") == null) {
            try {
                request.setAttribute("sling.max.calls", 20000);
            }
            catch (Exception e) {
                this.logger.error("Cannot increase sling max call value", e);
            }
        }
    }

    public Boolean isOldResponsiveLayoutUsed() {
        Resource rootPanelResource = this.getResource().getChild("rootPanel");
        return GuideUtils.hasOldResponsiveLayout(rootPanelResource);
    }

    @Override
    public Map<String, Object> getAuthoringConfig() {
        Map<String, Object> authoringConfig = super.getAuthoringConfig();
        authoringConfig.put("oldResponsiveLayoutUsed", this.isOldResponsiveLayoutUsed());
        String themePath = this.getThemePath();
        if (!themePath.isEmpty()) {
            authoringConfig.put("themePath", themePath);
            String themeClientLibPath = this.getThemeClientLibPath();
            if (StringUtils.isNotEmpty(themeClientLibPath)) {
                authoringConfig.put("themeClientlibPath", themeClientLibPath);
            }
        }
        String referredSchemaOrXdp = null;
        try {
            String aftargetVersion;
            String afVersion = this.getVersion();
            if (StringUtils.isNotBlank(afVersion)) {
                authoringConfig.put("fd:version", afVersion);
            }
            if (StringUtils.isNotBlank(aftargetVersion = this.getTargetVersion())) {
                authoringConfig.put("fd:targetVersion", aftargetVersion);
            }
            String ddRef = this.resourceProps.get("ddRef", "");
            String letterRef = this.resourceProps.get("letterRef", "");
            GuideSchemaType schemaType = this.getSchema();
            String schemaRef = this.getSchemaRef();
            if (StringUtils.isNotBlank(ddRef)) {
                referredSchemaOrXdp = ddRef;
                authoringConfig.put("ddRef", referredSchemaOrXdp);
            } else if (StringUtils.isNotBlank(letterRef)) {
                referredSchemaOrXdp = letterRef;
                authoringConfig.put("letterRef", referredSchemaOrXdp);
            } else if (GuideSchemaType.XDP.equals((Object)schemaType)) {
                referredSchemaOrXdp = schemaRef;
                authoringConfig.put("xdpRef", referredSchemaOrXdp);
            } else if (GuideSchemaType.XSD.equals((Object)schemaType)) {
                referredSchemaOrXdp = schemaRef;
                authoringConfig.put("xsdRef", referredSchemaOrXdp);
            } else if (StringUtils.isBlank(referredSchemaOrXdp) && StringUtils.isNotBlank(schemaRef)) {
                referredSchemaOrXdp = schemaRef;
                authoringConfig.put("schemaRef", referredSchemaOrXdp);
                if (GuideSchemaType.JSON.equals((Object)schemaType)) {
                    authoringConfig.put("schemaType", "jsonschema");
                } else if (GuideSchemaType.FDM.equals((Object)schemaType)) {
                    authoringConfig.put("schemaType", "formdatamodel");
                }
            }
            String dorType = this.getDoRType();
            authoringConfig.put("dorType", this.getDoRType());
            if (StringUtils.equals(dorType, "generate")) {
                authoringConfig.put("dorTemplateRef", this.getDorTemplateRef());
            }
        }
        catch (Exception e) {
            this.logger.error("AF: Unable to fetch xsdRef or xdpRef" + e.getMessage(), e);
        }
        return authoringConfig;
    }

    public String getDoRType() {
        return this.resourceProps.get("dorType", "none");
    }

    private String getThemePath() {
        return this.resourceProps.get("themeRef", "");
    }

    private String getThemeClientLibPath() {
        String themeClientLibRef = "";
        String themePath = this.getThemePath();
        if (!themePath.isEmpty()) {
            themePath = themePath + "/" + "jcr:content";
            ResourceResolver resourceResolver = this.getResource().getResourceResolver();
            Resource themeResource = resourceResolver.getResource(themePath);
            if (themeResource == null) {
                return "";
            }
            themeClientLibRef = GuideThemeUtils.getClientLibPath(themeResource);
        }
        return themeClientLibRef;
    }

    public String getXdpRef() {
        return this.resourceProps.get("xdpRef", "");
    }

    public String getLetterRef() {
        return this.resourceProps.get("letterRef", "");
    }

    public String getMetaTemplateRef() {
        return GuideUtils.getMetaTemplateRef(this.getResource());
    }

    public String getAutoSaveStrategyFilePath() {
        String autoSaveStrategyType = this.resourceProps.get("autoSaveStrategyType", "");
        if (autoSaveStrategyType != null && !autoSaveStrategyType.isEmpty()) {
            return autoSaveStrategyType;
        }
        return null;
    }

    public String getDorTemplateRef() {
        try {
            Resource guideContainer = this.getResource();
            ResourceResolver resourceResolver = guideContainer.getResourceResolver();
            String guideContainerPath = guideContainer.getPath();
            String runtimeLocale = this.slingRequest.getLocale().toString();
            return GuideUtils.getDoRTemplateRef(guideContainerPath, runtimeLocale, resourceResolver);
        }
        catch (Exception e) {
            this.logger.error("Error during fetching dorTemplateRef", e);
            return "";
        }
    }

    public Calendar getLastModifiedTime() {
        ValueMap properties = this.getResource().getParent().adaptTo(ValueMap.class);
        return (Calendar)((Object)properties.get("cq:lastModified", Calendar.class));
    }

    public String getXsdRef() {
        return this.resourceProps.get("xsdRef", "");
    }

    public String getSchemaRef() {
        String schemaRef = this.resourceProps.get("xsdRef", "");
        if (StringUtils.isBlank(schemaRef)) {
            schemaRef = this.getPropertyFromContainingPage("xsdRef");
        }
        if (StringUtils.isBlank(schemaRef) && StringUtils.isBlank(schemaRef = this.resourceProps.get("xdpRef", ""))) {
            schemaRef = this.getPropertyFromContainingPage("xdpRef");
        }
        if (StringUtils.isBlank(schemaRef) && StringUtils.isBlank(schemaRef = this.resourceProps.get("schemaRef", ""))) {
            schemaRef = this.getPropertyFromContainingPage("schemaRef");
        }
        return schemaRef;
    }

    private String getPropertyFromContainingPage(String property) {
        return GuideUtils.getInheritedProperty(this.getResource(), property);
    }

    public String getSchemaType() {
        return this.getSchema().getValue();
    }

    public String getPrefillService() {
        String prefillService = this.resourceProps.get("prefillService", "");
        if (StringUtils.isBlank(prefillService)) {
            prefillService = this.getPropertyFromContainingPage("prefillService");
        }
        return prefillService;
    }

    public GuideSchemaType getSchema() {
        GuideSchemaType type = GuideSchemaType.BASIC;
        String schemaType = this.resourceProps.get("schemaType", "");
        if (StringUtils.isNotBlank(schemaType)) {
            type = GuideSchemaType.getGuideSchemaType(schemaType);
        } else if (StringUtils.isNotBlank(this.resourceProps.get("xsdRef", ""))) {
            type = GuideSchemaType.XSD;
        } else if (StringUtils.isNotBlank(this.resourceProps.get("xdpRef", ""))) {
            type = GuideSchemaType.XDP;
        } else {
            String schemaTypeFromContainingPage = this.getPropertyFromContainingPage("schemaType");
            if (StringUtils.isNotBlank(schemaTypeFromContainingPage)) {
                type = GuideSchemaType.getGuideSchemaType(schemaTypeFromContainingPage);
            }
        }
        return type;
    }

    public String getCssFileRef() {
        return (String)((Object)this.resourceProps.get("cssFileRef", String.class));
    }

    @Override
    public String getClientLibRef() {
        return (String)((Object)this.resourceProps.get("clientLibRef", String.class));
    }

    public boolean isHasToolbar() {
        return this.getResource().getChild("toolbar") != null;
    }

    public String getAfPath() {
        return (String)((Object)this.resourceProps.get("afPath", String.class));
    }

    public GuideItemsContainer getToolbar() {
        Resource toolbarResource = this.getResource().getChild("toolbar");
        if (toolbarResource != null) {
            GuideItemsContainer guideItemsContainer = new GuideItemsContainer();
            SimpleBindings bindings = new SimpleBindings();
            bindings.put("resource", (Object)toolbarResource);
            bindings.put("request", (Object)this.slingRequest);
            guideItemsContainer.init(bindings);
            return guideItemsContainer;
        }
        return null;
    }

    public GuidePanel getRootPanel() {
        return GuideUtils.getRootPanel(this.getResource(), this.slingRequest);
    }

    public boolean isGuideSyncRequired() {
        boolean hasXDP = !"".equals(this.getXdpRef());
        return hasXDP && this.resourceProps.containsKey("formModelChanged");
    }

    private boolean isSignerAuthenticationCorrect(ValueMap signerProperties) {
        return !"PHONE".equals(signerProperties.get("securityOption", "")) || !StringUtils.isEmpty(signerProperties.get("countryCode", "")) && !StringUtils.isEmpty(signerProperties.get("phone", ""));
    }

    public boolean isAdobeSignEnabled() {
        return Boolean.valueOf(this.resourceProps.get("_useSignedPdf", "false"));
    }

    public boolean isFormFillerFirstSigner() {
        if (this.isAdobeSignEnabled()) {
            Resource signerInfoResource = this.getResource().getChild("signerInfo");
            ValueMap signerInfoProperties = signerInfoResource.getValueMap();
            return Boolean.valueOf(signerInfoProperties.get("firstSignerFormFiller", "false"));
        }
        return false;
    }

    public boolean isSignatureConfiguredCorrectly() {
        if (this.isAdobeSignEnabled()) {
            Resource signerInfoResource = this.getResource().getChild("signerInfo");
            ValueMap signerInfoProperties = signerInfoResource.getValueMap();
            if (StringUtils.isEmpty(signerInfoProperties.get("signConfigPath", "")) || StringUtils.isEmpty(signerInfoProperties.get("workflowType", ""))) {
                return false;
            }
            Iterator<Resource> signers = signerInfoResource.getChildren().iterator();
            if (!signers.hasNext()) {
                return false;
            }
            Resource firstSigner = signers.next();
            ValueMap firstSignerProperties = firstSigner.getValueMap();
            if (!(this.isFormFillerFirstSigner() && "userProfile".equals(firstSignerProperties.get("emailSource", "")) || !StringUtils.isEmpty(firstSignerProperties.get("email", "")))) {
                return false;
            }
            if (!this.isSignerAuthenticationCorrect(firstSignerProperties)) {
                return false;
            }
            while (signers.hasNext()) {
                Resource signer = signers.next();
                ValueMap signerProperties = signer.getValueMap();
                if (StringUtils.isEmpty(signerProperties.get("email", ""))) {
                    return false;
                }
                if (this.isSignerAuthenticationCorrect(signerProperties)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isMetaTemplateUpdated() {
        Resource metaTemplateResource;
        boolean isUpdated = false;
        String metaTemplateRef = this.getMetaTemplateRef();
        Date lmtOfMetaTemplate = new Date();
        Date lmtOfPrint = new Date();
        if (this.getResource() != null) {
            Resource print = this.getResource().getChild("view/print");
            if (print != null) {
                ValueMap map = print.getValueMap();
                lmtOfPrint = map.get("jcr:lastModified", lmtOfPrint);
            }
        } else {
            return false;
        }
        ResourceResolver resourceResolver = this.getResource().getResourceResolver();
        Resource resource = metaTemplateResource = StringUtils.isNotBlank(metaTemplateRef) ? resourceResolver.getResource(metaTemplateRef) : null;
        if (metaTemplateResource != null) {
            ValueMap map = metaTemplateResource.getValueMap();
            lmtOfMetaTemplate = (Date)((Object)map.get("jcr:created", Date.class));
            Resource jcrContent = metaTemplateResource.getChild("jcr:content");
            if (jcrContent != null && (map = jcrContent.getValueMap()).containsKey("jcr:lastModified")) {
                lmtOfMetaTemplate = (Date)((Object)map.get("jcr:lastModified", Date.class));
            }
        }
        if (lmtOfMetaTemplate.after(lmtOfPrint)) {
            isUpdated = true;
        }
        return isUpdated;
    }

    public boolean isShowAuthoringWarnings() {
        String resourceType = GuideUtils.getNormalizedNodeType(this.getResourceType(), this.getResourceSuperType());
        boolean showWarnings = true;
        if ("fd/adaddon/components/guideDocumentContainer".equals(resourceType) || "fd/ccm/web-channel/components/documentContainer/v1/documentContainer".equals(resourceType)) {
            showWarnings = false;
        }
        return showWarnings;
    }

    public String getStatusBarTitle() {
        I18n i18n = new I18n(this.slingRequest.getResourceBundle(this.slingRequest.getLocale()));
        return i18n.get("Adaptive Form Warnings");
    }

    public String getMobileLayout() {
        String returnLayout = "fd/af/layouts/mobile/simple";
        String mobileLayout = null;
        try {
            mobileLayout = (String)this.getLayoutProperty("mobileLayout");
        }
        catch (PersistenceException e) {
            this.logger.error("Exception while retrieving mobile layout. " + e.getMessage(), e);
        }
        if (mobileLayout != null && !mobileLayout.isEmpty()) {
            returnLayout = mobileLayout;
        }
        return returnLayout;
    }

    public Boolean getParseGridLayoutForMenu() {
        Boolean parseGridLayoutForMenu = null;
        try {
            parseGridLayoutForMenu = Boolean.valueOf(String.valueOf(this.getLayoutProperty("parseGridLayoutForMenu")));
        }
        catch (PersistenceException e) {
            this.logger.error("Exception while retrieving parseGridLayoutForMenu check. " + e.getMessage(), e);
        }
        if (parseGridLayoutForMenu == null) {
            parseGridLayoutForMenu = Boolean.FALSE;
        }
        return parseGridLayoutForMenu;
    }

    public String getXDPName() {
        String xdpRef = this.getXdpRef();
        if (xdpRef != null && xdpRef.length() > 0) {
            return StringUtils.substring(xdpRef, StringUtils.lastIndexOf((CharSequence)xdpRef, "/") + 1);
        }
        return null;
    }

    public boolean isXDPValid() {
        return GuideUtils.isXDPValid(this.getResource());
    }

    public void setGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        this.guideModelTransformer = guideModelTransformer;
    }

    private GuideModelTransformer getGuideModelTransformer() {
        SlingBindings bindings = GuideUtils.getSlingBinding(this.getSlingRequest());
        if (bindings == null) {
            return this.guideModelTransformer;
        }
        return bindings.getSling().getService(GuideModelTransformer.class);
    }

    private Map<String, String> getXfaJsonMap() throws GuideException {
        String xdpRef = this.getXdpRef();
        Map<String, String> xfaJsonMap = null;
        Boolean isValidXdp = xdpRef != null && xdpRef.length() > 0 && this.isXDPValid();
        if (isValidXdp.booleanValue()) {
            GuideModelTransformer guideModelTransformer = this.getGuideModelTransformer();
            xfaJsonMap = guideModelTransformer.exportXfaJson(this.getResource());
        }
        return xfaJsonMap;
    }

    public String getXfaRenderContext() throws GuideException {
        Map<String, String> xfaJsonMap;
        String xdpRef = this.getXdpRef();
        String renderContext = "";
        if (xdpRef != null && xdpRef.length() > 0 && (xfaJsonMap = this.getXfaJsonMap()) != null && xfaJsonMap.containsKey("xfaRenderContext")) {
            renderContext = xfaJsonMap.get("xfaRenderContext");
        }
        return renderContext;
    }

    public String getXfaJson() throws GuideException {
        Map<String, String> xfaJsonMap;
        String xdpRef = this.getXdpRef();
        String xfaJson = "";
        if (xdpRef != null && xdpRef.length() > 0 && (xfaJsonMap = this.getXfaJsonMap()) != null && xfaJsonMap.containsKey("formdom")) {
            xfaJson = xfaJsonMap.get("formdom");
        }
        return xfaJson;
    }

    public String getGuideCurrentStateJson(String locale) {
        String guideStatePathRef;
        String guideCurrentStateJson = "";
        GuideModelTransformer guideModelTransformer = this.getGuideModelTransformer();
        String guideStatePath = (String)this.slingRequest.getAttribute("guideStatePath");
        if (guideStatePath == null || guideStatePath.isEmpty()) {
            guideStatePath = this.slingRequest.getParameter("guideStatePath");
        }
        if ((guideStatePathRef = (String)this.slingRequest.getAttribute("guideStatePathRef")) == null || guideStatePathRef.isEmpty()) {
            guideStatePathRef = this.slingRequest.getParameter("guideStatePathRef");
        }
        if (guideStatePath != null && !guideStatePath.isEmpty()) {
            guideCurrentStateJson = guideModelTransformer.exportGuideState(guideStatePath);
        } else if (guideStatePathRef != null && !guideStatePathRef.isEmpty()) {
            guideCurrentStateJson = guideModelTransformer.exportGuideStateFromStore(guideStatePathRef);
        }
        if (guideCurrentStateJson.length() == 0) {
            Map prefillServiceParamMap;
            String prefillService;
            String data;
            boolean dataPresent = false;
            JSONCreationOptions options = new JSONCreationOptions();
            options.setI18n(this.i18n).setFormContainerPath(this.getFormContainerPath()).setLocale(new Locale(locale));
            String dataRef = (String)this.slingRequest.getAttribute("dataRef");
            if (dataRef == null || dataRef.isEmpty()) {
                dataRef = this.slingRequest.getParameter("dataRef");
            }
            if (dataRef != null && !dataRef.isEmpty()) {
                options.setDataRef(dataRef);
                dataPresent = true;
            }
            if ((data = (String)this.slingRequest.getAttribute("data")) == null || data.isEmpty()) {
                data = this.slingRequest.getParameter("data");
            }
            if (data != null && !data.isEmpty()) {
                options.setDataRef(null).setData(data);
                dataPresent = true;
            }
            if ((prefillService = this.getPrefillService()) != null) {
                dataPresent = true;
            }
            if ((prefillServiceParamMap = (Map)this.slingRequest.getAttribute("paramMap")) != null) {
                options.setPrefillServiceParams(prefillServiceParamMap);
            }
            boolean useTestDataPrefillService = true;
            if (this.slingRequest != null) {
                SlingBindings bindings;
                options.setRequest(this.slingRequest);
                if (this.slingRequest != null && (bindings = GuideUtils.getSlingBinding(this.slingRequest)) != null) {
                    FormsCommonConfigurationService formsCommonConfigurationService = bindings.getSling().getService(FormsCommonConfigurationService.class);
                    useTestDataPrefillService = formsCommonConfigurationService.useTestDataPrefillService();
                }
            }
            if (dataPresent || this.slingRequest != null && WCMMode.fromRequest(this.slingRequest).equals((Object)WCMMode.PREVIEW) && useTestDataPrefillService) {
                guideCurrentStateJson = guideModelTransformer.getDataJson(this.getResource(), options);
            }
        }
        return guideCurrentStateJson;
    }

    private String getFormContainerPath() {
        if (this.slingRequest == null) {
            return null;
        }
        String formContainerPath = (String)this.slingRequest.getAttribute("formContainerPath");
        if (formContainerPath == null) {
            formContainerPath = this.slingRequest.getParameter("formContainerPath");
        }
        return formContainerPath;
    }

    public String getGuideCurrentStateJson(String locale, String dataXml) {
        JSONCreationOptions options = new JSONCreationOptions();
        options.setData(dataXml).setI18n(this.i18n).setFormContainerPath(this.getFormContainerPath()).setLocale(new Locale(locale));
        return this.guideModelTransformer.getDataJson(this.getResource(), options);
    }

    public String getGuideContext() {
        return this.exportInitialGuideContext();
    }

    public String getGuideJson() {
        I18n i18ntemp = this.i18n;
        if (this.slingRequest != null && this.getIsEditMode().booleanValue()) {
            i18ntemp = null;
        }
        GuideModelTransformer guideModelTransformer = this.getGuideModelTransformer();
        return guideModelTransformer.exportGuideJson(this.getResource(), i18ntemp);
    }

    public String getLayout() {
        String layoutpath;
        try {
            String containerName = GuideContainerThreadLocal.getGuideContainerName();
            Map<String, Object> layoutproperties = containerName != null ? NodeStructureUtils.getLayoutProperties(this.slingRequest, this.getResource(), containerName) : (GuideUtils.isGuideContainerResource(this.getResource()) ? NodeStructureUtils.getLayoutProperties(this.slingRequest, this.getResource(), this.getResource().getName()) : NodeStructureUtils.getLayoutProperties(this.slingRequest, this.getResource(), "guideContainer"));
            layoutpath = (String)layoutproperties.get("sling:resourceType");
            if (layoutpath.startsWith("/libs/") || layoutpath.startsWith("/apps/")) {
                layoutpath = layoutpath.substring(6);
            }
        }
        catch (Exception ex) {
            this.logger.error("Unable to get layout of guide container" + ex.getMessage());
            throw new GuideException(ex.getMessage(), ex);
        }
        return layoutpath;
    }

    public List<String> getGuideIntegrationServiceScriptPaths() {
        SlingBindings bindings = (SlingBindings)this.slingRequest.getAttribute(SlingBindings.class.getName());
        GuideIntegrationService guideIntegrationService = bindings.getSling().getService(GuideIntegrationService.class);
        return guideIntegrationService.getScriptPaths();
    }

    private String createGuideInitializationState(String dataXml, String locale) {
        StringWriter jsonStringWriter = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter(jsonStringWriter);
        GuideModelTransformer guideTransformer = this.getGuideModelTransformer();
        Map<String, Object> jsonMap = guideTransformer.syncXfaProps(this, locale);
        try {
            jsonWriter.object();
            jsonWriter.key("guidejson").value(jsonMap.get("guidejson"));
            jsonWriter.key("guidecontext").value(this.getGuideContext());
            String mergedJson = null;
            if (this.slingRequest == null || !this.getIsEditMode().booleanValue()) {
                mergedJson = dataXml != null ? this.getGuideCurrentStateJson(locale, dataXml) : this.getGuideCurrentStateJson(locale);
            }
            jsonWriter.key("guidemergedjson").value(mergedJson);
            jsonWriter.key("xfajson").value(jsonMap.get("xfajson"));
            jsonWriter.key("xfarendercontext").value(this.getXfaRenderContext());
            jsonWriter.endObject();
        }
        catch (JSONException ex) {
            this.logger.error("Error in getting guide initialization state" + ex.getMessage());
            throw new GuideException(ex.getMessage(), ex);
        }
        return jsonStringWriter.toString();
    }

    public String getGuideInitializationState() {
        String locale = GuideUtils.getGuideRuntimeLocale(this.slingRequest, this.getResource());
        return this.createGuideInitializationState(null, locale);
    }

    public String getGuideInitializationState(String dataXml, String locale) {
        return this.createGuideInitializationState(dataXml, locale);
    }

    public void setRenderCall(boolean isRenderCall) {
        this.renderCall = isRenderCall;
    }

    public boolean isRenderCall() {
        return this.renderCall;
    }

    public JSONObject getCustomContextPropJson(HttpServletRequest request) {
        Object attr = request.getAttribute("customContextProperty");
        JSONObject customContextPropJson = new JSONObject();
        if (attr != null) {
            try {
                customContextPropJson = new JSONObject(attr.toString());
            }
            catch (JSONException e) {
                this.logger.error("Failed to parse JSON for customContextProperty attribute", e);
            }
        }
        return customContextPropJson;
    }

    public String getPagePath() {
        String path = "";
        Resource parent = this.getResource();
        while ((parent = parent.getParent()) != null) {
            if (!parent.isResourceType("foundation/components/page") && !parent.isResourceType("wcm/foundation/components/page")) continue;
            path = parent.getPath();
        }
        return path;
    }

    private String exportInitialGuideContext() throws GuideException {
        JSONObject contextObject = new JSONObject();
        try {
            SlingBindings bindings;
            SlingHttpServletRequest slingRequest;
            String guideName = this.getName();
            ValueMap guideProps = this.getResource().adaptTo(ValueMap.class);
            contextObject.put("guidePath", this.getPath());
            contextObject.put("guideName", guideName);
            GuideSchemaType schemaType = this.getSchema();
            String schemaRef = this.getSchemaRef();
            boolean isDataModelSet = false;
            if (GuideSchemaType.XSD.equals((Object)schemaType)) {
                contextObject.put("xsdRef", schemaRef);
                isDataModelSet = true;
            }
            if (GuideSchemaType.XDP.equals((Object)schemaType) && GuideUtils.isXDPValid(this.getResource())) {
                contextObject.put("xdpRef", schemaRef);
                isDataModelSet = true;
            }
            if (StringUtils.isNotBlank(schemaRef) && !isDataModelSet) {
                contextObject.put("schemaRef", schemaRef);
            }
            if (schemaType != null) {
                contextObject.put("schemaType", schemaType.getValue());
            }
            if ((slingRequest = this.getSlingRequest()) != null && (bindings = GuideUtils.getSlingBinding(this.getSlingRequest())) != null) {
                FormsCommonConfigurationService formsCommonConfigurationService = bindings.getSling().getService(FormsCommonConfigurationService.class);
                AdaptiveFormConfigurationService adaptiveFormConfigurationService = bindings.getSling().getService(AdaptiveFormConfigurationService.class);
                boolean isAnonymous = slingRequest.getAuthType() == null;
                String tempStorageConfig = formsCommonConfigurationService.getTempStorageConfig();
                contextObject.put("disablePreview", TempStorageUtils.isPreviewDisabled(tempStorageConfig, isAnonymous));
                contextObject.put("makeFileNameUnique", adaptiveFormConfigurationService.getMakeFileNamesUnique());
                contextObject.put("scriptingBehaviourVersion", adaptiveFormConfigurationService.getScriptingCompatibilityMode());
            }
        }
        catch (Exception e) {
            this.logger.error("Error in getting guideContext", e);
            throw new GuideException(e);
        }
        return contextObject.toString();
    }

    public boolean isMetaTemplateValid() {
        String metaTemplateRef = this.getMetaTemplateRef();
        return GuideUtils.isMetaTemplateValid(this.getResource().getResourceResolver(), metaTemplateRef);
    }

    public static GuideContainer from(Resource resource) {
        return new GuideContainer(resource);
    }

    public static GuideContainer from(SlingHttpServletRequest request, Resource resource) {
        return new GuideContainer(request, resource);
    }
}

