/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.transferobjects;

import com.adobe.aem.formsndocuments.util.FMConstants;
import com.adobe.aem.formsndocuments.util.FMUtils;
import com.adobe.aemforms.fm.exception.FormsMgrException;
import javax.jcr.Session;
import org.apache.sling.api.resource.Resource;

public class AssetInfo {
    private Resource resource;
    private FMConstants.CoreAssetType type;
    private String nonFMAssetPublishType;

    public AssetInfo(Resource resource, FMConstants.CoreAssetType type) throws FormsMgrException {
        if (resource == null) {
            Object[] args = new Object[]{"resource", resource};
            throw new FormsMgrException("AEM-FMG-700-001", args);
        }
        this.resource = resource;
        this.type = type;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public FMConstants.CoreAssetType getType() {
        return this.type;
    }

    public void setType(FMConstants.CoreAssetType type) {
        this.type = type;
    }

    public String getNonFMAssetPublishType() {
        return this.nonFMAssetPublishType;
    }

    public void setNonFMAssetType(String nonFMAssetPublishType) {
        this.nonFMAssetPublishType = nonFMAssetPublishType;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AssetInfo)) {
            return false;
        }
        AssetInfo formInfo = (AssetInfo)obj;
        return this.resource.getPath().equals(formInfo.resource.getPath());
    }

    public String toString() {
        return "Form Path : " + this.resource.getPath() + " Form Type : " + (Object)((Object)this.type);
    }

    public int hashCode() {
        return this.resource.getPath().hashCode();
    }

    public String getPublishAssetType() {
        switch (this.type) {
            case FORM: {
                return "Form Template";
            }
            case FORMSET: {
                return "Form Set";
            }
            case GUIDE: {
                return "Adaptive Form";
            }
            case PDFFORM: {
                return "PDF Form";
            }
            case PRINTFORM: {
                return "Document";
            }
            case RESOURCE: {
                return "Resource";
            }
            case AFFRAGMENT: {
                return "Adaptive Form Fragment";
            }
            case ADAPTIVEDOCUMENT: {
                return "Interactive Communication";
            }
            case THEME: {
                return "Theme";
            }
            case FORMDATAMODEL: {
                return "Form Data Model";
            }
            case NONFMASSET: {
                if (this.resource.getPath().startsWith("/content/forms/af")) {
                    return "AF CQ Page";
                }
                if (this.resource.getPath().startsWith("/etc")) {
                    return "Theme Clientlib";
                }
                if ("template".equals(this.nonFMAssetPublishType)) {
                    return "Adaptive Form Template";
                }
                if ("contentpolicy".equals(this.nonFMAssetPublishType)) {
                    return "Content Policy";
                }
                if (this.nonFMAssetPublishType != null) {
                    return this.nonFMAssetPublishType;
                }
            }
            case DOCUMENT_TEMPLATE: {
                return "Interactive Communication";
            }
        }
        return "Asset";
    }

    public long getLastModifiedOrCreatedTime(Session session) throws FormsMgrException {
        return FMUtils.getLastModifiedOrCreated(session, this.getResource().getPath());
    }
}

